/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.utils;

import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.TextUtils;
import com.luck.picture.lib.basic.PictureContentResolver;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.interfaces.OnCallbackListener;
import com.luck.picture.lib.thread.PictureThreadUtils;
import com.luck.picture.lib.utils.DateUtils;
import com.luck.picture.lib.utils.PictureFileUtils;
import com.luck.picture.lib.utils.SdkVersionUtils;
import com.luck.picture.lib.utils.ValueOf;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class DownloadFileUtils {
    public static void saveLocalFile(final Context context, final String path, final String mimeType, final OnCallbackListener<String> listener) {
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<String>(){

            @Override
            public String doInBackground() throws Throwable {
                OutputStream outputStream;
                InputStream inputStream;
                boolean bufferCopy;
                Uri uri;
                File dir;
                ContentValues contentValues = new ContentValues();
                String time = ValueOf.toString(System.currentTimeMillis());
                if (PictureMimeType.isHasVideo(mimeType)) {
                    contentValues.put("_display_name", DateUtils.getCreateFileName("VID_"));
                    contentValues.put("mime_type", TextUtils.isEmpty((CharSequence)mimeType) || mimeType.startsWith("image") ? "video/mp4" : mimeType);
                    if (SdkVersionUtils.isQ()) {
                        contentValues.put("datetaken", time);
                        contentValues.put("relative_path", Environment.DIRECTORY_MOVIES);
                    } else {
                        dir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_MOVIES);
                        contentValues.put("_data", dir.getAbsolutePath() + File.separator + DateUtils.getCreateFileName("VID_") + ".mp4");
                    }
                    uri = context.getContentResolver().insert(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, contentValues);
                } else {
                    contentValues.put("_display_name", DateUtils.getCreateFileName("IMG_"));
                    contentValues.put("mime_type", TextUtils.isEmpty((CharSequence)mimeType) || mimeType.startsWith("video") ? "image/jpeg" : mimeType);
                    if (SdkVersionUtils.isQ()) {
                        contentValues.put("datetaken", time);
                        contentValues.put("relative_path", "DCIM/Camera");
                    } else if (PictureMimeType.isHasGif(mimeType) || PictureMimeType.isUrlHasGif(path)) {
                        dir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
                        contentValues.put("_data", dir.getAbsolutePath() + File.separator + DateUtils.getCreateFileName("IMG_") + ".gif");
                    }
                    uri = context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
                }
                if (uri != null && (bufferCopy = PictureFileUtils.writeFileFromIS(inputStream = PictureMimeType.isHasHttp(path) ? new URL(path).openStream() : (PictureMimeType.isContent(path) ? PictureContentResolver.getContentResolverOpenInputStream(context, Uri.parse((String)path)) : new FileInputStream(path)), outputStream = PictureContentResolver.getContentResolverOpenOutputStream(context, uri)))) {
                    return PictureFileUtils.getPath(context, uri);
                }
                return null;
            }

            @Override
            public void onSuccess(String result) {
                PictureThreadUtils.cancel((PictureThreadUtils.Task)this);
                if (listener != null) {
                    listener.onCall(result);
                }
            }
        });
    }
}

