/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.magical;

import android.view.View;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.magical.ViewParams;
import java.util.ArrayList;
import java.util.List;

public class BuildRecycleItemViewParams {
    private static final List<ViewParams> viewParams = new ArrayList<ViewParams>();

    public static void clear() {
        if (viewParams.size() > 0) {
            viewParams.clear();
        }
    }

    public static ViewParams getItemViewParams(int position) {
        return viewParams.size() > position ? viewParams.get(position) : null;
    }

    public static void generateViewParams(RecyclerView recyclerView, int statusBarHeight) {
        ArrayList<View> views = new ArrayList<View>();
        int childCount = recyclerView.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View view = recyclerView.getChildAt(i);
            if (view == null) continue;
            views.add(view);
        }
        GridLayoutManager layoutManager = (GridLayoutManager)recyclerView.getLayoutManager();
        if (layoutManager == null) {
            return;
        }
        int totalCount = layoutManager.getItemCount();
        int firstPos = layoutManager.findFirstVisibleItemPosition();
        int lastPos = layoutManager.findLastVisibleItemPosition();
        lastPos = lastPos > totalCount ? totalCount - 1 : lastPos;
        BuildRecycleItemViewParams.fillPlaceHolder(views, totalCount, firstPos, lastPos);
        viewParams.clear();
        for (int i = 0; i < views.size(); ++i) {
            View view = (View)views.get(i);
            ViewParams viewParam = new ViewParams();
            if (view == null) {
                viewParam.setLeft(0);
                viewParam.setTop(0);
                viewParam.setWidth(0);
                viewParam.setHeight(0);
            } else {
                int[] location = new int[2];
                view.getLocationOnScreen(location);
                viewParam.setLeft(location[0]);
                viewParam.setTop(location[1] - statusBarHeight);
                viewParam.setWidth(view.getWidth());
                viewParam.setHeight(view.getHeight());
            }
            viewParams.add(viewParam);
        }
    }

    private static void fillPlaceHolder(List<View> originImageList, int totalCount, int firstPos, int lastPos) {
        int i;
        if (firstPos > 0) {
            for (i = firstPos; i >= 1; --i) {
                originImageList.add(0, null);
            }
        }
        if (lastPos < totalCount) {
            for (i = totalCount - 1 - lastPos; i >= 1; --i) {
                originImageList.add(null);
            }
        }
    }
}

