/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.loader;

import android.content.Context;
import android.text.TextUtils;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.config.SelectMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.entity.MediaExtraInfo;
import com.luck.picture.lib.utils.MediaUtils;
import com.luck.picture.lib.utils.SdkVersionUtils;
import com.luck.picture.lib.utils.SortUtils;
import com.luck.picture.lib.utils.ValueOf;
import java.io.File;
import java.io.FileFilter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;

public final class SandboxFileLoader {
    public static LocalMediaFolder loadInAppSandboxFolderFile(Context context, String sandboxDir) {
        ArrayList<LocalMedia> list = SandboxFileLoader.loadInAppSandboxFile(context, sandboxDir);
        LocalMediaFolder folder = null;
        if (list != null && list.size() > 0) {
            SortUtils.sortLocalMediaAddedTime(list);
            LocalMedia firstMedia = list.get(0);
            folder = new LocalMediaFolder();
            folder.setFolderName(firstMedia.getParentFolderName());
            folder.setFirstImagePath(firstMedia.getPath());
            folder.setFirstMimeType(firstMedia.getMimeType());
            folder.setBucketId(firstMedia.getBucketId());
            folder.setFolderTotalNum(list.size());
            folder.setData(list);
        }
        return folder;
    }

    public static ArrayList<LocalMedia> loadInAppSandboxFile(Context context, String sandboxDir) {
        if (TextUtils.isEmpty((CharSequence)sandboxDir)) {
            return null;
        }
        ArrayList<LocalMedia> list = new ArrayList<LocalMedia>();
        File sandboxFile = new File(sandboxDir);
        if (sandboxFile.exists()) {
            File[] files = sandboxFile.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return !file.isDirectory();
                }
            });
            if (files == null) {
                return list;
            }
            PictureSelectionConfig config = PictureSelectionConfig.getInstance();
            for (File f : files) {
                long duration;
                int height;
                int width;
                String mimeType = MediaUtils.getMimeTypeFromMediaUrl(f.getAbsolutePath());
                if (config.chooseMode == SelectMimeType.ofImage()) {
                    if (!PictureMimeType.isHasImage(mimeType)) {
                        continue;
                    }
                } else if (config.chooseMode != SelectMimeType.ofVideo() ? config.chooseMode == SelectMimeType.ofAudio() && !PictureMimeType.isHasAudio(mimeType) : !PictureMimeType.isHasVideo(mimeType)) continue;
                if (config.queryOnlyList != null && config.queryOnlyList.size() > 0 && !config.queryOnlyList.contains(mimeType) || !config.isGif && PictureMimeType.isHasGif(mimeType)) continue;
                String absolutePath = f.getAbsolutePath();
                long size = f.length();
                long id2 = f.lastModified() / 1000L;
                try {
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    md.update(absolutePath.getBytes());
                    id2 = new BigInteger(1, md.digest()).longValue();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                long bucketId = ValueOf.toLong(sandboxFile.getName().hashCode());
                long dateTime = f.lastModified() / 1000L;
                if (PictureMimeType.isHasVideo(mimeType)) {
                    MediaExtraInfo videoSize = MediaUtils.getVideoSize(context, absolutePath);
                    width = videoSize.getWidth();
                    height = videoSize.getHeight();
                    duration = videoSize.getDuration();
                } else if (PictureMimeType.isHasAudio(mimeType)) {
                    MediaExtraInfo audioSize = MediaUtils.getAudioSize(context, absolutePath);
                    width = audioSize.getWidth();
                    height = audioSize.getHeight();
                    duration = audioSize.getDuration();
                } else {
                    MediaExtraInfo imageSize = MediaUtils.getImageSize(context, absolutePath);
                    width = imageSize.getWidth();
                    height = imageSize.getHeight();
                    duration = 0L;
                }
                if ((PictureMimeType.isHasVideo(mimeType) || PictureMimeType.isHasAudio(mimeType)) && (config.videoMinSecond > 0 && duration < (long)config.videoMinSecond || config.videoMaxSecond > 0 && duration > (long)config.videoMaxSecond || duration == 0L || size <= 0L)) continue;
                LocalMedia media = LocalMedia.parseLocalMedia(id2, absolutePath, absolutePath, f.getName(), sandboxFile.getName(), duration, config.chooseMode, mimeType, width, height, size, bucketId, dateTime);
                media.setSandboxPath(SdkVersionUtils.isQ() ? absolutePath : null);
                list.add(media);
            }
        }
        return list;
    }
}

