/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Bundle;
import android.os.Vibrator;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.MarginPageTransformer;
import androidx.viewpager2.widget.ViewPager2;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PicturePreviewAdapter;
import com.luck.picture.lib.adapter.holder.BasePreviewHolder;
import com.luck.picture.lib.adapter.holder.PreviewGalleryAdapter;
import com.luck.picture.lib.adapter.holder.PreviewVideoHolder;
import com.luck.picture.lib.basic.PictureCommonFragment;
import com.luck.picture.lib.basic.PictureMediaScannerConnection;
import com.luck.picture.lib.basic.PictureSelectorSupporterActivity;
import com.luck.picture.lib.config.Crop;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.config.ResourceSource;
import com.luck.picture.lib.decoration.GridSpacingItemDecoration;
import com.luck.picture.lib.decoration.WrapContentLinearLayoutManager;
import com.luck.picture.lib.dialog.PictureCommonDialog;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.interfaces.OnCallbackListener;
import com.luck.picture.lib.interfaces.OnQueryAlbumListener;
import com.luck.picture.lib.interfaces.OnQueryDataResultListener;
import com.luck.picture.lib.loader.LocalMediaLoader;
import com.luck.picture.lib.loader.LocalMediaPageLoader;
import com.luck.picture.lib.magical.BuildRecycleItemViewParams;
import com.luck.picture.lib.magical.MagicalView;
import com.luck.picture.lib.magical.OnMagicalViewCallback;
import com.luck.picture.lib.magical.ViewParams;
import com.luck.picture.lib.manager.SelectedManager;
import com.luck.picture.lib.style.PictureWindowAnimationStyle;
import com.luck.picture.lib.style.SelectMainStyle;
import com.luck.picture.lib.utils.ActivityCompatHelper;
import com.luck.picture.lib.utils.DensityUtil;
import com.luck.picture.lib.utils.DownloadFileUtils;
import com.luck.picture.lib.utils.MediaUtils;
import com.luck.picture.lib.utils.StyleUtils;
import com.luck.picture.lib.utils.ValueOf;
import com.luck.picture.lib.widget.BottomNavBar;
import com.luck.picture.lib.widget.CompleteSelectView;
import com.luck.picture.lib.widget.PreviewBottomNavBar;
import com.luck.picture.lib.widget.PreviewTitleBar;
import com.luck.picture.lib.widget.TitleBar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PictureSelectorPreviewFragment
extends PictureCommonFragment {
    public static final String TAG = PictureSelectorPreviewFragment.class.getSimpleName();
    private ArrayList<LocalMedia> mData = new ArrayList();
    private PreviewTitleBar titleBar;
    private PreviewBottomNavBar bottomNarBar;
    private MagicalView magicalView;
    private ViewPager2 viewPager;
    private PicturePreviewAdapter viewPageAdapter;
    protected boolean isHasMore = true;
    private int curPosition;
    private boolean isBottomPreview;
    private boolean isFirstLoaded;
    private boolean isSaveInstanceState;
    private String currentAlbum;
    private boolean isShowCamera;
    private boolean isExternalPreview;
    private boolean isDisplayDelete;
    private boolean isAnimationStart;
    private int totalNum;
    private int screenWidth;
    private int screenHeight;
    private long mBucketId = -1L;
    private TextView tvSelected;
    private TextView tvSelectedWord;
    private View selectClickArea;
    private CompleteSelectView completeSelectView;
    private boolean needScaleBig = true;
    private boolean needScaleSmall = false;
    private RecyclerView mGalleryRecycle;
    private PreviewGalleryAdapter mGalleryAdapter;
    private List<View> mAnimViews;
    private final ViewPager2.OnPageChangeCallback pageChangeCallback = new ViewPager2.OnPageChangeCallback(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (PictureSelectorPreviewFragment.this.mData.size() > position) {
                LocalMedia currentMedia = positionOffsetPixels < PictureSelectorPreviewFragment.this.screenWidth / 2 ? (LocalMedia)PictureSelectorPreviewFragment.this.mData.get(position) : (LocalMedia)PictureSelectorPreviewFragment.this.mData.get(position + 1);
                PictureSelectorPreviewFragment.this.tvSelected.setSelected(PictureSelectorPreviewFragment.this.isSelected(currentMedia));
                PictureSelectorPreviewFragment.this.notifyGallerySelectMedia(currentMedia);
                PictureSelectorPreviewFragment.this.notifySelectNumberStyle(currentMedia);
            }
        }

        public void onPageSelected(int position) {
            PictureSelectorPreviewFragment.this.curPosition = position;
            PictureSelectorPreviewFragment.this.titleBar.setTitle(PictureSelectorPreviewFragment.this.curPosition + 1 + "/" + PictureSelectorPreviewFragment.this.totalNum);
            if (PictureSelectorPreviewFragment.this.mData.size() > position) {
                LocalMedia currentMedia = (LocalMedia)PictureSelectorPreviewFragment.this.mData.get(position);
                PictureSelectorPreviewFragment.this.notifySelectNumberStyle(currentMedia);
                if (!PictureSelectorPreviewFragment.this.isExternalPreview && !PictureSelectorPreviewFragment.this.isBottomPreview && ((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).config.isPreviewZoomEffect) {
                    PictureSelectorPreviewFragment.this.changeMagicalViewParams(position);
                    BasePreviewHolder currentHolder = PictureSelectorPreviewFragment.this.viewPageAdapter.getCurrentHolder(position);
                    if (currentHolder instanceof PreviewVideoHolder) {
                        PreviewVideoHolder videoHolder = (PreviewVideoHolder)currentHolder;
                        if (videoHolder.ivPlayButton.getVisibility() == 8) {
                            videoHolder.ivPlayButton.setVisibility(0);
                        }
                    }
                }
                PictureSelectorPreviewFragment.this.notifyGallerySelectMedia(currentMedia);
                PictureSelectorPreviewFragment.this.bottomNarBar.isDisplayEditor(PictureMimeType.isHasVideo(currentMedia.getMimeType()));
                if (!(PictureSelectorPreviewFragment.this.isExternalPreview || PictureSelectorPreviewFragment.this.isBottomPreview || ((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).config.isOnlySandboxDir || !((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).config.isPageStrategy || !PictureSelectorPreviewFragment.this.isHasMore || position != PictureSelectorPreviewFragment.this.viewPageAdapter.getItemCount() - 1 - 10 && position != PictureSelectorPreviewFragment.this.viewPageAdapter.getItemCount() - 1)) {
                    PictureSelectorPreviewFragment.this.loadMoreData();
                }
            }
        }
    };

    public static PictureSelectorPreviewFragment newInstance() {
        PictureSelectorPreviewFragment fragment = new PictureSelectorPreviewFragment();
        fragment.setArguments(new Bundle());
        return fragment;
    }

    public void setInternalPreviewData(boolean isBottomPreview, String currentAlbumName, boolean isShowCamera, int position, int totalNum, int page, long currentBucketId, ArrayList<LocalMedia> data) {
        this.mPage = page;
        this.mBucketId = currentBucketId;
        this.mData = data;
        this.totalNum = totalNum;
        this.curPosition = position;
        this.currentAlbum = currentAlbumName;
        this.isShowCamera = isShowCamera;
        this.isBottomPreview = isBottomPreview;
    }

    public void setExternalPreviewData(int position, int totalNum, ArrayList<LocalMedia> data, boolean isDisplayDelete) {
        this.mData = data;
        this.totalNum = totalNum;
        this.curPosition = position;
        this.isDisplayDelete = isDisplayDelete;
        this.isExternalPreview = true;
        PictureSelectionConfig.getInstance().isPreviewZoomEffect = false;
    }

    @Override
    public int getResourceId() {
        int layoutResourceId = ResourceSource.getLayoutResource(this.getContext(), 2);
        if (layoutResourceId != 0) {
            return layoutResourceId;
        }
        return R.layout.ps_fragment_preview;
    }

    @Override
    public void onSelectedChange(boolean isAddRemove, LocalMedia currentMedia) {
        this.tvSelected.setSelected(SelectedManager.getSelectedResult().contains(currentMedia));
        this.bottomNarBar.setSelectedChange();
        this.completeSelectView.setSelectedChange(true);
        this.notifySelectNumberStyle(currentMedia);
        this.notifyPreviewGalleryData(isAddRemove, currentMedia);
    }

    @Override
    public void onCheckOriginalChange() {
        this.bottomNarBar.setOriginalCheck();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.reStartSavedInstance(savedInstanceState);
        this.isSaveInstanceState = savedInstanceState != null;
        this.screenWidth = DensityUtil.getScreenWidth(this.getContext());
        this.screenHeight = DensityUtil.getScreenHeight(this.getContext());
        this.titleBar = (PreviewTitleBar)view.findViewById(R.id.title_bar);
        this.tvSelected = (TextView)view.findViewById(R.id.ps_tv_selected);
        this.tvSelectedWord = (TextView)view.findViewById(R.id.ps_tv_selected_word);
        this.selectClickArea = view.findViewById(R.id.select_click_area);
        this.completeSelectView = (CompleteSelectView)view.findViewById(R.id.ps_complete_select);
        this.magicalView = (MagicalView)view.findViewById(R.id.magical);
        this.viewPager = new ViewPager2(this.getContext());
        this.bottomNarBar = (PreviewBottomNavBar)view.findViewById(R.id.bottom_nar_bar);
        this.magicalView.setMagicalContent((View)this.viewPager);
        this.mAnimViews = new ArrayList<View>();
        this.mAnimViews.add((View)this.titleBar);
        this.mAnimViews.add((View)this.tvSelected);
        this.mAnimViews.add((View)this.tvSelectedWord);
        this.mAnimViews.add(this.selectClickArea);
        this.mAnimViews.add((View)this.completeSelectView);
        this.mAnimViews.add((View)this.bottomNarBar);
        this.initTitleBar();
        if (this.isExternalPreview) {
            if (savedInstanceState != null || this.mData.size() == 0) {
                this.mData = new ArrayList<LocalMedia>(SelectedManager.getSelectedPreviewResult());
            }
            this.magicalView.setBackgroundAlpha(1.0f);
            SelectedManager.clearExternalPreviewData();
            this.externalPreviewStyle();
            this.initViewPagerData();
        } else {
            this.initLoader();
            this.initBottomNavBar();
            this.initPreviewSelectGallery((ViewGroup)view);
            this.initComplete();
            this.iniMagicalView();
            if (savedInstanceState != null && this.mData.size() == 0) {
                if (this.isBottomPreview) {
                    this.mData = new ArrayList<LocalMedia>(SelectedManager.getSelectedResult());
                    this.initViewPagerData();
                } else if (this.config.isPageStrategy) {
                    this.loadData(this.mPage * this.config.pageSize);
                } else {
                    this.mLoader = new LocalMediaPageLoader(this.getContext(), this.config);
                    this.loadData(this.totalNum);
                }
            } else {
                this.initViewPagerData();
            }
        }
    }

    @Override
    public void reStartSavedInstance(Bundle savedInstanceState) {
        super.reStartSavedInstance(savedInstanceState);
        if (savedInstanceState != null) {
            this.mPage = savedInstanceState.getInt("com.luck.picture.lib.current_page", 1);
            this.mBucketId = savedInstanceState.getLong("com.luck.picture.lib.current_bucketId", -1L);
            this.curPosition = savedInstanceState.getInt("com.luck.picture.lib.current_preview_position", this.curPosition);
            this.isShowCamera = savedInstanceState.getBoolean("com.luck.picture.lib.display_camera", this.isShowCamera);
            this.totalNum = savedInstanceState.getInt("com.luck.picture.lib.current_album_total", this.totalNum);
            this.isExternalPreview = savedInstanceState.getBoolean("com.luck.picture.lib.external_preview", this.isExternalPreview);
            this.isDisplayDelete = savedInstanceState.getBoolean("com.luck.picture.lib.external_preview_display_delete", this.isDisplayDelete);
            this.isBottomPreview = savedInstanceState.getBoolean("com.luck.picture.lib.bottom_preview", this.isBottomPreview);
            this.currentAlbum = savedInstanceState.getString("com.luck.picture.lib.current_album_name", "");
        }
    }

    private void iniMagicalView() {
        if (this.isBottomPreview) {
            this.magicalView.setBackgroundAlpha(1.0f);
        } else if (this.config.isPreviewZoomEffect) {
            if (this.isSaveInstanceState) {
                this.magicalView.setBackgroundAlpha(1.0f);
                for (int i = 0; i < this.mAnimViews.size(); ++i) {
                    if (this.mAnimViews.get(i) instanceof TitleBar) continue;
                    this.mAnimViews.get(i).setAlpha(1.0f);
                }
            } else {
                this.magicalView.setBackgroundAlpha(0.0f);
                for (int i = 0; i < this.mAnimViews.size(); ++i) {
                    if (this.mAnimViews.get(i) instanceof TitleBar) continue;
                    this.mAnimViews.get(i).setAlpha(0.0f);
                }
            }
            this.setMagicalViewAction();
        } else {
            this.magicalView.setBackgroundAlpha(1.0f);
        }
    }

    private void setMagicalViewAction() {
        this.magicalView.setOnMojitoViewCallback(new OnMagicalViewCallback(){

            @Override
            public void onBeginBackMinAnim() {
                BasePreviewHolder currentHolder = PictureSelectorPreviewFragment.this.viewPageAdapter.getCurrentHolder(PictureSelectorPreviewFragment.this.viewPager.getCurrentItem());
                if (currentHolder == null) {
                    return;
                }
                if (currentHolder.coverImageView.getVisibility() == 8) {
                    currentHolder.coverImageView.setVisibility(0);
                }
                if (currentHolder instanceof PreviewVideoHolder) {
                    PreviewVideoHolder videoHolder = (PreviewVideoHolder)currentHolder;
                    if (videoHolder.ivPlayButton.getVisibility() == 0) {
                        videoHolder.ivPlayButton.setVisibility(8);
                    }
                }
            }

            @Override
            public void onBeginMagicalAnimComplete(MagicalView mojitoView, boolean showImmediately) {
                BasePreviewHolder currentHolder = PictureSelectorPreviewFragment.this.viewPageAdapter.getCurrentHolder(PictureSelectorPreviewFragment.this.viewPager.getCurrentItem());
                if (currentHolder == null) {
                    return;
                }
                LocalMedia media = (LocalMedia)PictureSelectorPreviewFragment.this.mData.get(PictureSelectorPreviewFragment.this.viewPager.getCurrentItem());
                if (MediaUtils.isLongImage(media.getWidth(), media.getHeight())) {
                    currentHolder.coverImageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
                } else {
                    currentHolder.coverImageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
                }
                if (currentHolder instanceof PreviewVideoHolder) {
                    PreviewVideoHolder videoHolder = (PreviewVideoHolder)currentHolder;
                    if (videoHolder.ivPlayButton.getVisibility() == 8) {
                        videoHolder.ivPlayButton.setVisibility(0);
                    }
                }
            }

            @Override
            public void onBackgroundAlpha(float alpha) {
                for (int i = 0; i < PictureSelectorPreviewFragment.this.mAnimViews.size(); ++i) {
                    if (PictureSelectorPreviewFragment.this.mAnimViews.get(i) instanceof TitleBar) continue;
                    ((View)PictureSelectorPreviewFragment.this.mAnimViews.get(i)).setAlpha(alpha);
                }
            }

            @Override
            public void onMagicalViewFinish() {
                PictureSelectorPreviewFragment.this.iBridgePictureBehavior.onSelectFinish(false, null);
            }

            @Override
            public void onBeginBackMinMagicalFinish(boolean isResetSize) {
                ViewParams itemViewParams = BuildRecycleItemViewParams.getItemViewParams(PictureSelectorPreviewFragment.this.isShowCamera ? PictureSelectorPreviewFragment.this.curPosition + 1 : PictureSelectorPreviewFragment.this.curPosition);
                if (itemViewParams == null) {
                    return;
                }
                BasePreviewHolder currentHolder = PictureSelectorPreviewFragment.this.viewPageAdapter.getCurrentHolder(PictureSelectorPreviewFragment.this.viewPager.getCurrentItem());
                if (currentHolder == null) {
                    return;
                }
                currentHolder.coverImageView.getLayoutParams().width = itemViewParams.width;
                currentHolder.coverImageView.getLayoutParams().height = itemViewParams.height;
                currentHolder.coverImageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            }
        });
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("com.luck.picture.lib.current_page", this.mPage);
        outState.putLong("com.luck.picture.lib.current_bucketId", this.mBucketId);
        outState.putInt("com.luck.picture.lib.current_preview_position", this.curPosition);
        outState.putInt("com.luck.picture.lib.current_album_total", this.totalNum);
        outState.putBoolean("com.luck.picture.lib.external_preview", this.isExternalPreview);
        outState.putBoolean("com.luck.picture.lib.external_preview_display_delete", this.isDisplayDelete);
        outState.putBoolean("com.luck.picture.lib.display_camera", this.isShowCamera);
        outState.putBoolean("com.luck.picture.lib.bottom_preview", this.isBottomPreview);
        outState.putString("com.luck.picture.lib.current_album_name", this.currentAlbum);
        if (this.isExternalPreview) {
            SelectedManager.addSelectedPreviewResult(this.mData);
        }
    }

    @Override
    @Nullable
    public Animation onCreateAnimation(int transit, boolean enter, int nextAnim) {
        if (!this.isBottomPreview && !this.isExternalPreview && this.config.isPreviewZoomEffect) {
            return null;
        }
        PictureWindowAnimationStyle windowAnimationStyle = PictureSelectionConfig.selectorStyle.getWindowAnimationStyle();
        if (windowAnimationStyle.activityPreviewEnterAnimation != 0 && windowAnimationStyle.activityPreviewExitAnimation != 0) {
            if (enter) {
                return AnimationUtils.loadAnimation((Context)this.getActivity(), (int)windowAnimationStyle.activityPreviewEnterAnimation);
            }
            this.onExitFragment();
            return AnimationUtils.loadAnimation((Context)this.getActivity(), (int)windowAnimationStyle.activityPreviewExitAnimation);
        }
        return super.onCreateAnimation(transit, enter, nextAnim);
    }

    @Override
    public void sendChangeSubSelectPositionEvent(boolean adapterChange) {
        if (PictureSelectionConfig.selectorStyle.getSelectMainStyle().isPreviewSelectNumberStyle() && PictureSelectionConfig.selectorStyle.getSelectMainStyle().isSelectNumberStyle()) {
            for (int index = 0; index < SelectedManager.getCount(); ++index) {
                LocalMedia media = SelectedManager.getSelectedResult().get(index);
                media.setNum(index + 1);
            }
        }
    }

    @Override
    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (!this.isBottomPreview && !this.isExternalPreview && this.config.isPreviewZoomEffect && this.mData.size() > this.curPosition) {
            LocalMedia media = this.mData.get(this.curPosition);
            int[] size = this.getRealSizeFromMedia(media);
            ViewParams viewParams = BuildRecycleItemViewParams.getItemViewParams(this.isShowCamera ? this.curPosition + 1 : this.curPosition);
            if (viewParams == null || size[0] == 0 || size[1] == 0) {
                this.magicalView.setViewParams(0, 0, 0, 0, size[0], size[1]);
                this.magicalView.resetStartNormal(size[0], size[1], false);
            } else {
                this.magicalView.setViewParams(viewParams.left, viewParams.top, viewParams.width, viewParams.height, size[0], size[1]);
                this.magicalView.resetStart();
            }
        }
    }

    protected void initLoader() {
        this.mLoader = this.config.isPageStrategy ? new LocalMediaPageLoader(this.getContext(), this.config) : new LocalMediaLoader(this.getContext(), this.config);
    }

    private void loadData(int pageSize) {
        if (this.config.isOnlySandboxDir) {
            if (PictureSelectionConfig.loaderDataEngine != null) {
                PictureSelectionConfig.loaderDataEngine.loadOnlyInAppDirAllMediaData(this.getContext(), new OnQueryAlbumListener<LocalMediaFolder>(){

                    @Override
                    public void onComplete(LocalMediaFolder folder) {
                        PictureSelectorPreviewFragment.this.handleLoadData(folder.getData());
                    }
                });
            } else {
                this.mLoader.loadOnlyInAppDirAllMedia(new OnQueryAlbumListener<LocalMediaFolder>(){

                    @Override
                    public void onComplete(LocalMediaFolder folder) {
                        PictureSelectorPreviewFragment.this.handleLoadData(folder.getData());
                    }
                });
            }
        } else if (PictureSelectionConfig.loaderDataEngine != null) {
            PictureSelectionConfig.loaderDataEngine.loadFirstPageMediaData(this.getContext(), this.mBucketId, 1, pageSize, new OnQueryDataResultListener<LocalMedia>(){

                @Override
                public void onComplete(ArrayList<LocalMedia> result, boolean isHasMore) {
                    PictureSelectorPreviewFragment.this.handleLoadData(result);
                }
            });
        } else {
            this.mLoader.loadFirstPageMedia(this.mBucketId, pageSize, new OnQueryDataResultListener<LocalMedia>(){

                @Override
                public void onComplete(ArrayList<LocalMedia> result, boolean isHasMore) {
                    PictureSelectorPreviewFragment.this.handleLoadData(result);
                }
            });
        }
    }

    private void handleLoadData(ArrayList<LocalMedia> result) {
        if (ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            return;
        }
        this.mData = result;
        if (this.mData.size() == 0) {
            this.iBridgePictureBehavior.onSelectFinish(false, null);
            return;
        }
        int position = this.isShowCamera ? 0 : -1;
        for (int i = 0; i < this.mData.size(); ++i) {
            this.mData.get(i).setPosition(++position);
        }
        this.initViewPagerData();
    }

    private void loadMoreData() {
        ++this.mPage;
        if (PictureSelectionConfig.loaderDataEngine != null) {
            PictureSelectionConfig.loaderDataEngine.loadMoreMediaData(this.getContext(), this.mBucketId, this.mPage, this.config.pageSize, this.config.pageSize, new OnQueryDataResultListener<LocalMedia>(){

                @Override
                public void onComplete(ArrayList<LocalMedia> result, boolean isHasMore) {
                    PictureSelectorPreviewFragment.this.handleMoreData(result, isHasMore);
                }
            });
        } else {
            this.mLoader.loadPageMediaData(this.mBucketId, this.mPage, this.config.pageSize, new OnQueryDataResultListener<LocalMedia>(){

                @Override
                public void onComplete(ArrayList<LocalMedia> result, boolean isHasMore) {
                    PictureSelectorPreviewFragment.this.handleMoreData(result, isHasMore);
                }
            });
        }
    }

    private void handleMoreData(List<LocalMedia> result, boolean isHasMore) {
        if (ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            return;
        }
        this.isHasMore = isHasMore;
        if (isHasMore) {
            if (result.size() > 0) {
                int oldStartPosition = this.mData.size();
                this.mData.addAll(result);
                int itemCount = this.mData.size();
                this.viewPageAdapter.notifyItemRangeChanged(oldStartPosition, itemCount);
            } else {
                this.loadMoreData();
            }
        }
    }

    private void initComplete() {
        final SelectMainStyle selectMainStyle = PictureSelectionConfig.selectorStyle.getSelectMainStyle();
        if (StyleUtils.checkStyleValidity(selectMainStyle.getPreviewSelectBackground())) {
            this.tvSelected.setBackgroundResource(selectMainStyle.getPreviewSelectBackground());
        } else if (StyleUtils.checkStyleValidity(selectMainStyle.getSelectBackground())) {
            this.tvSelected.setBackgroundResource(selectMainStyle.getSelectBackground());
        }
        if (StyleUtils.checkTextValidity(selectMainStyle.getPreviewSelectText())) {
            this.tvSelectedWord.setText((CharSequence)selectMainStyle.getPreviewSelectText());
        } else {
            this.tvSelectedWord.setText((CharSequence)"");
        }
        if (StyleUtils.checkSizeValidity(selectMainStyle.getPreviewSelectTextSize())) {
            this.tvSelectedWord.setTextSize((float)selectMainStyle.getPreviewSelectTextSize());
        }
        if (StyleUtils.checkStyleValidity(selectMainStyle.getPreviewSelectTextColor())) {
            this.tvSelectedWord.setTextColor(selectMainStyle.getPreviewSelectTextColor());
        }
        if (StyleUtils.checkSizeValidity(selectMainStyle.getPreviewSelectMarginRight()) && this.tvSelected.getLayoutParams() instanceof ConstraintLayout.LayoutParams) {
            if (this.tvSelected.getLayoutParams() instanceof ConstraintLayout.LayoutParams) {
                ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.tvSelected.getLayoutParams();
                layoutParams.rightMargin = selectMainStyle.getPreviewSelectMarginRight();
            } else if (this.tvSelected.getLayoutParams() instanceof RelativeLayout.LayoutParams) {
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.tvSelected.getLayoutParams();
                layoutParams.rightMargin = selectMainStyle.getPreviewSelectMarginRight();
            }
        }
        this.completeSelectView.setCompleteSelectViewStyle();
        if (selectMainStyle.isCompleteSelectRelativeTop()) {
            if (this.completeSelectView.getLayoutParams() instanceof ConstraintLayout.LayoutParams) {
                ((ConstraintLayout.LayoutParams)this.completeSelectView.getLayoutParams()).topToTop = R.id.title_bar;
                ((ConstraintLayout.LayoutParams)this.completeSelectView.getLayoutParams()).bottomToBottom = R.id.title_bar;
                if (this.config.isPreviewFullScreenMode) {
                    ((ConstraintLayout.LayoutParams)this.completeSelectView.getLayoutParams()).topMargin = DensityUtil.getStatusBarHeight(this.getContext());
                }
            } else if (this.completeSelectView.getLayoutParams() instanceof RelativeLayout.LayoutParams && this.config.isPreviewFullScreenMode) {
                ((RelativeLayout.LayoutParams)this.completeSelectView.getLayoutParams()).topMargin = DensityUtil.getStatusBarHeight(this.getContext());
            }
        }
        if (selectMainStyle.isPreviewSelectRelativeBottom()) {
            if (this.tvSelected.getLayoutParams() instanceof ConstraintLayout.LayoutParams) {
                ((ConstraintLayout.LayoutParams)this.tvSelected.getLayoutParams()).topToTop = R.id.bottom_nar_bar;
                ((ConstraintLayout.LayoutParams)this.tvSelected.getLayoutParams()).bottomToBottom = R.id.bottom_nar_bar;
                ((ConstraintLayout.LayoutParams)this.tvSelectedWord.getLayoutParams()).topToTop = R.id.bottom_nar_bar;
                ((ConstraintLayout.LayoutParams)this.tvSelectedWord.getLayoutParams()).bottomToBottom = R.id.bottom_nar_bar;
                ((ConstraintLayout.LayoutParams)this.selectClickArea.getLayoutParams()).topToTop = R.id.bottom_nar_bar;
                ((ConstraintLayout.LayoutParams)this.selectClickArea.getLayoutParams()).bottomToBottom = R.id.bottom_nar_bar;
            }
        } else if (this.config.isPreviewFullScreenMode) {
            if (this.tvSelectedWord.getLayoutParams() instanceof ConstraintLayout.LayoutParams) {
                ((ConstraintLayout.LayoutParams)this.tvSelectedWord.getLayoutParams()).topMargin = DensityUtil.getStatusBarHeight(this.getContext());
            } else if (this.tvSelectedWord.getLayoutParams() instanceof RelativeLayout.LayoutParams) {
                ((RelativeLayout.LayoutParams)this.tvSelectedWord.getLayoutParams()).topMargin = DensityUtil.getStatusBarHeight(this.getContext());
            }
        }
        this.completeSelectView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                boolean isComplete = true;
                if (selectMainStyle.isCompleteSelectRelativeTop() && SelectedManager.getCount() == 0) {
                    boolean bl = isComplete = PictureSelectorPreviewFragment.this.confirmSelect((LocalMedia)PictureSelectorPreviewFragment.this.mData.get(PictureSelectorPreviewFragment.this.viewPager.getCurrentItem()), false) == 0;
                }
                if (isComplete) {
                    PictureSelectorPreviewFragment.this.dispatchTransformResult();
                }
            }
        });
    }

    private void initTitleBar() {
        if (PictureSelectionConfig.selectorStyle.getTitleBarStyle().isHideTitleBar()) {
            this.titleBar.setVisibility(8);
        }
        this.titleBar.setTitleBarStyle();
        this.titleBar.setOnTitleBarListener(new TitleBar.OnTitleBarListener(){

            @Override
            public void onBackPressed() {
                if (PictureSelectorPreviewFragment.this.isExternalPreview) {
                    PictureSelectorPreviewFragment.this.handleExternalPreviewBack();
                } else if (!PictureSelectorPreviewFragment.this.isBottomPreview && ((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).config.isPreviewZoomEffect) {
                    PictureSelectorPreviewFragment.this.magicalView.backToMin();
                } else {
                    PictureSelectorPreviewFragment.this.iBridgePictureBehavior.onSelectFinish(false, null);
                }
            }
        });
        this.titleBar.setTitle(this.curPosition + 1 + "/" + this.totalNum);
        this.titleBar.getImageDelete().setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PictureSelectorPreviewFragment.this.deletePreview();
            }
        });
        this.selectClickArea.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PictureSelectorPreviewFragment.this.isExternalPreview) {
                    PictureSelectorPreviewFragment.this.deletePreview();
                } else {
                    LocalMedia currentMedia = (LocalMedia)PictureSelectorPreviewFragment.this.mData.get(PictureSelectorPreviewFragment.this.viewPager.getCurrentItem());
                    int selectResultCode = PictureSelectorPreviewFragment.this.confirmSelect(currentMedia, PictureSelectorPreviewFragment.this.tvSelected.isSelected());
                    if (selectResultCode == 0) {
                        PictureSelectorPreviewFragment.this.tvSelected.startAnimation(AnimationUtils.loadAnimation((Context)PictureSelectorPreviewFragment.this.getContext(), (int)R.anim.ps_anim_modal_in));
                    }
                }
            }
        });
        this.tvSelected.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PictureSelectorPreviewFragment.this.selectClickArea.performClick();
            }
        });
    }

    private void initPreviewSelectGallery(ViewGroup group) {
        SelectMainStyle selectMainStyle = PictureSelectionConfig.selectorStyle.getSelectMainStyle();
        if (selectMainStyle.isPreviewDisplaySelectGallery()) {
            this.mGalleryRecycle = new RecyclerView(this.getContext());
            if (StyleUtils.checkStyleValidity(selectMainStyle.getAdapterPreviewGalleryBackgroundResource())) {
                this.mGalleryRecycle.setBackgroundResource(selectMainStyle.getAdapterPreviewGalleryBackgroundResource());
            } else {
                this.mGalleryRecycle.setBackgroundResource(R.drawable.ps_preview_gallery_bg);
            }
            group.addView((View)this.mGalleryRecycle);
            ViewGroup.LayoutParams layoutParams = this.mGalleryRecycle.getLayoutParams();
            if (layoutParams instanceof ConstraintLayout.LayoutParams) {
                ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)layoutParams;
                params.width = -1;
                params.height = -2;
                params.bottomToTop = R.id.bottom_nar_bar;
                params.startToStart = 0;
                params.endToEnd = 0;
            }
            WrapContentLinearLayoutManager layoutManager = new WrapContentLinearLayoutManager(this.getContext());
            layoutManager.setOrientation(0);
            this.mGalleryRecycle.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
            this.mGalleryRecycle.addItemDecoration((RecyclerView.ItemDecoration)new GridSpacingItemDecoration(Integer.MAX_VALUE, DensityUtil.dip2px(this.getContext(), 6.0f), true));
            this.mGalleryAdapter = new PreviewGalleryAdapter(this.isBottomPreview, SelectedManager.getSelectedResult());
            this.notifyGallerySelectMedia(this.mData.get(this.curPosition));
            this.mGalleryRecycle.setAdapter((RecyclerView.Adapter)this.mGalleryAdapter);
            this.mGalleryAdapter.setItemClickListener(new PreviewGalleryAdapter.OnItemClickListener(){

                @Override
                public void onItemClick(int position, LocalMedia media, View v) {
                    if (PictureSelectorPreviewFragment.this.isBottomPreview || TextUtils.equals((CharSequence)PictureSelectorPreviewFragment.this.currentAlbum, (CharSequence)PictureSelectorPreviewFragment.this.getString(R.string.ps_camera_roll)) || TextUtils.equals((CharSequence)media.getParentFolderName(), (CharSequence)PictureSelectorPreviewFragment.this.currentAlbum)) {
                        int newPosition;
                        int n = PictureSelectorPreviewFragment.this.isBottomPreview ? position : (newPosition = PictureSelectorPreviewFragment.this.isShowCamera ? media.position - 1 : media.position);
                        if (newPosition == PictureSelectorPreviewFragment.this.viewPager.getCurrentItem() && media.isChecked()) {
                            return;
                        }
                        if (PictureSelectorPreviewFragment.this.viewPager.getAdapter() != null) {
                            PictureSelectorPreviewFragment.this.viewPager.setAdapter(null);
                            PictureSelectorPreviewFragment.this.viewPager.setAdapter((RecyclerView.Adapter)PictureSelectorPreviewFragment.this.viewPageAdapter);
                        }
                        PictureSelectorPreviewFragment.this.viewPager.setCurrentItem(newPosition, false);
                        PictureSelectorPreviewFragment.this.notifyGallerySelectMedia(media);
                    }
                }
            });
            if (SelectedManager.getCount() > 0) {
                this.mGalleryRecycle.setVisibility(0);
            } else {
                this.mGalleryRecycle.setVisibility(4);
            }
            this.mAnimViews.add((View)this.mGalleryRecycle);
            final ItemTouchHelper mItemTouchHelper = new ItemTouchHelper(new ItemTouchHelper.Callback(){

                public boolean isLongPressDragEnabled() {
                    return true;
                }

                public void onSwiped(@NonNull RecyclerView.ViewHolder viewHolder, int direction) {
                }

                public int getMovementFlags(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder) {
                    viewHolder.itemView.setAlpha(0.7f);
                    return 14.makeMovementFlags((int)12, (int)0);
                }

                public boolean onMove(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, @NonNull RecyclerView.ViewHolder target) {
                    try {
                        int fromPosition = viewHolder.getAbsoluteAdapterPosition();
                        int toPosition = target.getAbsoluteAdapterPosition();
                        if (fromPosition < toPosition) {
                            for (int i = fromPosition; i < toPosition; ++i) {
                                Collections.swap(PictureSelectorPreviewFragment.this.mGalleryAdapter.getData(), i, i + 1);
                                Collections.swap(SelectedManager.getSelectedResult(), i, i + 1);
                                if (!PictureSelectorPreviewFragment.this.isBottomPreview) continue;
                                Collections.swap(PictureSelectorPreviewFragment.this.mData, i, i + 1);
                            }
                        } else {
                            for (int i = fromPosition; i > toPosition; --i) {
                                Collections.swap(PictureSelectorPreviewFragment.this.mGalleryAdapter.getData(), i, i - 1);
                                Collections.swap(SelectedManager.getSelectedResult(), i, i - 1);
                                if (!PictureSelectorPreviewFragment.this.isBottomPreview) continue;
                                Collections.swap(PictureSelectorPreviewFragment.this.mData, i, i - 1);
                            }
                        }
                        PictureSelectorPreviewFragment.this.mGalleryAdapter.notifyItemMoved(fromPosition, toPosition);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return true;
                }

                public void onChildDraw(@NonNull Canvas c, @NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
                    if (PictureSelectorPreviewFragment.this.needScaleBig) {
                        PictureSelectorPreviewFragment.this.needScaleBig = false;
                        AnimatorSet animatorSet = new AnimatorSet();
                        animatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)viewHolder.itemView, (String)"scaleX", (float[])new float[]{1.0f, 1.1f}), ObjectAnimator.ofFloat((Object)viewHolder.itemView, (String)"scaleY", (float[])new float[]{1.0f, 1.1f})});
                        animatorSet.setDuration(50L);
                        animatorSet.setInterpolator((TimeInterpolator)new LinearInterpolator());
                        animatorSet.start();
                        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                            public void onAnimationEnd(Animator animation) {
                                PictureSelectorPreviewFragment.this.needScaleSmall = true;
                            }
                        });
                    }
                    super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
                }

                public void onSelectedChanged(@Nullable RecyclerView.ViewHolder viewHolder, int actionState) {
                    super.onSelectedChanged(viewHolder, actionState);
                }

                public long getAnimationDuration(@NonNull RecyclerView recyclerView, int animationType, float animateDx, float animateDy) {
                    return super.getAnimationDuration(recyclerView, animationType, animateDx, animateDy);
                }

                public void clearView(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder) {
                    viewHolder.itemView.setAlpha(1.0f);
                    if (PictureSelectorPreviewFragment.this.needScaleSmall) {
                        PictureSelectorPreviewFragment.this.needScaleSmall = false;
                        AnimatorSet animatorSet = new AnimatorSet();
                        animatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)viewHolder.itemView, (String)"scaleX", (float[])new float[]{1.1f, 1.0f}), ObjectAnimator.ofFloat((Object)viewHolder.itemView, (String)"scaleY", (float[])new float[]{1.1f, 1.0f})});
                        animatorSet.setInterpolator((TimeInterpolator)new LinearInterpolator());
                        animatorSet.setDuration(50L);
                        animatorSet.start();
                        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                            public void onAnimationEnd(Animator animation) {
                                PictureSelectorPreviewFragment.this.needScaleBig = true;
                            }
                        });
                    }
                    super.clearView(recyclerView, viewHolder);
                    PictureSelectorPreviewFragment.this.mGalleryAdapter.notifyItemChanged(viewHolder.getAbsoluteAdapterPosition());
                    if (PictureSelectorPreviewFragment.this.isBottomPreview) {
                        int position = PictureSelectorPreviewFragment.this.mGalleryAdapter.getLastCheckPosition();
                        if (PictureSelectorPreviewFragment.this.viewPager.getCurrentItem() != position && position != -1) {
                            PictureSelectorPreviewFragment.this.viewPager.setCurrentItem(position, false);
                        }
                    }
                    if (PictureSelectionConfig.selectorStyle.getSelectMainStyle().isSelectNumberStyle() && !ActivityCompatHelper.isDestroy((Activity)PictureSelectorPreviewFragment.this.getActivity())) {
                        List fragments = PictureSelectorPreviewFragment.this.getActivity().getSupportFragmentManager().getFragments();
                        for (int i = 0; i < fragments.size(); ++i) {
                            Fragment fragment = (Fragment)fragments.get(i);
                            if (!(fragment instanceof PictureCommonFragment)) continue;
                            ((PictureCommonFragment)fragment).sendChangeSubSelectPositionEvent(true);
                        }
                    }
                }
            });
            mItemTouchHelper.attachToRecyclerView(this.mGalleryRecycle);
            this.mGalleryAdapter.setItemLongClickListener(new PreviewGalleryAdapter.OnItemLongClickListener(){

                @Override
                public void onItemLongClick(RecyclerView.ViewHolder holder, int position, View v) {
                    Vibrator vibrator = (Vibrator)PictureSelectorPreviewFragment.this.getActivity().getSystemService("vibrator");
                    vibrator.vibrate(50L);
                    if (PictureSelectorPreviewFragment.this.mGalleryAdapter.getItemCount() != ((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).config.maxSelectNum) {
                        mItemTouchHelper.startDrag(holder);
                        return;
                    }
                    if (holder.getLayoutPosition() != PictureSelectorPreviewFragment.this.mGalleryAdapter.getItemCount() - 1) {
                        mItemTouchHelper.startDrag(holder);
                    }
                }
            });
        }
    }

    private void notifyGallerySelectMedia(LocalMedia currentMedia) {
        if (this.mGalleryAdapter != null && PictureSelectionConfig.selectorStyle.getSelectMainStyle().isPreviewDisplaySelectGallery()) {
            this.mGalleryAdapter.isSelectMedia(currentMedia);
        }
    }

    private void notifyPreviewGalleryData(boolean isAddRemove, LocalMedia currentMedia) {
        if (this.mGalleryAdapter != null && PictureSelectionConfig.selectorStyle.getSelectMainStyle().isPreviewDisplaySelectGallery()) {
            if (this.mGalleryRecycle.getVisibility() == 4) {
                this.mGalleryRecycle.setVisibility(0);
            }
            if (isAddRemove) {
                if (this.config.selectionMode == 1) {
                    this.mGalleryAdapter.clear();
                }
                this.mGalleryAdapter.addGalleryData(currentMedia);
            } else {
                this.mGalleryAdapter.removeGalleryData(currentMedia);
                if (SelectedManager.getCount() == 0) {
                    this.mGalleryRecycle.setVisibility(4);
                }
            }
        }
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    private void deletePreview() {
        if (PictureSelectionConfig.externalPreviewEventListener != null) {
            PictureSelectionConfig.externalPreviewEventListener.onPreviewDelete(this.viewPager.getCurrentItem());
            int currentItem = this.viewPager.getCurrentItem();
            this.mData.remove(currentItem);
            if (this.mData.size() == 0) {
                this.handleExternalPreviewBack();
                return;
            }
            this.titleBar.setTitle(this.getString(R.string.ps_preview_image_num, new Object[]{this.curPosition + 1, this.mData.size()}));
            this.totalNum = this.mData.size();
            this.curPosition = currentItem;
            if (this.viewPager.getAdapter() != null) {
                this.viewPager.setAdapter(null);
                this.viewPager.setAdapter((RecyclerView.Adapter)this.viewPageAdapter);
            }
            this.viewPager.setCurrentItem(this.curPosition, false);
        }
    }

    private void handleExternalPreviewBack() {
        if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            if (this.config.isPreviewFullScreenMode) {
                this.hideFullScreenStatusBar();
            }
            if (this.getActivity() instanceof PictureSelectorSupporterActivity) {
                this.iBridgePictureBehavior.onSelectFinish(false, null);
            } else {
                this.getActivity().getSupportFragmentManager().popBackStack();
            }
        }
    }

    @Override
    public void onExitFragment() {
        if (this.config.isPreviewFullScreenMode) {
            this.hideFullScreenStatusBar();
        }
    }

    private void initBottomNavBar() {
        this.bottomNarBar.setBottomNavBarStyle();
        this.bottomNarBar.setSelectedChange();
        this.bottomNarBar.setOnBottomNavBarListener(new BottomNavBar.OnBottomNavBarListener(){

            @Override
            public void onEditImage() {
                if (PictureSelectionConfig.editMediaEventListener != null) {
                    LocalMedia media = (LocalMedia)PictureSelectorPreviewFragment.this.mData.get(PictureSelectorPreviewFragment.this.viewPager.getCurrentItem());
                    PictureSelectionConfig.editMediaEventListener.onStartMediaEdit(PictureSelectorPreviewFragment.this, media, 696);
                }
            }

            @Override
            public void onCheckOriginalChange() {
                PictureSelectorPreviewFragment.this.sendSelectedOriginalChangeEvent();
            }

            @Override
            public void onFirstCheckOriginalSelectedChange() {
                int currentItem = PictureSelectorPreviewFragment.this.viewPager.getCurrentItem();
                if (PictureSelectorPreviewFragment.this.mData.size() > currentItem) {
                    LocalMedia media = (LocalMedia)PictureSelectorPreviewFragment.this.mData.get(currentItem);
                    PictureSelectorPreviewFragment.this.confirmSelect(media, false);
                }
            }
        });
    }

    private void externalPreviewStyle() {
        this.titleBar.getImageDelete().setVisibility(this.isDisplayDelete ? 0 : 8);
        this.tvSelected.setVisibility(8);
        this.bottomNarBar.setVisibility(8);
        this.completeSelectView.setVisibility(8);
    }

    private void initViewPagerData() {
        this.viewPageAdapter = new PicturePreviewAdapter(this.mData, new MyOnPreviewEventListener());
        this.viewPager.setOrientation(0);
        this.viewPager.setAdapter((RecyclerView.Adapter)this.viewPageAdapter);
        this.viewPager.setCurrentItem(this.curPosition, false);
        if (this.mData.size() > 0) {
            this.bottomNarBar.isDisplayEditor(PictureMimeType.isHasVideo(this.mData.get(this.curPosition).getMimeType()));
        }
        this.tvSelected.setSelected(SelectedManager.getSelectedResult().contains(this.mData.get(this.viewPager.getCurrentItem())));
        this.completeSelectView.setSelectedChange(true);
        this.viewPager.registerOnPageChangeCallback(this.pageChangeCallback);
        this.viewPager.setPageTransformer((ViewPager2.PageTransformer)new MarginPageTransformer(DensityUtil.dip2px(this.getContext(), 3.0f)));
        this.sendChangeSubSelectPositionEvent(false);
        this.notifySelectNumberStyle(this.mData.get(this.curPosition));
    }

    public void onKeyDownBackToMin() {
        if (this.config.isPreviewZoomEffect) {
            if (this.isBottomPreview) {
                this.iBridgePictureBehavior.onSelectFinish(false, null);
            } else {
                this.magicalView.backToMin();
            }
        }
    }

    private void previewFullScreenMode() {
        if (this.isAnimationStart) {
            return;
        }
        boolean isAnimInit = this.titleBar.getTranslationY() == 0.0f;
        AnimatorSet set = new AnimatorSet();
        float titleBarForm = isAnimInit ? 0.0f : (float)(-this.titleBar.getHeight());
        float titleBarTo = isAnimInit ? (float)(-this.titleBar.getHeight()) : 0.0f;
        float alphaForm = isAnimInit ? 1.0f : 0.0f;
        float alphaTo = isAnimInit ? 0.0f : 1.0f;
        for (int i = 0; i < this.mAnimViews.size(); ++i) {
            View view = this.mAnimViews.get(i);
            set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{alphaForm, alphaTo})});
            if (!(view instanceof TitleBar)) continue;
            set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{titleBarForm, titleBarTo})});
        }
        set.setDuration(350L);
        set.start();
        this.isAnimationStart = true;
        set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                PictureSelectorPreviewFragment.this.isAnimationStart = false;
            }
        });
        if (isAnimInit) {
            this.showFullScreenStatusBar();
        } else {
            this.hideFullScreenStatusBar();
        }
    }

    private void showFullScreenStatusBar() {
        for (int i = 0; i < this.mAnimViews.size(); ++i) {
            this.mAnimViews.get(i).setEnabled(false);
        }
        this.bottomNarBar.getEditor().setEnabled(false);
    }

    private void hideFullScreenStatusBar() {
        for (int i = 0; i < this.mAnimViews.size(); ++i) {
            this.mAnimViews.get(i).setEnabled(true);
        }
        this.bottomNarBar.getEditor().setEnabled(true);
    }

    private void onExternalLongPressDownload(final LocalMedia media) {
        if (PictureSelectionConfig.externalPreviewEventListener != null && !PictureSelectionConfig.externalPreviewEventListener.onLongPressDownload(media)) {
            PictureCommonDialog dialog = PictureCommonDialog.showDialog(this.getContext(), this.getContext().getString(R.string.ps_prompt), PictureMimeType.isHasVideo(media.getMimeType()) || PictureMimeType.isUrlHasVideo(media.getAvailablePath()) ? this.getContext().getString(R.string.ps_prompt_video_content) : this.getContext().getString(R.string.ps_prompt_content));
            dialog.setOnDialogEventListener(new PictureCommonDialog.OnDialogEventListener(){

                @Override
                public void onConfirm() {
                    String path = TextUtils.isEmpty((CharSequence)media.getSandboxPath()) ? media.getPath() : media.getSandboxPath();
                    if (PictureMimeType.isHasHttp(path)) {
                        PictureSelectorPreviewFragment.this.showLoading();
                    }
                    DownloadFileUtils.saveLocalFile(PictureSelectorPreviewFragment.this.getContext(), path, media.getMimeType(), new OnCallbackListener<String>(){

                        @Override
                        public void onCall(String realPath) {
                            PictureSelectorPreviewFragment.this.dismissLoading();
                            if (TextUtils.isEmpty((CharSequence)realPath)) {
                                String errorMsg = PictureMimeType.isHasVideo(media.getMimeType()) ? PictureSelectorPreviewFragment.this.getString(R.string.ps_save_video_error) : PictureSelectorPreviewFragment.this.getString(R.string.ps_save_image_error);
                                Toast.makeText((Context)PictureSelectorPreviewFragment.this.getContext(), (CharSequence)errorMsg, (int)1).show();
                            } else {
                                new PictureMediaScannerConnection((Context)PictureSelectorPreviewFragment.this.getActivity(), realPath);
                                Toast.makeText((Context)PictureSelectorPreviewFragment.this.getContext(), (CharSequence)(PictureSelectorPreviewFragment.this.getString(R.string.ps_save_success) + "\n" + realPath), (int)1).show();
                            }
                        }
                    });
                }
            });
        }
    }

    private void changeMagicalViewParams(final int position) {
        final LocalMedia media = this.mData.get(position);
        final int[] size = this.getRealSizeFromMedia(media);
        if (size[0] == 0 && size[1] == 0) {
            PictureSelectionConfig.imageEngine.loadImageBitmap((Context)this.getActivity(), media.getPath(), new OnCallbackListener<Bitmap>(){

                @Override
                public void onCall(Bitmap bitmap) {
                    if (ActivityCompatHelper.isDestroy((Activity)PictureSelectorPreviewFragment.this.getActivity())) {
                        return;
                    }
                    if (MediaUtils.isLongImage(bitmap.getWidth(), bitmap.getHeight())) {
                        size[0] = PictureSelectorPreviewFragment.this.screenWidth;
                        size[1] = PictureSelectorPreviewFragment.this.screenHeight;
                    } else {
                        size[0] = bitmap.getWidth();
                        size[1] = bitmap.getHeight();
                    }
                    media.setWidth(size[0]);
                    media.setHeight(size[1]);
                    ViewParams viewParams = BuildRecycleItemViewParams.getItemViewParams(PictureSelectorPreviewFragment.this.isShowCamera ? position + 1 : position);
                    if (viewParams == null || size[0] == 0 || size[1] == 0) {
                        PictureSelectorPreviewFragment.this.magicalView.setViewParams(0, 0, 0, 0, size[0], size[1]);
                    } else {
                        PictureSelectorPreviewFragment.this.magicalView.setViewParams(viewParams.left, viewParams.top, viewParams.width, viewParams.height, size[0], size[1]);
                    }
                }
            });
        } else {
            ViewParams viewParams = BuildRecycleItemViewParams.getItemViewParams(this.isShowCamera ? position + 1 : position);
            if (viewParams == null || size[0] == 0 || size[1] == 0) {
                this.magicalView.setViewParams(0, 0, 0, 0, size[0], size[1]);
            } else {
                this.magicalView.setViewParams(viewParams.left, viewParams.top, viewParams.width, viewParams.height, size[0], size[1]);
            }
        }
    }

    private int[] getRealSizeFromMedia(LocalMedia currentLocalMedia) {
        int realHeight;
        int realWidth;
        if (MediaUtils.isLongImage(currentLocalMedia.getWidth(), currentLocalMedia.getHeight())) {
            realWidth = this.screenWidth;
            realHeight = this.screenHeight;
        } else {
            realWidth = currentLocalMedia.getWidth();
            realHeight = currentLocalMedia.getHeight();
        }
        return new int[]{realWidth, realHeight};
    }

    public void notifySelectNumberStyle(LocalMedia currentMedia) {
        if (PictureSelectionConfig.selectorStyle.getSelectMainStyle().isPreviewSelectNumberStyle() && PictureSelectionConfig.selectorStyle.getSelectMainStyle().isSelectNumberStyle()) {
            this.tvSelected.setText((CharSequence)"");
            for (int i = 0; i < SelectedManager.getCount(); ++i) {
                LocalMedia media = SelectedManager.getSelectedResult().get(i);
                if (!TextUtils.equals((CharSequence)media.getPath(), (CharSequence)currentMedia.getPath()) && media.getId() != currentMedia.getId()) continue;
                currentMedia.setNum(media.getNum());
                media.setPosition(currentMedia.getPosition());
                this.tvSelected.setText((CharSequence)ValueOf.toString(currentMedia.getNum()));
            }
        }
    }

    protected boolean isSelected(LocalMedia media) {
        return SelectedManager.getSelectedResult().contains(media);
    }

    @Override
    public void onEditMedia(Intent data) {
        if (this.mData.size() > this.viewPager.getCurrentItem()) {
            LocalMedia media = this.mData.get(this.viewPager.getCurrentItem());
            Uri output = Crop.getOutput(data);
            media.setCutPath(output != null ? output.getPath() : "");
            media.setCropImageWidth(Crop.getOutputImageWidth(data));
            media.setCropImageHeight(Crop.getOutputImageHeight(data));
            media.setCropOffsetX(Crop.getOutputImageOffsetX(data));
            media.setCropOffsetY(Crop.getOutputImageOffsetY(data));
            media.setCropResultAspectRatio(Crop.getOutputCropAspectRatio(data));
            media.setCut(!TextUtils.isEmpty((CharSequence)media.getCutPath()));
            media.setCustomData(Crop.getOutputCustomExtraData(data));
            media.setEditorImage(media.isCut());
            media.setSandboxPath(media.getCutPath());
            if (SelectedManager.getSelectedResult().contains(media)) {
                this.sendFixedSelectedChangeEvent(media);
            } else {
                this.confirmSelect(media, false);
            }
            this.viewPageAdapter.notifyItemChanged(this.viewPager.getCurrentItem());
            this.notifyGallerySelectMedia(media);
        }
    }

    @Override
    public void onDestroy() {
        this.viewPageAdapter.destroyVideo(this.viewPager.getCurrentItem());
        this.viewPager.unregisterOnPageChangeCallback(this.pageChangeCallback);
        if (this.isExternalPreview) {
            PictureSelectionConfig.destroy();
        }
        super.onDestroy();
    }

    private class MyOnPreviewEventListener
    implements BasePreviewHolder.OnPreviewEventListener {
        private MyOnPreviewEventListener() {
        }

        @Override
        public void onLoadCompleteBeginScale(BasePreviewHolder holder, int width, int height) {
            if (PictureSelectorPreviewFragment.this.isSaveInstanceState) {
                return;
            }
            if (PictureSelectorPreviewFragment.this.isFirstLoaded || PictureSelectorPreviewFragment.this.isBottomPreview) {
                return;
            }
            if (((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).config.isPreviewZoomEffect) {
                int[] size;
                PictureSelectorPreviewFragment.this.isFirstLoaded = true;
                holder.coverImageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
                if (MediaUtils.isLongImage(width, height)) {
                    size = new int[]{PictureSelectorPreviewFragment.this.screenWidth, PictureSelectorPreviewFragment.this.screenHeight};
                } else {
                    int[] nArray;
                    LocalMedia media = (LocalMedia)PictureSelectorPreviewFragment.this.mData.get(PictureSelectorPreviewFragment.this.curPosition);
                    if (width > 0 && height > 0) {
                        int[] nArray2 = new int[2];
                        nArray2[0] = width;
                        nArray = nArray2;
                        nArray2[1] = height;
                    } else {
                        nArray = PictureSelectorPreviewFragment.this.getRealSizeFromMedia(media);
                    }
                    size = nArray;
                }
                ViewParams viewParams = BuildRecycleItemViewParams.getItemViewParams(PictureSelectorPreviewFragment.this.isShowCamera ? PictureSelectorPreviewFragment.this.curPosition + 1 : PictureSelectorPreviewFragment.this.curPosition);
                if (viewParams == null || size[0] == 0 || size[1] == 0) {
                    PictureSelectorPreviewFragment.this.magicalView.startNormal(size[0], size[1], false);
                    PictureSelectorPreviewFragment.this.magicalView.setBackgroundAlpha(1.0f);
                    for (int i = 0; i < PictureSelectorPreviewFragment.this.mAnimViews.size(); ++i) {
                        ((View)PictureSelectorPreviewFragment.this.mAnimViews.get(i)).setAlpha(1.0f);
                    }
                } else {
                    PictureSelectorPreviewFragment.this.magicalView.setViewParams(viewParams.left, viewParams.top, viewParams.width, viewParams.height, size[0], size[1]);
                    PictureSelectorPreviewFragment.this.magicalView.start(false);
                }
                ObjectAnimator animator = ObjectAnimator.ofFloat((Object)PictureSelectorPreviewFragment.this.viewPager, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
                animator.setDuration(50L);
                animator.start();
            }
        }

        @Override
        public void onLoadCompleteError(BasePreviewHolder holder) {
            if (PictureSelectorPreviewFragment.this.isFirstLoaded || PictureSelectorPreviewFragment.this.isBottomPreview) {
                return;
            }
            if (((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).config.isPreviewZoomEffect) {
                PictureSelectorPreviewFragment.this.isFirstLoaded = true;
                PictureSelectorPreviewFragment.this.viewPager.setAlpha(1.0f);
                PictureSelectorPreviewFragment.this.magicalView.startNormal(0, 0, false);
                PictureSelectorPreviewFragment.this.magicalView.setBackgroundAlpha(1.0f);
                for (int i = 0; i < PictureSelectorPreviewFragment.this.mAnimViews.size(); ++i) {
                    ((View)PictureSelectorPreviewFragment.this.mAnimViews.get(i)).setAlpha(1.0f);
                }
            }
        }

        @Override
        public void onBackPressed() {
            if (((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).config.isPreviewFullScreenMode) {
                PictureSelectorPreviewFragment.this.previewFullScreenMode();
            } else if (PictureSelectorPreviewFragment.this.isExternalPreview) {
                PictureSelectorPreviewFragment.this.handleExternalPreviewBack();
            } else if (!PictureSelectorPreviewFragment.this.isBottomPreview && ((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).config.isPreviewZoomEffect) {
                PictureSelectorPreviewFragment.this.magicalView.backToMin();
            } else {
                PictureSelectorPreviewFragment.this.iBridgePictureBehavior.onSelectFinish(false, null);
            }
        }

        @Override
        public void onPreviewVideoTitle(String videoName) {
            if (TextUtils.isEmpty((CharSequence)videoName)) {
                PictureSelectorPreviewFragment.this.titleBar.setTitle(PictureSelectorPreviewFragment.this.curPosition + 1 + "/" + PictureSelectorPreviewFragment.this.totalNum);
            } else {
                PictureSelectorPreviewFragment.this.titleBar.setTitle(videoName);
            }
        }

        @Override
        public void onLongPressDownload(LocalMedia media) {
            if (PictureSelectorPreviewFragment.this.isExternalPreview) {
                PictureSelectorPreviewFragment.this.onExternalLongPressDownload(media);
            }
        }
    }
}

