/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.luck.picture.lib.R;
import com.luck.picture.lib.basic.PictureCommonFragment;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.manager.SelectedManager;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.permissions.PermissionConfig;
import com.luck.picture.lib.permissions.PermissionResultCallback;
import com.luck.picture.lib.utils.ActivityCompatHelper;
import com.luck.picture.lib.utils.SdkVersionUtils;

public class PictureOnlyCameraFragment
extends PictureCommonFragment {
    public static final String TAG = PictureOnlyCameraFragment.class.getSimpleName();

    public static PictureOnlyCameraFragment newInstance() {
        return new PictureOnlyCameraFragment();
    }

    @Override
    public int getResourceId() {
        return R.layout.ps_empty;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (SdkVersionUtils.isQ()) {
            this.openSelectedCamera();
        } else {
            PermissionChecker.getInstance().requestPermissions((Fragment)this, PermissionConfig.WRITE_EXTERNAL_STORAGE, new PermissionResultCallback(){

                @Override
                public void onGranted() {
                    PictureOnlyCameraFragment.this.openSelectedCamera();
                }

                @Override
                public void onDenied() {
                    PictureOnlyCameraFragment.this.handlePermissionDenied(PermissionConfig.WRITE_EXTERNAL_STORAGE);
                }
            });
        }
    }

    @Override
    public void dispatchCameraMediaResult(LocalMedia media) {
        SelectedManager.getSelectedResult().add(media);
        this.dispatchTransformResult();
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == 0 && requestCode == 909 && !ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            this.getActivity().getSupportFragmentManager().popBackStack();
        }
    }

    @Override
    public void handlePermissionSettingResult() {
        boolean isHasPermissions;
        if (PictureSelectionConfig.permissionsEventListener != null) {
            isHasPermissions = PictureSelectionConfig.permissionsEventListener.hasPermissions(this);
        } else {
            isHasPermissions = PermissionChecker.isCheckCamera(this.getContext());
            if (!SdkVersionUtils.isQ()) {
                isHasPermissions = PermissionChecker.isCheckWriteStorage(this.getContext());
            }
        }
        if (isHasPermissions) {
            this.openSelectedCamera();
        } else {
            if (!PermissionChecker.isCheckCamera(this.getContext())) {
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getString(R.string.ps_camera), (int)1).show();
            } else if (!PermissionChecker.isCheckWriteStorage(this.getContext())) {
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getString(R.string.ps_jurisdiction), (int)1).show();
            }
            if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
                this.getActivity().getSupportFragmentManager().popBackStack();
            }
        }
    }
}

