/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.style.PictureSelectorStyle;
import com.luck.picture.lib.style.TitleBarStyle;
import com.luck.picture.lib.utils.DensityUtil;
import com.luck.picture.lib.utils.StyleUtils;
import com.luck.picture.lib.widget.MarqueeTextView;

public class TitleBar
extends RelativeLayout
implements View.OnClickListener {
    protected RelativeLayout rlAlbumBg;
    protected ImageView ivLeftBack;
    protected ImageView ivArrow;
    protected MarqueeTextView tvTitle;
    protected TextView tvCancel;
    protected View viewAlbumClickArea;
    protected PictureSelectionConfig config;
    protected OnTitleBarListener titleBarListener;

    public TextView getTitleCancelView() {
        return this.tvCancel;
    }

    public TitleBar(Context context) {
        super(context);
        this.init();
    }

    public TitleBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public TitleBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    protected void init() {
        TitleBar.inflate((Context)this.getContext(), (int)R.layout.ps_title_bar, (ViewGroup)this);
        this.setClickable(true);
        this.setFocusable(true);
        this.ivLeftBack = (ImageView)this.findViewById(R.id.ps_iv_left_back);
        this.rlAlbumBg = (RelativeLayout)this.findViewById(R.id.ps_rl_album_bg);
        this.viewAlbumClickArea = this.findViewById(R.id.ps_rl_album_click);
        this.tvTitle = (MarqueeTextView)this.findViewById(R.id.ps_tv_title);
        this.ivArrow = (ImageView)this.findViewById(R.id.ps_iv_arrow);
        this.tvCancel = (TextView)this.findViewById(R.id.ps_tv_cancel);
        this.ivLeftBack.setOnClickListener((View.OnClickListener)this);
        this.tvCancel.setOnClickListener((View.OnClickListener)this);
        this.rlAlbumBg.setOnClickListener((View.OnClickListener)this);
        this.viewAlbumClickArea.setOnClickListener((View.OnClickListener)this);
        this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.ps_color_grey));
        this.config = PictureSelectionConfig.getInstance();
    }

    public ImageView getImageArrow() {
        return this.ivArrow;
    }

    public void setTitle(String title) {
        this.tvTitle.setText(title);
    }

    public String getTitleText() {
        return this.tvTitle.getText().toString();
    }

    public void setTitleBarStyle() {
        int albumBackgroundRes;
        int arrowResId;
        int titleTextColor;
        int titleTextSize;
        String titleDefaultText;
        int backResId;
        PictureSelectorStyle selectorStyle = PictureSelectionConfig.selectorStyle;
        TitleBarStyle titleBarStyle = selectorStyle.getTitleBarStyle();
        int titleBarHeight = titleBarStyle.getTitleBarHeight();
        this.getLayoutParams().height = StyleUtils.checkSizeValidity(titleBarHeight) ? titleBarHeight : DensityUtil.dip2px(this.getContext(), 48.0f);
        int backgroundColor = titleBarStyle.getTitleBackgroundColor();
        if (StyleUtils.checkStyleValidity(backgroundColor)) {
            this.setBackgroundColor(backgroundColor);
        }
        if (StyleUtils.checkStyleValidity(backResId = titleBarStyle.getTitleLeftBackResource())) {
            this.ivLeftBack.setImageResource(backResId);
        }
        if (StyleUtils.checkTextValidity(titleDefaultText = titleBarStyle.getTitleDefaultText())) {
            this.tvTitle.setText(titleDefaultText);
        }
        if (StyleUtils.checkSizeValidity(titleTextSize = titleBarStyle.getTitleTextSize())) {
            this.tvTitle.setTextSize(titleTextSize);
        }
        if (StyleUtils.checkStyleValidity(titleTextColor = titleBarStyle.getTitleTextColor())) {
            this.tvTitle.setTextColor(titleTextColor);
        }
        if (StyleUtils.checkStyleValidity(arrowResId = titleBarStyle.getTitleDrawableRightResource())) {
            this.ivArrow.setImageResource(arrowResId);
        }
        if (StyleUtils.checkStyleValidity(albumBackgroundRes = titleBarStyle.getTitleAlbumBackgroundResource())) {
            this.rlAlbumBg.setBackgroundResource(albumBackgroundRes);
        }
        if (titleBarStyle.isHideCancelButton()) {
            this.tvCancel.setVisibility(8);
        } else {
            int titleCancelTextSize;
            int titleCancelTextColor;
            String titleCancelText;
            this.tvCancel.setVisibility(0);
            int titleCancelBackgroundResource = titleBarStyle.getTitleCancelBackgroundResource();
            if (StyleUtils.checkStyleValidity(titleCancelBackgroundResource)) {
                this.tvCancel.setBackgroundResource(titleCancelBackgroundResource);
            }
            if (StyleUtils.checkTextValidity(titleCancelText = titleBarStyle.getTitleCancelText())) {
                this.tvCancel.setText((CharSequence)titleCancelText);
            }
            if (StyleUtils.checkStyleValidity(titleCancelTextColor = titleBarStyle.getTitleCancelTextColor())) {
                this.tvCancel.setTextColor(titleCancelTextColor);
            }
            if (StyleUtils.checkSizeValidity(titleCancelTextSize = titleBarStyle.getTitleCancelTextSize())) {
                this.tvCancel.setTextSize((float)titleCancelTextSize);
            }
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.ps_iv_left_back || id2 == R.id.ps_tv_cancel) {
            if (this.titleBarListener != null) {
                this.titleBarListener.onBackPressed();
            }
        } else if ((id2 == R.id.ps_rl_album_bg || id2 == R.id.ps_rl_album_click) && this.titleBarListener != null) {
            this.titleBarListener.onShowAlbumPopWindow((View)this);
        }
    }

    public void setOnTitleBarListener(OnTitleBarListener listener) {
        this.titleBarListener = listener;
    }

    public static class OnTitleBarListener {
        public void onBackPressed() {
        }

        public void onShowAlbumPopWindow(View anchor) {
        }
    }
}

