/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.utils;

import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.TextUtils;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.utils.DateUtils;
import com.luck.picture.lib.utils.PictureFileUtils;
import com.luck.picture.lib.utils.SdkVersionUtils;
import com.luck.picture.lib.utils.ValueOf;
import java.io.File;

public class MediaStoreUtils {
    public static Uri createCameraOutImageUri(Context context, PictureSelectionConfig config) {
        Uri imageUri;
        String cameraFileName;
        if (TextUtils.isEmpty((CharSequence)config.outPutCameraImageFileName)) {
            cameraFileName = "";
        } else {
            String string2 = cameraFileName = config.isOnlyCamera ? config.outPutCameraImageFileName : System.currentTimeMillis() + "_" + config.outPutCameraImageFileName;
        }
        if (SdkVersionUtils.isQ() && TextUtils.isEmpty((CharSequence)config.outPutCameraDir)) {
            imageUri = MediaStoreUtils.createImageUri(context, cameraFileName, config.cameraImageFormatForQ);
            config.cameraPath = imageUri != null ? imageUri.toString() : null;
        } else {
            File cameraFile = PictureFileUtils.createCameraFile(context, 1, cameraFileName, config.cameraImageFormat, config.outPutCameraDir);
            config.cameraPath = cameraFile.getAbsolutePath();
            imageUri = PictureFileUtils.parUri(context, cameraFile);
        }
        return imageUri;
    }

    public static Uri createCameraOutVideoUri(Context context, PictureSelectionConfig config) {
        Uri videoUri;
        String cameraFileName;
        if (TextUtils.isEmpty((CharSequence)config.outPutCameraVideoFileName)) {
            cameraFileName = "";
        } else {
            String string2 = cameraFileName = config.isOnlyCamera ? config.outPutCameraVideoFileName : System.currentTimeMillis() + "_" + config.outPutCameraVideoFileName;
        }
        if (SdkVersionUtils.isQ() && TextUtils.isEmpty((CharSequence)config.outPutCameraDir)) {
            videoUri = MediaStoreUtils.createVideoUri(context, cameraFileName, config.cameraVideoFormatForQ);
            config.cameraPath = videoUri != null ? videoUri.toString() : "";
        } else {
            File cameraFile = PictureFileUtils.createCameraFile(context, 2, cameraFileName, config.cameraVideoFormat, config.outPutCameraDir);
            config.cameraPath = cameraFile.getAbsolutePath();
            videoUri = PictureFileUtils.parUri(context, cameraFile);
        }
        return videoUri;
    }

    public static Uri createCameraOutAudioUri(Context context, PictureSelectionConfig config) {
        Uri audioUri = null;
        if (SdkVersionUtils.isQ()) {
            audioUri = MediaStoreUtils.createAudioUri(context, config.cameraAudioFormatForQ);
            config.cameraPath = audioUri != null ? audioUri.toString() : null;
        }
        return audioUri;
    }

    public static Uri createImageUri(Context ctx, String cameraFileName, String mimeType) {
        Context context = ctx.getApplicationContext();
        Uri[] imageFilePath = new Uri[]{null};
        String status = Environment.getExternalStorageState();
        ContentValues contentValues = MediaStoreUtils.buildImageContentValues(cameraFileName, mimeType);
        imageFilePath[0] = status.equals("mounted") ? context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues) : context.getContentResolver().insert(MediaStore.Images.Media.INTERNAL_CONTENT_URI, contentValues);
        return imageFilePath[0];
    }

    public static ContentValues buildImageContentValues(String customFileName, String mimeType) {
        String time = ValueOf.toString(System.currentTimeMillis());
        ContentValues values = new ContentValues(3);
        if (TextUtils.isEmpty((CharSequence)customFileName)) {
            values.put("_display_name", DateUtils.getCreateFileName("IMG_"));
        } else if (customFileName.lastIndexOf(".") == -1) {
            values.put("_display_name", DateUtils.getCreateFileName("IMG_"));
        } else {
            String suffix = customFileName.substring(customFileName.lastIndexOf("."));
            String fileName = customFileName.replaceAll(suffix, "");
            values.put("_display_name", fileName);
        }
        values.put("mime_type", TextUtils.isEmpty((CharSequence)mimeType) || mimeType.startsWith("video") ? "image/jpeg" : mimeType);
        if (SdkVersionUtils.isQ()) {
            values.put("datetaken", time);
            values.put("relative_path", "DCIM/Camera");
        }
        return values;
    }

    public static Uri createVideoUri(Context ctx, String cameraFileName, String mimeType) {
        Context context = ctx.getApplicationContext();
        Uri[] imageFilePath = new Uri[]{null};
        String status = Environment.getExternalStorageState();
        ContentValues contentValues = MediaStoreUtils.buildVideoContentValues(cameraFileName, mimeType);
        imageFilePath[0] = status.equals("mounted") ? context.getContentResolver().insert(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, contentValues) : context.getContentResolver().insert(MediaStore.Video.Media.INTERNAL_CONTENT_URI, contentValues);
        return imageFilePath[0];
    }

    public static ContentValues buildVideoContentValues(String customFileName, String mimeType) {
        String time = ValueOf.toString(System.currentTimeMillis());
        ContentValues values = new ContentValues(3);
        if (TextUtils.isEmpty((CharSequence)customFileName)) {
            values.put("_display_name", DateUtils.getCreateFileName("VID_"));
        } else if (customFileName.lastIndexOf(".") == -1) {
            values.put("_display_name", DateUtils.getCreateFileName("VID_"));
        } else {
            String suffix = customFileName.substring(customFileName.lastIndexOf("."));
            String fileName = customFileName.replaceAll(suffix, "");
            values.put("_display_name", fileName);
        }
        values.put("mime_type", TextUtils.isEmpty((CharSequence)mimeType) || mimeType.startsWith("image") ? "video/mp4" : mimeType);
        if (SdkVersionUtils.isQ()) {
            values.put("datetaken", time);
            values.put("relative_path", Environment.DIRECTORY_MOVIES);
        }
        return values;
    }

    public static Uri createAudioUri(Context ctx, String mimeType) {
        Context context = ctx.getApplicationContext();
        Uri[] imageFilePath = new Uri[]{null};
        String status = Environment.getExternalStorageState();
        String time = ValueOf.toString(System.currentTimeMillis());
        ContentValues values = new ContentValues(3);
        values.put("_display_name", DateUtils.getCreateFileName("AUD_"));
        if (Build.VERSION.SDK_INT >= 29) {
            values.put("datetaken", time);
        }
        values.put("mime_type", TextUtils.isEmpty((CharSequence)mimeType) || mimeType.startsWith("image") || mimeType.startsWith("video") ? "audio/amr" : mimeType);
        if (status.equals("mounted")) {
            if (Build.VERSION.SDK_INT >= 29) {
                values.put("relative_path", Environment.DIRECTORY_MUSIC);
            }
            imageFilePath[0] = context.getContentResolver().insert(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, values);
        } else {
            imageFilePath[0] = context.getContentResolver().insert(MediaStore.Audio.Media.INTERNAL_CONTENT_URI, values);
        }
        return imageFilePath[0];
    }
}

