/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.utils;

import com.luck.picture.lib.utils.ValueOf;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class DateUtils {
    private static final SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmssSSS");

    public static long getCurrentTimeMillis() {
        String timeToString = ValueOf.toString(System.currentTimeMillis());
        return ValueOf.toLong(timeToString.length() > 10 ? timeToString.substring(0, 10) : timeToString);
    }

    public static int dateDiffer(long d) {
        try {
            long l1 = DateUtils.getCurrentTimeMillis();
            long interval = l1 - d;
            return (int)Math.abs(interval);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static String formatDurationTime(long duration) {
        return String.format(Locale.getDefault(), "%02d:%02d", TimeUnit.MILLISECONDS.toMinutes(duration), TimeUnit.MILLISECONDS.toSeconds(duration) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duration)));
    }

    public static String getCreateFileName(String prefix) {
        long millis = System.currentTimeMillis();
        return prefix + sf.format(millis);
    }

    public static String getCreateFileName() {
        long millis = System.currentTimeMillis();
        return sf.format(millis);
    }

    public static String cdTime(long sTime, long eTime) {
        long diff = eTime - sTime;
        return diff > 1000L ? diff / 1000L + "\u79d2" : diff + "\u6beb\u79d2";
    }
}

