/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.utils.DateUtils;

public class AudioPlayDialog
extends Dialog
implements View.OnClickListener,
SeekBar.OnSeekBarChangeListener {
    private final MediaPlayer mediaPlayer;
    private final String audioPath;
    private final TextView tvMusicStatus;
    private final TextView tvMusicTime;
    private final TextView tvMusicTotal;
    private final TextView tvPlayPause;
    private final SeekBar musicSeekBar;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    public Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                AudioPlayDialog.this.tvMusicTime.setText((CharSequence)DateUtils.formatDurationTime(AudioPlayDialog.this.mediaPlayer.getCurrentPosition()));
                AudioPlayDialog.this.musicSeekBar.setProgress(AudioPlayDialog.this.mediaPlayer.getCurrentPosition());
                AudioPlayDialog.this.musicSeekBar.setMax(AudioPlayDialog.this.mediaPlayer.getDuration());
                AudioPlayDialog.this.tvMusicTotal.setText((CharSequence)DateUtils.formatDurationTime(AudioPlayDialog.this.mediaPlayer.getDuration()));
                AudioPlayDialog.this.mHandler.postDelayed(AudioPlayDialog.this.mRunnable, 50L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public AudioPlayDialog(@NonNull Context context, String audioPath) {
        super(context, R.style.Picture_Theme_Dialog);
        this.audioPath = audioPath;
        this.mediaPlayer = new MediaPlayer();
        this.setContentView(R.layout.ps_audio_play_dialog);
        this.getWindow().setWindowAnimations(R.style.Picture_Theme_Dialog_AudioStyle);
        this.tvMusicStatus = (TextView)this.findViewById(R.id.tv_musicStatus);
        this.tvMusicTime = (TextView)this.findViewById(R.id.tv_musicTime);
        this.musicSeekBar = (SeekBar)this.findViewById(R.id.music_seek_bar);
        this.tvMusicTotal = (TextView)this.findViewById(R.id.tv_music_total);
        this.tvPlayPause = (TextView)this.findViewById(R.id.tv_play_pause);
        TextView tvStop = (TextView)this.findViewById(R.id.tv_stop);
        TextView tvQuit = (TextView)this.findViewById(R.id.tv_quit);
        this.musicSeekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.tvPlayPause.setOnClickListener((View.OnClickListener)this);
        tvStop.setOnClickListener((View.OnClickListener)this);
        tvQuit.setOnClickListener((View.OnClickListener)this);
        this.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialogInterface) {
                AudioPlayDialog.this.mHandler.removeCallbacks(AudioPlayDialog.this.mRunnable);
                AudioPlayDialog.this.mediaPlayer.release();
            }
        });
    }

    protected void onStart() {
        super.onStart();
        try {
            if (PictureMimeType.isContent(this.audioPath)) {
                this.mediaPlayer.setDataSource(this.getContext(), Uri.parse((String)this.audioPath));
            } else {
                this.mediaPlayer.setDataSource(this.audioPath);
            }
            this.mediaPlayer.prepare();
            this.mediaPlayer.setLooping(true);
            this.playAudio();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.tv_play_pause) {
            this.playAudio();
        } else if (id2 == R.id.tv_stop) {
            this.stop(this.audioPath);
        } else if (id2 == R.id.tv_quit) {
            this.mHandler.removeCallbacks(this.mRunnable);
            this.stop(this.audioPath);
            this.dismiss();
        }
    }

    private void playAudio() {
        this.musicSeekBar.setProgress(this.mediaPlayer.getCurrentPosition());
        this.musicSeekBar.setMax(this.mediaPlayer.getDuration());
        if (this.mediaPlayer.isPlaying()) {
            this.tvPlayPause.setText((CharSequence)this.tvPlayPause.getContext().getString(R.string.ps_play_audio));
            this.tvMusicStatus.setText((CharSequence)this.tvPlayPause.getContext().getString(R.string.ps_pause_audio));
            this.mediaPlayer.pause();
        } else {
            this.tvPlayPause.setText((CharSequence)this.tvPlayPause.getContext().getString(R.string.ps_pause_audio));
            this.tvMusicStatus.setText((CharSequence)this.tvPlayPause.getContext().getString(R.string.ps_play_audio));
            this.mediaPlayer.start();
            this.mHandler.post(this.mRunnable);
        }
    }

    private void stop(String path) {
        try {
            this.mediaPlayer.stop();
            this.mediaPlayer.reset();
            if (PictureMimeType.isContent(path)) {
                this.mediaPlayer.setDataSource(this.getContext(), Uri.parse((String)path));
            } else {
                this.mediaPlayer.setDataSource(path);
            }
            this.mediaPlayer.prepare();
            this.mediaPlayer.seekTo(0);
            this.tvMusicStatus.setText((CharSequence)this.tvMusicStatus.getContext().getString(R.string.ps_stop_audio));
            this.tvPlayPause.setText((CharSequence)this.tvMusicStatus.getContext().getString(R.string.ps_play_audio));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        if (fromUser) {
            this.mediaPlayer.seekTo(progress);
        }
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
    }

    public static void showPlayAudioDialog(Context context, String path) {
        new AudioPlayDialog(context, path).show();
    }
}

