/*
 * Decompiled with CFR 0.152.
 */
package com.luck.lib.camerax.utils;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import androidx.core.content.FileProvider;
import com.luck.lib.camerax.utils.DateUtils;
import java.io.File;
import java.util.Objects;

public class FileUtils {
    public static final String POSTFIX = ".jpeg";
    public static final String POST_VIDEO = ".mp4";

    public static File createCameraFile(Context context, int chooseMode, String fileName, String format, String outCameraDirectory) {
        return FileUtils.createMediaFile(context, chooseMode, fileName, format, outCameraDirectory);
    }

    private static File createMediaFile(Context context, int chooseMode, String fileName, String format, String outCameraDirectory) {
        return FileUtils.createOutFile(context, chooseMode, fileName, format, outCameraDirectory);
    }

    private static File createOutFile(Context ctx, int chooseMode, String fileName, String format, String outCameraDirectory) {
        File folderDir;
        Context context = ctx.getApplicationContext();
        if (TextUtils.isEmpty((CharSequence)outCameraDirectory)) {
            File rootDir;
            if (TextUtils.equals((CharSequence)"mounted", (CharSequence)Environment.getExternalStorageState())) {
                rootDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
                folderDir = new File(rootDir.getAbsolutePath() + File.separator + "Camera" + File.separator);
            } else {
                rootDir = FileUtils.getRootDirFile(context, chooseMode);
                folderDir = new File(rootDir.getAbsolutePath() + File.separator);
            }
            if (!rootDir.exists()) {
                rootDir.mkdirs();
            }
        } else {
            folderDir = new File(outCameraDirectory);
            if (!Objects.requireNonNull(folderDir.getParentFile()).exists()) {
                folderDir.getParentFile().mkdirs();
            }
        }
        if (!folderDir.exists()) {
            folderDir.mkdirs();
        }
        boolean isOutFileNameEmpty = TextUtils.isEmpty((CharSequence)fileName);
        if (chooseMode == 2) {
            String newFileVideoName = isOutFileNameEmpty ? DateUtils.getCreateFileName("VID_") + POST_VIDEO : fileName;
            return new File(folderDir, newFileVideoName);
        }
        String suffix = TextUtils.isEmpty((CharSequence)format) ? POSTFIX : format;
        String newFileImageName = isOutFileNameEmpty ? DateUtils.getCreateFileName("IMG_") + suffix : fileName;
        return new File(folderDir, newFileImageName);
    }

    private static File getRootDirFile(Context context, int type) {
        if (type == 2) {
            return context.getExternalFilesDir(Environment.DIRECTORY_MOVIES);
        }
        return context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
    }

    public static Uri parUri(Context context, File cameraFile) {
        String authority = context.getPackageName() + ".luckProvider";
        Uri imageUri = Build.VERSION.SDK_INT > 23 ? FileProvider.getUriForFile((Context)context, (String)authority, (File)cameraFile) : Uri.fromFile((File)cameraFile);
        return imageUri;
    }

    public static boolean isContent(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return false;
        }
        return url.startsWith("content://");
    }

    public static void deleteFile(Context context, String path) {
        try {
            if (FileUtils.isContent(path)) {
                context.getContentResolver().delete(Uri.parse((String)path), null, null);
            } else {
                File file = new File(path);
                if (file.exists()) {
                    file.delete();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

