/*
 * Decompiled with CFR 0.152.
 */
package com.luck.lib.camerax.utils;

import android.content.ContentValues;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import com.luck.lib.camerax.utils.DateUtils;

public class CameraUtils {
    public static final int TYPE_IMAGE = 1;
    public static final int TYPE_VIDEO = 2;
    public static final String CAMERA = "Camera";
    public static final String MIME_TYPE_PREFIX_IMAGE = "image";
    public static final String MIME_TYPE_PREFIX_VIDEO = "video";
    public static final String MIME_TYPE_IMAGE = "image/jpeg";
    public static final String MIME_TYPE_VIDEO = "video/mp4";
    public static final String DCIM_CAMERA = "DCIM/Camera";
    public static final String JPEG = ".jpeg";
    public static final String MP4 = ".mp4";

    public static ContentValues buildImageContentValues(String cameraFileName, String mimeType) {
        String time = String.valueOf(System.currentTimeMillis());
        ContentValues values = new ContentValues(3);
        if (TextUtils.isEmpty((CharSequence)cameraFileName)) {
            values.put("_display_name", DateUtils.getCreateFileName("IMG_"));
        } else if (cameraFileName.lastIndexOf(".") == -1) {
            values.put("_display_name", DateUtils.getCreateFileName("IMG_"));
        } else {
            String suffix = cameraFileName.substring(cameraFileName.lastIndexOf("."));
            String fileName = cameraFileName.replaceAll(suffix, "");
            values.put("_display_name", fileName);
        }
        values.put("mime_type", TextUtils.isEmpty((CharSequence)mimeType) || mimeType.startsWith(MIME_TYPE_PREFIX_VIDEO) ? MIME_TYPE_IMAGE : mimeType);
        if (Build.VERSION.SDK_INT >= 29) {
            values.put("datetaken", time);
            values.put("relative_path", DCIM_CAMERA);
        }
        return values;
    }

    public static ContentValues buildVideoContentValues(String cameraFileName, String mimeType) {
        String time = String.valueOf(System.currentTimeMillis());
        ContentValues values = new ContentValues(3);
        if (TextUtils.isEmpty((CharSequence)cameraFileName)) {
            values.put("_display_name", DateUtils.getCreateFileName("VID_"));
        } else if (cameraFileName.lastIndexOf(".") == -1) {
            values.put("_display_name", DateUtils.getCreateFileName("VID_"));
        } else {
            String suffix = cameraFileName.substring(cameraFileName.lastIndexOf("."));
            String fileName = cameraFileName.replaceAll(suffix, "");
            values.put("_display_name", fileName);
        }
        values.put("mime_type", TextUtils.isEmpty((CharSequence)mimeType) || mimeType.startsWith(MIME_TYPE_PREFIX_IMAGE) ? MIME_TYPE_VIDEO : mimeType);
        if (Build.VERSION.SDK_INT >= 29) {
            values.put("datetaken", time);
            values.put("relative_path", Environment.DIRECTORY_MOVIES);
        }
        return values;
    }
}

