/*
 * Decompiled with CFR 0.152.
 */
package com.luck.lib.camerax;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import com.luck.lib.camerax.CustomCameraConfig;
import com.luck.lib.camerax.CustomCameraView;
import com.luck.lib.camerax.listener.CameraListener;
import com.luck.lib.camerax.listener.ClickListener;
import com.luck.lib.camerax.listener.ImageCallbackListener;
import com.luck.lib.camerax.permissions.PermissionChecker;
import com.luck.lib.camerax.permissions.PermissionResultCallback;

public class PictureCameraActivity
extends AppCompatActivity {
    private PermissionResultCallback mPermissionResultCallback;
    private CustomCameraView mCameraView;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.getWindow().setFlags(1024, 1024);
        this.getWindow().setFlags(0x4000000, 0x4000000);
        this.getWindow().setFlags(0x8000000, 0x8000000);
        if (Build.VERSION.SDK_INT >= 28) {
            WindowManager.LayoutParams lp = this.getWindow().getAttributes();
            lp.layoutInDisplayCutoutMode = 1;
            this.getWindow().setAttributes(lp);
        }
        this.getWindow().addFlags(128);
        super.onCreate(savedInstanceState);
        this.mCameraView = new CustomCameraView((Context)this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        this.mCameraView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.setContentView((View)this.mCameraView);
        this.mCameraView.setCameraConfig(this.getIntent());
        this.mCameraView.setImageCallbackListener(new ImageCallbackListener(){

            @Override
            public void onLoadImage(String url, ImageView imageView) {
                CustomCameraConfig.imageEngine.loadImage(imageView.getContext(), url, imageView);
            }
        });
        this.mCameraView.setCameraListener(new CameraListener(){

            @Override
            public void onPictureSuccess(@NonNull String url) {
                PictureCameraActivity.this.handleCameraSuccess();
            }

            @Override
            public void onRecordSuccess(@NonNull String url) {
                PictureCameraActivity.this.handleCameraSuccess();
            }

            @Override
            public void onError(int videoCaptureError, @NonNull String message, @Nullable Throwable cause) {
                Toast.makeText((Context)PictureCameraActivity.this, (CharSequence)message, (int)1).show();
                PictureCameraActivity.this.handleCameraCancel();
            }
        });
        this.mCameraView.setOnCancelClickListener(new ClickListener(){

            @Override
            public void onClick() {
                PictureCameraActivity.this.handleCameraCancel();
            }
        });
    }

    private void handleCameraSuccess() {
        Uri uri = (Uri)this.getIntent().getParcelableExtra("output");
        Intent intent = new Intent();
        intent.putExtra("output", (Parcelable)uri);
        this.setResult(-1, this.getIntent());
        this.onBackPressed();
    }

    private void handleCameraCancel() {
        this.setResult(0);
        this.onBackPressed();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.mCameraView.onCancelMedia();
        }
        return super.onKeyDown(keyCode, event);
    }

    public void onBackPressed() {
        super.onBackPressed();
        CustomCameraConfig.destroy();
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1102) {
            boolean checkSelfPermission = PermissionChecker.checkSelfPermission((Context)this, new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"});
            if (checkSelfPermission) {
                this.mCameraView.buildUseCameraCases();
            } else {
                this.handleCameraCancel();
            }
        } else if (requestCode == 1103 && !PermissionChecker.checkSelfPermission((Context)this, new String[]{"android.permission.RECORD_AUDIO"})) {
            Toast.makeText((Context)this, (CharSequence)"Missing recording permission", (int)1).show();
        }
    }

    public void setPermissionsResultAction(PermissionResultCallback callback) {
        this.mPermissionResultCallback = callback;
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (this.mPermissionResultCallback != null) {
            PermissionChecker.getInstance().onRequestPermissionsResult(grantResults, this.mPermissionResultCallback);
            this.mPermissionResultCallback = null;
        }
    }
}

