/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.io;

import android.content.ContentResolver;
import android.net.Uri;
import android.util.LruCache;
import com.luck.picture.lib.io.BufferedInputStreamWrap;
import com.luck.picture.lib.io.LruArrayPool;
import com.luck.picture.lib.tools.PictureFileUtils;
import java.io.InputStream;
import java.util.HashSet;

public class ArrayPoolProvide {
    private final HashSet<String> keyCache = new HashSet();
    private final LruCache<String, BufferedInputStreamWrap> bufferedLruCache = new LruCache(20);
    private final LruArrayPool arrayPool = new LruArrayPool(0x400000);
    private static final ArrayPoolProvide mInstance = new ArrayPoolProvide();

    public byte[] get(int bufferSize) {
        return this.arrayPool.get(bufferSize, byte[].class);
    }

    public void put(byte[] buffer) {
        this.arrayPool.put(buffer);
    }

    public InputStream openInputStream(ContentResolver resolver, Uri uri) {
        BufferedInputStreamWrap bufferedInputStreamWrap;
        try {
            bufferedInputStreamWrap = (BufferedInputStreamWrap)this.bufferedLruCache.get((Object)uri.toString());
            if (bufferedInputStreamWrap != null) {
                bufferedInputStreamWrap.reset();
            } else {
                bufferedInputStreamWrap = this.wrapInputStream(resolver, uri);
            }
        }
        catch (Exception e) {
            bufferedInputStreamWrap = this.wrapInputStream(resolver, uri);
        }
        return bufferedInputStreamWrap;
    }

    private BufferedInputStreamWrap wrapInputStream(ContentResolver resolver, Uri uri) {
        BufferedInputStreamWrap bufferedInputStreamWrap = null;
        try {
            bufferedInputStreamWrap = new BufferedInputStreamWrap(resolver.openInputStream(uri));
            int available = bufferedInputStreamWrap.available();
            bufferedInputStreamWrap.mark(available > 0 ? available : 0x500000);
            this.bufferedLruCache.put((Object)uri.toString(), (Object)bufferedInputStreamWrap);
            this.keyCache.add(uri.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bufferedInputStreamWrap;
    }

    public void clearMemory() {
        for (String key : this.keyCache) {
            BufferedInputStreamWrap inputStreamWrap = (BufferedInputStreamWrap)this.bufferedLruCache.get((Object)key);
            PictureFileUtils.close(inputStreamWrap);
            this.bufferedLruCache.remove((Object)key);
        }
        this.keyCache.clear();
        this.arrayPool.clearMemory();
    }

    public static ArrayPoolProvide getInstance() {
        return mInstance;
    }
}

