/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.manager;

import android.content.Context;
import android.os.Environment;
import com.luck.picture.lib.PictureMediaScannerConnection;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.listener.OnCallbackListener;
import com.luck.picture.lib.thread.PictureThreadUtils;
import java.io.File;

public class PictureCacheManager {
    public static void deleteCacheDirFile(String cacheDir) {
        PictureCacheManager.deleteCacheDirFile(cacheDir, null);
    }

    public static void deleteCacheDirFile(String cacheDir, OnCallbackListener<String> listener) {
        File cacheFileDir = new File(cacheDir);
        File[] files = cacheFileDir.listFiles();
        if (files != null) {
            for (File file : files) {
                boolean isResult;
                if (!file.isFile() || !(isResult = file.delete()) || listener == null) continue;
                listener.onCall(file.getAbsolutePath());
            }
        }
    }

    public static void deleteCacheRefreshDirFile(Context context, int type) {
        PictureCacheManager.deleteCacheDirFile(context, type, true, null);
    }

    public static void deleteCacheDirFile(Context context, int type) {
        PictureCacheManager.deleteCacheDirFile(context, type, false, null);
    }

    public static void deleteCacheDirFile(Context context, int type, OnCallbackListener<String> listener) {
        PictureCacheManager.deleteCacheDirFile(context, type, false, listener);
    }

    private static void deleteCacheDirFile(final Context context, int type, boolean isRefresh, OnCallbackListener<String> listener) {
        File[] files;
        File cutDir = context.getExternalFilesDir(type == PictureMimeType.ofImage() ? Environment.DIRECTORY_PICTURES : Environment.DIRECTORY_MOVIES);
        if (cutDir != null && (files = cutDir.listFiles()) != null) {
            for (final File file : files) {
                boolean isResult;
                if (!file.isFile() || !(isResult = file.delete())) continue;
                if (isRefresh) {
                    PictureThreadUtils.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            new PictureMediaScannerConnection(context, file.getAbsolutePath());
                        }
                    });
                    continue;
                }
                if (listener == null) continue;
                listener.onCall(file.getAbsolutePath());
            }
        }
    }

    public static void deleteAllCacheDirFile(Context context) {
        PictureCacheManager.deleteAllCacheDirFile(context, false, null);
    }

    public static void deleteAllCacheDirFile(Context context, OnCallbackListener<String> listener) {
        PictureCacheManager.deleteAllCacheDirFile(context, false, listener);
    }

    public static void deleteAllCacheDirRefreshFile(Context context) {
        PictureCacheManager.deleteAllCacheDirFile(context, true, null);
    }

    private static void deleteAllCacheDirFile(final Context context, boolean isRefresh, OnCallbackListener<String> listener) {
        File[] files;
        File dirMusic;
        File[] files2;
        File dirMovies;
        File[] files3;
        File dirPictures = context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        if (dirPictures != null && (files3 = dirPictures.listFiles()) != null) {
            for (final File file : files3) {
                boolean isResult;
                if (!file.isFile() || !(isResult = file.delete())) continue;
                if (isRefresh) {
                    PictureThreadUtils.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            new PictureMediaScannerConnection(context, file.getAbsolutePath());
                        }
                    });
                    continue;
                }
                if (listener == null) continue;
                listener.onCall(file.getAbsolutePath());
            }
        }
        if ((dirMovies = context.getExternalFilesDir(Environment.DIRECTORY_MOVIES)) != null && (files2 = dirMovies.listFiles()) != null) {
            for (final File file : files2) {
                boolean isResult;
                if (!file.isFile() || !(isResult = file.delete())) continue;
                if (isRefresh) {
                    PictureThreadUtils.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            new PictureMediaScannerConnection(context, file.getAbsolutePath());
                        }
                    });
                    continue;
                }
                if (listener == null) continue;
                listener.onCall(file.getAbsolutePath());
            }
        }
        if ((dirMusic = context.getExternalFilesDir(Environment.DIRECTORY_MUSIC)) != null && (files = dirMusic.listFiles()) != null) {
            for (final File file : files) {
                boolean isResult;
                if (!file.isFile() || !(isResult = file.delete())) continue;
                if (isRefresh) {
                    PictureThreadUtils.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            new PictureMediaScannerConnection(context, file.getAbsolutePath());
                        }
                    });
                    continue;
                }
                if (listener == null) continue;
                listener.onCall(file.getAbsolutePath());
            }
        }
    }
}

