/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter;

import android.content.Context;
import android.graphics.ColorFilter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.BlendModeColorFilterCompat;
import androidx.core.graphics.BlendModeCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import java.util.ArrayList;
import java.util.List;

public class PictureWeChatPreviewGalleryAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<LocalMedia> mList = new ArrayList<LocalMedia>();
    private final PictureSelectionConfig config;
    private OnItemClickListener listener;

    public PictureWeChatPreviewGalleryAdapter(PictureSelectionConfig config) {
        this.config = config;
    }

    public void setNewData(List<LocalMedia> data, boolean isBottomPreview) {
        if (data != null) {
            if (isBottomPreview) {
                this.mList.clear();
                this.mList.addAll(data);
            } else {
                this.mList = data;
            }
            this.notifyDataSetChanged();
        }
    }

    public void addSingleMediaToData(LocalMedia media) {
        this.mList.clear();
        this.mList.add(media);
        this.notifyDataSetChanged();
    }

    public void removeMediaToData(LocalMedia media) {
        if (this.mList.size() > 0) {
            this.mList.remove(media);
            this.notifyDataSetChanged();
        }
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.picture_wechat_preview_gallery, parent, false);
        return new ViewHolder(itemView);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        LocalMedia item = this.getItem(position);
        if (item != null) {
            ColorFilter colorFilter = BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)ContextCompat.getColor((Context)holder.itemView.getContext(), (int)(item.isMaxSelectEnabledMask() ? R.color.picture_color_half_white : R.color.picture_color_transparent)), (BlendModeCompat)BlendModeCompat.SRC_ATOP);
            if (item.isChecked() && item.isMaxSelectEnabledMask()) {
                holder.viewBorder.setVisibility(0);
            } else {
                holder.viewBorder.setVisibility(item.isChecked() ? 0 : 8);
            }
            holder.ivImage.setColorFilter(colorFilter);
            holder.ivImage.setColorFilter(colorFilter);
            if (this.config != null && PictureSelectionConfig.imageEngine != null) {
                PictureSelectionConfig.imageEngine.loadImage(holder.itemView.getContext(), item.getPath(), holder.ivImage);
            }
            holder.ivPlay.setVisibility(PictureMimeType.isHasVideo(item.getMimeType()) ? 0 : 8);
            holder.itemView.setOnClickListener(v -> {
                if (this.listener != null && holder.getAbsoluteAdapterPosition() >= 0) {
                    this.listener.onItemClick(holder.getAbsoluteAdapterPosition(), this.getItem(position), v);
                }
            });
        }
    }

    public LocalMedia getItem(int position) {
        return this.mList.size() > 0 ? this.mList.get(position) : null;
    }

    public void setItemClickListener(OnItemClickListener listener) {
        this.listener = listener;
    }

    public int getItemCount() {
        return this.mList.size();
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1, LocalMedia var2, View var3);
    }

    static class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView ivImage;
        ImageView ivPlay;
        View viewBorder;

        public ViewHolder(View itemView) {
            super(itemView);
            this.ivImage = (ImageView)itemView.findViewById(R.id.ivImage);
            this.ivPlay = (ImageView)itemView.findViewById(R.id.ivPlay);
            this.viewBorder = itemView.findViewById(R.id.viewBorder);
            if (PictureSelectionConfig.uiStyle != null) {
                this.viewBorder.setBackgroundResource(PictureSelectionConfig.uiStyle.picture_bottom_gallery_frameBackground);
            }
        }
    }
}

