/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.tools;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.exifinterface.media.ExifInterface;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.MediaExtraInfo;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.ValueOf;

public class MediaUtils {
    @Nullable
    public static Uri createImageUri(Context ctx, String cameraFileName, String suffixType) {
        Context context = ctx.getApplicationContext();
        Uri[] imageFilePath = new Uri[]{null};
        String status = Environment.getExternalStorageState();
        String time = ValueOf.toString(System.currentTimeMillis());
        ContentValues values = new ContentValues(3);
        if (TextUtils.isEmpty((CharSequence)cameraFileName)) {
            values.put("_display_name", DateUtils.getCreateFileName("IMG_"));
        } else if (cameraFileName.lastIndexOf(".") == -1) {
            values.put("_display_name", DateUtils.getCreateFileName("IMG_"));
        } else {
            String suffix = cameraFileName.substring(cameraFileName.lastIndexOf("."));
            String fileName = cameraFileName.replaceAll(suffix, "");
            values.put("_display_name", fileName);
        }
        if (Build.VERSION.SDK_INT >= 29) {
            values.put("datetaken", time);
        }
        values.put("mime_type", TextUtils.isEmpty((CharSequence)suffixType) || suffixType.startsWith("video") ? "image/jpeg" : suffixType);
        if (status.equals("mounted")) {
            if (Build.VERSION.SDK_INT >= 29) {
                values.put("relative_path", "DCIM/Camera");
            }
            imageFilePath[0] = context.getContentResolver().insert(MediaStore.Images.Media.getContentUri((String)"external"), values);
        } else {
            imageFilePath[0] = context.getContentResolver().insert(MediaStore.Images.Media.getContentUri((String)"internal"), values);
        }
        return imageFilePath[0];
    }

    @Nullable
    public static Uri createVideoUri(Context ctx, String cameraFileName, String suffixType) {
        Context context = ctx.getApplicationContext();
        Uri[] imageFilePath = new Uri[]{null};
        String status = Environment.getExternalStorageState();
        String time = ValueOf.toString(System.currentTimeMillis());
        ContentValues values = new ContentValues(3);
        if (TextUtils.isEmpty((CharSequence)cameraFileName)) {
            values.put("_display_name", DateUtils.getCreateFileName("VID_"));
        } else if (cameraFileName.lastIndexOf(".") == -1) {
            values.put("_display_name", DateUtils.getCreateFileName("VID_"));
        } else {
            String suffix = cameraFileName.substring(cameraFileName.lastIndexOf("."));
            String fileName = cameraFileName.replaceAll(suffix, "");
            values.put("_display_name", fileName);
        }
        if (Build.VERSION.SDK_INT >= 29) {
            values.put("datetaken", time);
        }
        values.put("mime_type", TextUtils.isEmpty((CharSequence)suffixType) || suffixType.startsWith("image") ? "video/mp4" : suffixType);
        if (status.equals("mounted")) {
            if (Build.VERSION.SDK_INT >= 29) {
                values.put("relative_path", Environment.DIRECTORY_MOVIES);
            }
            imageFilePath[0] = context.getContentResolver().insert(MediaStore.Video.Media.getContentUri((String)"external"), values);
        } else {
            imageFilePath[0] = context.getContentResolver().insert(MediaStore.Video.Media.getContentUri((String)"internal"), values);
        }
        return imageFilePath[0];
    }

    public static boolean isLongImg(LocalMedia media) {
        int width = media.getWidth();
        int height = media.getHeight();
        if (width <= 0 || height <= 0) {
            return false;
        }
        int newHeight = width * 3;
        return height > newHeight;
    }

    public static boolean isLongImg(int width, int height) {
        if (width <= 0 || height <= 0) {
            return false;
        }
        int newHeight = width * 3;
        return height > newHeight;
    }

    public static MediaExtraInfo getImageSize(String url) {
        MediaExtraInfo mediaExtraInfo = new MediaExtraInfo();
        try {
            ExifInterface exifInterface = new ExifInterface(url);
            mediaExtraInfo.setWidth(exifInterface.getAttributeInt("ImageWidth", 1));
            mediaExtraInfo.setHeight(exifInterface.getAttributeInt("ImageLength", 1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mediaExtraInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaExtraInfo getVideoSize(String url) {
        MediaExtraInfo mediaExtraInfo = new MediaExtraInfo();
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        try {
            int width;
            int height;
            retriever.setDataSource(url);
            String orientation = retriever.extractMetadata(24);
            if (TextUtils.equals((CharSequence)"90", (CharSequence)orientation) || TextUtils.equals((CharSequence)"270", (CharSequence)orientation)) {
                height = ValueOf.toInt(retriever.extractMetadata(18));
                width = ValueOf.toInt(retriever.extractMetadata(19));
            } else {
                width = ValueOf.toInt(retriever.extractMetadata(18));
                height = ValueOf.toInt(retriever.extractMetadata(19));
            }
            mediaExtraInfo.setWidth(width);
            mediaExtraInfo.setHeight(height);
            mediaExtraInfo.setDuration(ValueOf.toLong(retriever.extractMetadata(9)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            retriever.release();
        }
        return mediaExtraInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaExtraInfo getAudioSize(String url) {
        MediaExtraInfo mediaExtraInfo = new MediaExtraInfo();
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        try {
            retriever.setDataSource(url);
            mediaExtraInfo.setDuration(ValueOf.toLong(retriever.extractMetadata(9)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            retriever.release();
        }
        return mediaExtraInfo;
    }

    public static void removeMedia(Context context, int id2) {
        try {
            ContentResolver cr = context.getApplicationContext().getContentResolver();
            Uri uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            String selection = "_id=?";
            cr.delete(uri, selection, new String[]{Long.toString(id2)});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDCIMLastImageId(Context context) {
        try (Cursor data = null;){
            String absolutePath = PictureFileUtils.getDCIMCameraPath();
            String selection = "_data like ?";
            String[] selectionArgs = new String[]{absolutePath + "%"};
            if (SdkVersionUtils.checkedAndroid_R()) {
                Bundle queryArgs = MediaUtils.createQueryArgsBundle(selection, selectionArgs, 1, 0);
                data = context.getApplicationContext().getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, null, queryArgs, null);
            } else {
                String orderBy = "_id DESC limit 1 offset 0";
                data = context.getApplicationContext().getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, null, selection, selectionArgs, orderBy);
            }
            if (data != null && data.getCount() > 0 && data.moveToFirst()) {
                int id2 = data.getInt(data.getColumnIndex("_id"));
                long date = data.getLong(data.getColumnIndex("date_added"));
                int duration = DateUtils.dateDiffer(date);
                int n = duration <= 1 ? id2 : -1;
                return n;
            }
            int n = -1;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCameraFirstBucketId(Context context) {
        try (Cursor data = null;){
            String absolutePath = PictureFileUtils.getDCIMCameraPath();
            String selection = "_data like ?";
            String[] selectionArgs = new String[]{absolutePath + "%"};
            if (SdkVersionUtils.checkedAndroid_R()) {
                Bundle queryArgs = MediaUtils.createQueryArgsBundle(selection, selectionArgs, 1, 0);
                data = context.getApplicationContext().getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), null, queryArgs, null);
            } else {
                String orderBy = "_id DESC limit 1 offset 0";
                data = context.getApplicationContext().getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), null, selection, selectionArgs, orderBy);
            }
            if (data != null && data.getCount() > 0 && data.moveToFirst()) {
                long l = data.getLong(data.getColumnIndex("bucket_id"));
                return l;
            }
        }
        return -1L;
    }

    @Nullable
    public static String getAudioFilePathFromUri(Context context, Uri uri) {
        String path = "";
        try (Cursor cursor = context.getApplicationContext().getContentResolver().query(uri, null, null, null, null);){
            if (cursor != null) {
                cursor.moveToFirst();
                int index = cursor.getColumnIndex("_data");
                path = cursor.getString(index);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return path;
    }

    public static Bundle createQueryArgsBundle(String selection, String[] selectionArgs, int limitCount, int offset) {
        Bundle queryArgs = new Bundle();
        if (Build.VERSION.SDK_INT >= 26) {
            queryArgs.putString("android:query-arg-sql-selection", selection);
            queryArgs.putStringArray("android:query-arg-sql-selection-args", selectionArgs);
            queryArgs.putString("android:query-arg-sql-sort-order", "_id DESC");
            if (Build.VERSION.SDK_INT >= 30) {
                queryArgs.putString("android:query-arg-sql-limit", limitCount + " offset " + offset);
            }
        }
        return queryArgs;
    }

    public static void deleteCamera(Context context, String cameraPath) {
        if (TextUtils.isEmpty((CharSequence)cameraPath)) {
            return;
        }
        if (SdkVersionUtils.checkedAndroid_Q() && PictureMimeType.isContent(cameraPath)) {
            context.getContentResolver().delete(Uri.parse((String)cameraPath), null, null);
        }
    }
}

