/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop.util;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import java.io.File;

public class MimeType {
    public static final String MIME_TYPE_PREFIX_IMAGE = "image";
    public static final String MIME_TYPE_PREFIX_VIDEO = "video";

    public static boolean isHasImage(String mimeType) {
        return mimeType != null && mimeType.startsWith(MIME_TYPE_PREFIX_IMAGE);
    }

    public static boolean isGifForSuffix(String suffix) {
        return suffix != null && suffix.startsWith(".gif") || suffix.startsWith(".GIF");
    }

    public static boolean isHasVideo(String mimeType) {
        return mimeType != null && mimeType.startsWith(MIME_TYPE_PREFIX_VIDEO);
    }

    public static String getLastImgType(String path) {
        try {
            int index = path.lastIndexOf(".");
            if (index > 0) {
                String imageType;
                switch (imageType = path.substring(index)) {
                    case ".png": 
                    case ".PNG": 
                    case ".jpg": 
                    case ".jpeg": 
                    case ".JPEG": 
                    case ".WEBP": 
                    case ".bmp": 
                    case ".BMP": 
                    case ".webp": 
                    case ".gif": 
                    case ".GIF": {
                        return imageType;
                    }
                }
                return ".png";
            }
            return ".png";
        }
        catch (Exception e) {
            e.printStackTrace();
            return ".png";
        }
    }

    public static String getImageMimeType(String path) {
        try {
            if (!TextUtils.isEmpty((CharSequence)path)) {
                File file = new File(path);
                String fileName = file.getName();
                int last = fileName.lastIndexOf(".") + 1;
                String temp = fileName.substring(last);
                return "image/" + temp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "image/jpeg";
        }
        return "image/jpeg";
    }

    public static boolean isHttp(String path) {
        return !TextUtils.isEmpty((CharSequence)path) && path.startsWith("http") || path.startsWith("https");
    }

    public static boolean isGif(String mimeType) {
        return mimeType != null && (mimeType.equals("image/gif") || mimeType.equals("image/GIF"));
    }

    public static boolean isContent(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return false;
        }
        return url.startsWith("content://");
    }

    public static String getMimeTypeFromMediaContentUri(Context context, Uri uri) {
        String mimeType;
        if (uri.getScheme().equals("content")) {
            ContentResolver cr = context.getContentResolver();
            mimeType = cr.getType(uri);
        } else {
            String fileExtension = MimeTypeMap.getFileExtensionFromUrl((String)uri.toString());
            mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(fileExtension.toLowerCase());
        }
        return TextUtils.isEmpty((CharSequence)mimeType) ? "image/jpeg" : mimeType;
    }
}

