/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.model;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.ValueOf;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

@Deprecated
public final class LocalMediaLoader {
    private static final String TAG = LocalMediaLoader.class.getSimpleName();
    private static final Uri QUERY_URI = MediaStore.Files.getContentUri((String)"external");
    private static final String ORDER_BY = "_id DESC";
    private static final String NOT_GIF_UNKNOWN = "!='image/*'";
    private static final String NOT_GIF = " AND (mime_type!='image/gif' AND mime_type!='image/*')";
    private final Context mContext;
    private final boolean isAndroidQ;
    private final PictureSelectionConfig config;
    private static final long FILE_SIZE_UNIT = 0x100000L;
    private static final String[] PROJECTION = new String[]{"_id", "_data", "mime_type", "width", "height", "duration", "_size", "bucket_display_name", "_display_name", "bucket_id", "date_added"};

    private static String getSelectionArgsForVideoOrAudioMediaCondition(String sizeCondition, String queryMimeCondition) {
        return "media_type=?" + queryMimeCondition + " AND " + sizeCondition;
    }

    private static String getSelectionArgsForAllMediaCondition(String timeCondition, String sizeCondition, String queryMimeCondition) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(").append("media_type").append("=?").append(queryMimeCondition).append(" OR ").append("media_type").append("=? AND ").append(timeCondition).append(") AND ").append(sizeCondition).toString();
        return stringBuilder.toString();
    }

    private static String getSelectionArgsForImageMediaCondition(String sizeCondition, String queryMimeCondition) {
        return "media_type=?" + queryMimeCondition + " AND " + sizeCondition;
    }

    private static String[] getSelectionArgsForAllMediaType() {
        return new String[]{String.valueOf(1), String.valueOf(3)};
    }

    private static String[] getSelectionArgsForSingleMediaType(int mediaType) {
        return new String[]{String.valueOf(mediaType)};
    }

    public LocalMediaLoader(Context context) {
        this.mContext = context.getApplicationContext();
        this.isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        this.config = PictureSelectionConfig.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LocalMediaFolder> loadAllMedia() {
        Cursor data = this.mContext.getContentResolver().query(QUERY_URI, PROJECTION, this.getSelection(), this.getSelectionArgs(), ORDER_BY);
        try {
            if (data != null) {
                ArrayList<LocalMediaFolder> imageFolders = new ArrayList<LocalMediaFolder>();
                LocalMediaFolder allImageFolder = new LocalMediaFolder();
                ArrayList<LocalMedia> latelyImages = new ArrayList<LocalMedia>();
                int count = data.getCount();
                if (count > 0) {
                    int idColumn = data.getColumnIndexOrThrow(PROJECTION[0]);
                    int dataColumn = data.getColumnIndexOrThrow(PROJECTION[1]);
                    int mimeTypeColumn = data.getColumnIndexOrThrow(PROJECTION[2]);
                    int widthColumn = data.getColumnIndexOrThrow(PROJECTION[3]);
                    int heightColumn = data.getColumnIndexOrThrow(PROJECTION[4]);
                    int durationColumn = data.getColumnIndexOrThrow(PROJECTION[5]);
                    int sizeColumn = data.getColumnIndexOrThrow(PROJECTION[6]);
                    int folderNameColumn = data.getColumnIndexOrThrow(PROJECTION[7]);
                    int fileNameColumn = data.getColumnIndexOrThrow(PROJECTION[8]);
                    int bucketIdColumn = data.getColumnIndexOrThrow(PROJECTION[9]);
                    int dateAddedColumn = data.getColumnIndexOrThrow(PROJECTION[10]);
                    data.moveToFirst();
                    do {
                        long id2 = data.getLong(idColumn);
                        String absolutePath = data.getString(dataColumn);
                        String url = this.isAndroidQ ? this.getRealPathAndroid_Q(id2) : absolutePath;
                        String mimeType = data.getString(mimeTypeColumn);
                        String string2 = mimeType = TextUtils.isEmpty((CharSequence)mimeType) ? PictureMimeType.ofJPEG() : mimeType;
                        if (mimeType.endsWith("image/*")) {
                            boolean isGif;
                            mimeType = PictureMimeType.isContent(url) ? PictureMimeType.getImageMimeType(absolutePath) : PictureMimeType.getImageMimeType(url);
                            if (!this.config.isGif && (isGif = PictureMimeType.isGif(mimeType))) continue;
                        }
                        if (!this.config.isWebp && mimeType.startsWith(PictureMimeType.ofWEBP()) || !this.config.isBmp && mimeType.startsWith(PictureMimeType.ofBMP())) continue;
                        int width = data.getInt(widthColumn);
                        int height = data.getInt(heightColumn);
                        long duration = data.getLong(durationColumn);
                        long size = data.getLong(sizeColumn);
                        String folderName = data.getString(folderNameColumn);
                        String fileName = data.getString(fileNameColumn);
                        long bucketId = data.getLong(bucketIdColumn);
                        if (this.config.filterFileSize > 0.0f && (float)size > this.config.filterFileSize * 1048576.0f || PictureMimeType.isHasVideo(mimeType) && (this.config.videoMinSecond > 0 && duration < (long)this.config.videoMinSecond || this.config.videoMaxSecond > 0 && duration > (long)this.config.videoMaxSecond || duration == 0L || size <= 0L)) continue;
                        LocalMedia image = new LocalMedia(id2, url, absolutePath, fileName, folderName, duration, this.config.chooseMode, mimeType, width, height, size, bucketId, data.getLong(dateAddedColumn));
                        LocalMediaFolder folder = this.getImageFolder(url, folderName, imageFolders);
                        folder.setBucketId(image.getBucketId());
                        List<LocalMedia> images = folder.getData();
                        images.add(image);
                        folder.setImageNum(folder.getImageNum() + 1);
                        folder.setBucketId(image.getBucketId());
                        latelyImages.add(image);
                        int imageNum = allImageFolder.getImageNum();
                        allImageFolder.setImageNum(imageNum + 1);
                    } while (data.moveToNext());
                    if (latelyImages.size() > 0) {
                        this.sortFolder(imageFolders);
                        imageFolders.add(0, allImageFolder);
                        allImageFolder.setFirstImagePath(((LocalMedia)latelyImages.get(0)).getPath());
                        String title = this.config.chooseMode == PictureMimeType.ofAudio() ? this.mContext.getString(R.string.picture_all_audio) : this.mContext.getString(R.string.picture_camera_roll);
                        allImageFolder.setName(title);
                        allImageFolder.setBucketId(-1L);
                        allImageFolder.setOfAllType(this.config.chooseMode);
                        allImageFolder.setCameraFolder(true);
                        allImageFolder.setData(latelyImages);
                    }
                }
                ArrayList<LocalMediaFolder> arrayList = imageFolders;
                return arrayList;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)("loadAllMedia Data Error: " + e.getMessage()));
            List<LocalMediaFolder> list = null;
            return list;
        }
        finally {
            if (data != null && !data.isClosed()) {
                data.close();
            }
        }
        return null;
    }

    private String getSelection() {
        String durationCondition = this.getDurationCondition();
        String fileSizeCondition = this.getFileSizeCondition();
        String queryMimeCondition = this.getQueryMimeCondition();
        switch (this.config.chooseMode) {
            case 0: {
                return LocalMediaLoader.getSelectionArgsForAllMediaCondition(durationCondition, fileSizeCondition, queryMimeCondition);
            }
            case 1: {
                return LocalMediaLoader.getSelectionArgsForImageMediaCondition(fileSizeCondition, queryMimeCondition);
            }
            case 2: {
                return LocalMediaLoader.getSelectionArgsForVideoOrAudioMediaCondition(fileSizeCondition, queryMimeCondition);
            }
            case 3: {
                return LocalMediaLoader.getSelectionArgsForVideoOrAudioMediaCondition(durationCondition, queryMimeCondition);
            }
        }
        return null;
    }

    private String[] getSelectionArgs() {
        switch (this.config.chooseMode) {
            case 0: {
                return LocalMediaLoader.getSelectionArgsForAllMediaType();
            }
            case 1: {
                return LocalMediaLoader.getSelectionArgsForSingleMediaType(1);
            }
            case 2: {
                return LocalMediaLoader.getSelectionArgsForSingleMediaType(3);
            }
            case 3: {
                return LocalMediaLoader.getSelectionArgsForSingleMediaType(2);
            }
        }
        return null;
    }

    private void sortFolder(List<LocalMediaFolder> imageFolders) {
        Collections.sort(imageFolders, (lhs, rhs) -> {
            if (lhs.getData() == null || rhs.getData() == null) {
                return 0;
            }
            int lSize = lhs.getImageNum();
            int rSize = rhs.getImageNum();
            return Integer.compare(rSize, lSize);
        });
    }

    private String getRealPathAndroid_Q(long id2) {
        return QUERY_URI.buildUpon().appendPath(ValueOf.toString(id2)).build().toString();
    }

    private LocalMediaFolder getImageFolder(String path, String folderName, List<LocalMediaFolder> imageFolders) {
        if (!this.config.isFallbackVersion) {
            for (LocalMediaFolder folder : imageFolders) {
                String name = folder.getName();
                if (TextUtils.isEmpty((CharSequence)name) || !name.equals(folderName)) continue;
                return folder;
            }
            LocalMediaFolder newFolder = new LocalMediaFolder();
            newFolder.setName(folderName);
            newFolder.setFirstImagePath(path);
            imageFolders.add(newFolder);
            return newFolder;
        }
        File imageFile = new File(path);
        File folderFile = imageFile.getParentFile();
        for (LocalMediaFolder folder : imageFolders) {
            String name = folder.getName();
            if (TextUtils.isEmpty((CharSequence)name) || folderFile == null || !name.equals(folderFile.getName())) continue;
            return folder;
        }
        LocalMediaFolder newFolder = new LocalMediaFolder();
        newFolder.setName(folderFile != null ? folderFile.getName() : "");
        newFolder.setFirstImagePath(path);
        imageFolders.add(newFolder);
        return newFolder;
    }

    private String getDurationCondition() {
        long maxS = this.config.videoMaxSecond == 0 ? Long.MAX_VALUE : (long)this.config.videoMaxSecond;
        return String.format(Locale.CHINA, "%d <%s duration and duration <= %d", Math.max(0L, (long)this.config.videoMinSecond), Math.max(0L, (long)this.config.videoMinSecond) == 0L ? "" : "=", maxS);
    }

    private String getFileSizeCondition() {
        long maxS = this.config.filterMaxFileSize == 0L ? Long.MAX_VALUE : this.config.filterMaxFileSize;
        return String.format(Locale.CHINA, "%d <%s _size and _size <= %d", Math.max(0L, this.config.filterMinFileSize), Math.max(0L, this.config.filterMinFileSize) == 0L ? "" : "=", maxS);
    }

    private String getQueryMimeCondition() {
        HashSet<String> stringHashSet = this.config.queryMimeTypeHashSet;
        if (stringHashSet == null) {
            stringHashSet = new HashSet();
        }
        if (!TextUtils.isEmpty((CharSequence)this.config.specifiedFormat)) {
            stringHashSet.add(this.config.specifiedFormat);
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = stringHashSet.iterator();
        int index = -1;
        while (iterator.hasNext()) {
            stringBuilder.append(++index == 0 ? " AND " : " OR ").append("mime_type").append("='").append(iterator.next()).append("'");
        }
        if (this.config.chooseMode != PictureMimeType.ofVideo() && !this.config.isGif && !stringHashSet.contains(PictureMimeType.ofGIF())) {
            stringBuilder.append(NOT_GIF);
        }
        return stringBuilder.toString();
    }
}

