/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.tools;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.graphics.BitmapFactory;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.exifinterface.media.ExifInterface;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.listener.OnCallbackListener;
import com.luck.picture.lib.thread.PictureThreadUtils;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.ValueOf;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.InputStream;
import java.util.Objects;

public class MediaUtils {
    @Nullable
    public static Uri createImageUri(Context ctx, String cameraFileName, String suffixType) {
        Context context = ctx.getApplicationContext();
        Uri[] imageFilePath = new Uri[]{null};
        String status = Environment.getExternalStorageState();
        String time = ValueOf.toString(System.currentTimeMillis());
        ContentValues values = new ContentValues(3);
        if (TextUtils.isEmpty((CharSequence)cameraFileName)) {
            values.put("_display_name", DateUtils.getCreateFileName("IMG_"));
        } else if (cameraFileName.lastIndexOf(".") == -1) {
            values.put("_display_name", DateUtils.getCreateFileName("IMG_"));
        } else {
            String suffix = cameraFileName.substring(cameraFileName.lastIndexOf("."));
            String fileName = cameraFileName.replaceAll(suffix, "");
            values.put("_display_name", fileName);
        }
        if (Build.VERSION.SDK_INT >= 29) {
            values.put("datetaken", time);
        }
        values.put("mime_type", TextUtils.isEmpty((CharSequence)suffixType) || suffixType.startsWith("video") ? "image/jpeg" : suffixType);
        if (status.equals("mounted")) {
            if (Build.VERSION.SDK_INT >= 29) {
                values.put("relative_path", "DCIM/Camera");
            }
            imageFilePath[0] = context.getContentResolver().insert(MediaStore.Images.Media.getContentUri((String)"external"), values);
        } else {
            imageFilePath[0] = context.getContentResolver().insert(MediaStore.Images.Media.getContentUri((String)"internal"), values);
        }
        return imageFilePath[0];
    }

    @Nullable
    public static Uri createVideoUri(Context ctx, String cameraFileName, String suffixType) {
        Context context = ctx.getApplicationContext();
        Uri[] imageFilePath = new Uri[]{null};
        String status = Environment.getExternalStorageState();
        String time = ValueOf.toString(System.currentTimeMillis());
        ContentValues values = new ContentValues(3);
        if (TextUtils.isEmpty((CharSequence)cameraFileName)) {
            values.put("_display_name", DateUtils.getCreateFileName("VID_"));
        } else if (cameraFileName.lastIndexOf(".") == -1) {
            values.put("_display_name", DateUtils.getCreateFileName("VID_"));
        } else {
            String suffix = cameraFileName.substring(cameraFileName.lastIndexOf("."));
            String fileName = cameraFileName.replaceAll(suffix, "");
            values.put("_display_name", fileName);
        }
        if (Build.VERSION.SDK_INT >= 29) {
            values.put("datetaken", time);
        }
        values.put("mime_type", TextUtils.isEmpty((CharSequence)suffixType) || suffixType.startsWith("image") ? "video/mp4" : suffixType);
        if (status.equals("mounted")) {
            if (Build.VERSION.SDK_INT >= 29) {
                values.put("relative_path", Environment.DIRECTORY_MOVIES);
            }
            imageFilePath[0] = context.getContentResolver().insert(MediaStore.Video.Media.getContentUri((String)"external"), values);
        } else {
            imageFilePath[0] = context.getContentResolver().insert(MediaStore.Video.Media.getContentUri((String)"internal"), values);
        }
        return imageFilePath[0];
    }

    public static long extractDuration(Context context, boolean isAndroidQ, String path) {
        return isAndroidQ ? MediaUtils.getLocalDuration(context, Uri.parse((String)path)) : MediaUtils.getLocalDuration(path);
    }

    public static boolean isLongImg(LocalMedia media) {
        if (null != media) {
            int newHeight;
            int width = media.getWidth();
            int height = media.getHeight();
            return height > (newHeight = width * 3);
        }
        return false;
    }

    public static boolean isLongImg(int width, int height) {
        int newHeight = width * 3;
        return height > newHeight;
    }

    private static long getLocalDuration(Context context, Uri uri) {
        try {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(context, uri);
            return Long.parseLong(Objects.requireNonNull(mmr.extractMetadata(9)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private static long getLocalDuration(String path) {
        try {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(path);
            return Long.parseLong(Objects.requireNonNull(mmr.extractMetadata(9)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getImageSizeForUrlToAndroidQ(Context context, String url) {
        int[] size = new int[2];
        try (Cursor query = null;){
            if (Build.VERSION.SDK_INT >= 26 && (query = context.getApplicationContext().getContentResolver().query(Uri.parse((String)url), null, null, null)) != null) {
                query.moveToFirst();
                size[0] = query.getInt(query.getColumnIndexOrThrow("width"));
                size[1] = query.getInt(query.getColumnIndexOrThrow("height"));
            }
        }
        return size;
    }

    public static int[] getVideoSizeForUrl(String url) {
        int[] size = new int[2];
        try {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(url);
            size[0] = ValueOf.toInt(mmr.extractMetadata(18));
            size[1] = ValueOf.toInt(mmr.extractMetadata(19));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    public static void getVideoSizeForUri(final Context context, final Uri uri, final LocalMedia media) {
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<Integer[]>(){

            @Override
            public Integer[] doInBackground() {
                MediaMetadataRetriever mmr = new MediaMetadataRetriever();
                mmr.setDataSource(context, uri);
                int width = ValueOf.toInt(mmr.extractMetadata(18));
                int height = ValueOf.toInt(mmr.extractMetadata(19));
                return new Integer[]{width, height};
            }

            @Override
            public void onSuccess(Integer[] result) {
                media.setWidth(result[0]);
                media.setHeight(result[1]);
                PictureThreadUtils.cancel((PictureThreadUtils.Task)this);
            }
        });
    }

    public static int[] getImageSizeForUrl(String url) {
        int width = 0;
        int height = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(url);
            width = exifInterface.getAttributeInt("ImageWidth", 1);
            height = exifInterface.getAttributeInt("ImageLength", 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new int[]{width, height};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getImageSizeForUri(Context context, Uri uri) {
        ParcelFileDescriptor fileDescriptor;
        int height;
        int width;
        block4: {
            width = 0;
            height = 0;
            fileDescriptor = null;
            try {
                fileDescriptor = context.getContentResolver().openFileDescriptor(uri, "r");
                if (fileDescriptor == null) break block4;
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor.getFileDescriptor(), null, (BitmapFactory.Options)options);
                width = options.outWidth;
                height = options.outHeight;
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    PictureFileUtils.close(fileDescriptor);
                    throw throwable;
                }
                PictureFileUtils.close((Closeable)fileDescriptor);
            }
        }
        PictureFileUtils.close((Closeable)fileDescriptor);
        return new int[]{width, height};
    }

    public static void removeMedia(Context context, int id2) {
        try {
            ContentResolver cr = context.getApplicationContext().getContentResolver();
            Uri uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            String selection = "_id=?";
            cr.delete(uri, selection, new String[]{Long.toString(id2)});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDCIMLastImageId(Context context) {
        try (Cursor data = null;){
            String absolutePath = PictureFileUtils.getDCIMCameraPath();
            String selection = "_data like ?";
            String[] selectionArgs = new String[]{absolutePath + "%"};
            if (SdkVersionUtils.checkedAndroid_R()) {
                Bundle queryArgs = MediaUtils.createQueryArgsBundle(selection, selectionArgs, 1, 0);
                data = context.getApplicationContext().getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, null, queryArgs, null);
            } else {
                String orderBy = "_id DESC limit 1 offset 0";
                data = context.getApplicationContext().getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, null, selection, selectionArgs, orderBy);
            }
            if (data != null && data.getCount() > 0 && data.moveToFirst()) {
                int id2 = data.getInt(data.getColumnIndex("_id"));
                long date = data.getLong(data.getColumnIndex("date_added"));
                int duration = DateUtils.dateDiffer(date);
                int n = duration <= 1 ? id2 : -1;
                return n;
            }
            int n = -1;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCameraFirstBucketId(Context context) {
        try (Cursor data = null;){
            String absolutePath = PictureFileUtils.getDCIMCameraPath();
            String selection = "_data like ?";
            String[] selectionArgs = new String[]{absolutePath + "%"};
            if (SdkVersionUtils.checkedAndroid_R()) {
                Bundle queryArgs = MediaUtils.createQueryArgsBundle(selection, selectionArgs, 1, 0);
                data = context.getApplicationContext().getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), null, queryArgs, null);
            } else {
                String orderBy = "_id DESC limit 1 offset 0";
                data = context.getApplicationContext().getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), null, selection, selectionArgs, orderBy);
            }
            if (data != null && data.getCount() > 0 && data.moveToFirst()) {
                long l = data.getLong(data.getColumnIndex("bucket_id"));
                return l;
            }
        }
        return -1L;
    }

    @Nullable
    public static String getAudioFilePathFromUri(Context context, Uri uri) {
        String path = "";
        try (Cursor cursor = context.getApplicationContext().getContentResolver().query(uri, null, null, null, null);){
            if (cursor != null) {
                cursor.moveToFirst();
                int index = cursor.getColumnIndex("_data");
                path = cursor.getString(index);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return path;
    }

    public static int getVideoOrientationForUrl(String path) {
        try {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(path);
            int rotation = ValueOf.toInt(mmr.extractMetadata(24));
            switch (rotation) {
                case 90: {
                    return 6;
                }
                case 270: {
                    return 8;
                }
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int getVideoOrientationForUri(Context context, Uri uri) {
        try {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(context, uri);
            int orientation = ValueOf.toInt(mmr.extractMetadata(24));
            switch (orientation) {
                case 90: {
                    return 6;
                }
                case 270: {
                    return 8;
                }
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getImageOrientationForUrl(Context context, String url) {
        ExifInterface exifInterface = null;
        InputStream inputStream = null;
        int defaultInt = 0;
        try {
            if (SdkVersionUtils.checkedAndroid_Q() && PictureMimeType.isContent(url)) {
                inputStream = context.getContentResolver().openInputStream(Uri.parse((String)url));
                if (inputStream != null) {
                    exifInterface = new ExifInterface(inputStream);
                }
            } else {
                exifInterface = new ExifInterface(url);
            }
            int n = exifInterface != null ? exifInterface.getAttributeInt("Orientation", 1) : 0;
            PictureFileUtils.close(inputStream);
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            PictureFileUtils.close(inputStream);
        }
        return defaultInt;
    }

    public static void setOrientationAsynchronous(final Context context, final LocalMedia media, boolean isAndroidQChangeWH, boolean isAndroidQChangeVideoWH, final OnCallbackListener<LocalMedia> listener) {
        if (PictureMimeType.isHasImage(media.getMimeType()) && !isAndroidQChangeWH) {
            return;
        }
        if (PictureMimeType.isHasVideo(media.getMimeType()) && !isAndroidQChangeVideoWH) {
            return;
        }
        if (media.getOrientation() != -1) {
            if (listener != null) {
                listener.onCall(media);
            }
            return;
        }
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<Integer>(){

            @Override
            public Integer doInBackground() {
                int orientation = 0;
                if (PictureMimeType.isHasImage(media.getMimeType())) {
                    orientation = MediaUtils.getImageOrientationForUrl(context, media.getPath());
                } else if (PictureMimeType.isHasVideo(media.getMimeType())) {
                    orientation = PictureMimeType.isContent(media.getPath()) ? MediaUtils.getVideoOrientationForUri(context, Uri.parse((String)media.getPath())) : MediaUtils.getVideoOrientationForUrl(media.getPath());
                }
                return orientation;
            }

            @Override
            public void onSuccess(Integer orientation) {
                if (orientation == 6 || orientation == 8) {
                    media.setWidth(media.getHeight());
                    media.setHeight(media.getWidth());
                }
                media.setOrientation(orientation);
                if (listener != null) {
                    listener.onCall(media);
                }
            }
        });
    }

    public static void setOrientationSynchronous(Context context, LocalMedia media, boolean isAndroidQChangeWH, boolean isAndroidQChangeVideoWH) {
        if (PictureMimeType.isHasImage(media.getMimeType()) && !isAndroidQChangeWH) {
            return;
        }
        if (PictureMimeType.isHasVideo(media.getMimeType()) && !isAndroidQChangeVideoWH) {
            return;
        }
        int orientation = 0;
        if (PictureMimeType.isHasImage(media.getMimeType())) {
            orientation = MediaUtils.getImageOrientationForUrl(context, media.getPath());
        } else if (PictureMimeType.isHasVideo(media.getMimeType())) {
            orientation = PictureMimeType.isContent(media.getPath()) ? MediaUtils.getVideoOrientationForUri(context, Uri.parse((String)media.getPath())) : MediaUtils.getVideoOrientationForUrl(media.getPath());
        }
        if (orientation == 6 || orientation == 8) {
            media.setWidth(media.getHeight());
            media.setHeight(media.getWidth());
        }
        media.setOrientation(orientation);
    }

    public static Bundle createQueryArgsBundle(String selection, String[] selectionArgs, int limitCount, int offset) {
        Bundle queryArgs = new Bundle();
        if (Build.VERSION.SDK_INT >= 26) {
            queryArgs.putString("android:query-arg-sql-selection", selection);
            queryArgs.putStringArray("android:query-arg-sql-selection-args", selectionArgs);
            queryArgs.putString("android:query-arg-sql-sort-order", "_id DESC");
            if (Build.VERSION.SDK_INT >= 30) {
                queryArgs.putString("android:query-arg-sql-limit", limitCount + " offset " + offset);
            }
        }
        return queryArgs;
    }
}

