/*
 * Decompiled with CFR 0.152.
 */
package top.zibin.luban;

import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import top.zibin.luban.Checker;
import top.zibin.luban.CompressionPredicate;
import top.zibin.luban.Engine;
import top.zibin.luban.InputStreamAdapter;
import top.zibin.luban.InputStreamProvider;
import top.zibin.luban.LubanUtils;
import top.zibin.luban.OnCompressListener;
import top.zibin.luban.OnRenameListener;
import top.zibin.luban.io.ArrayPoolProvide;

public class Luban
implements Handler.Callback {
    private static final String TAG = "Luban";
    private static final String DEFAULT_DISK_CACHE_DIR = "luban_disk_cache";
    private static final int MSG_COMPRESS_SUCCESS = 0;
    private static final int MSG_COMPRESS_START = 1;
    private static final int MSG_COMPRESS_ERROR = 2;
    private String mTargetDir;
    private boolean focusAlpha;
    private boolean isUseIOBufferPool;
    private int mLeastCompressSize;
    private OnRenameListener mRenameListener;
    private OnCompressListener mCompressListener;
    private CompressionPredicate mCompressionPredicate;
    private List<InputStreamProvider> mStreamProviders;
    private Handler mHandler;

    private Luban(Builder builder) {
        this.mTargetDir = builder.mTargetDir;
        this.focusAlpha = builder.focusAlpha;
        this.isUseIOBufferPool = builder.isUseBufferPool;
        this.mRenameListener = builder.mRenameListener;
        this.mStreamProviders = builder.mStreamProviders;
        this.mCompressListener = builder.mCompressListener;
        this.mLeastCompressSize = builder.mLeastCompressSize;
        this.mCompressionPredicate = builder.mCompressionPredicate;
        this.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    }

    public static Builder with(Context context) {
        return new Builder(context);
    }

    private File getImageCacheFile(Context context, String suffix) {
        if (TextUtils.isEmpty((CharSequence)this.mTargetDir)) {
            this.mTargetDir = this.getImageCacheDir(context).getAbsolutePath();
        }
        String cacheBuilder = this.mTargetDir + "/" + System.currentTimeMillis() + (int)(Math.random() * 1000.0) + (TextUtils.isEmpty((CharSequence)suffix) ? ".jpg" : suffix);
        return new File(cacheBuilder);
    }

    private File getImageCustomFile(Context context, String filename) {
        if (TextUtils.isEmpty((CharSequence)this.mTargetDir)) {
            this.mTargetDir = this.getImageCacheDir(context).getAbsolutePath();
        }
        String cacheBuilder = this.mTargetDir + "/" + filename;
        return new File(cacheBuilder);
    }

    private File getImageCacheDir(Context context) {
        return Luban.getImageCacheDir(context, DEFAULT_DISK_CACHE_DIR);
    }

    private static File getImageCacheDir(Context context, String cacheName) {
        File cacheDir = context.getExternalCacheDir();
        if (cacheDir != null) {
            File result = new File(cacheDir, cacheName);
            if (!(result.mkdirs() || result.exists() && result.isDirectory())) {
                return null;
            }
            return result;
        }
        if (Log.isLoggable((String)TAG, (int)6)) {
            Log.e((String)TAG, (String)"default disk cache dir is null");
        }
        return null;
    }

    private void launch(final Context context) {
        if (this.mStreamProviders == null || this.mStreamProviders.size() == 0 && this.mCompressListener != null) {
            this.mCompressListener.onError(new NullPointerException("image file cannot be null"));
        }
        Iterator<InputStreamProvider> iterator = this.mStreamProviders.iterator();
        while (iterator.hasNext()) {
            final InputStreamProvider path = iterator.next();
            AsyncTask.SERIAL_EXECUTOR.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Luban.this.mHandler.sendMessage(Luban.this.mHandler.obtainMessage(1));
                        File result = Luban.this.compress(context, path);
                        Message message = Luban.this.mHandler.obtainMessage(0);
                        message.arg1 = path.getIndex();
                        message.obj = result;
                        Luban.this.mHandler.sendMessage(message);
                    }
                    catch (IOException e) {
                        Luban.this.mHandler.sendMessage(Luban.this.mHandler.obtainMessage(2, (Object)e));
                    }
                }
            });
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File get(InputStreamProvider input, Context context) throws IOException {
        try {
            File file = new Engine(input, this.getImageCacheFile(context, Checker.SINGLE.extSuffix(input)), this.focusAlpha).compress();
            return file;
        }
        finally {
            input.close();
        }
    }

    private List<File> get(Context context) throws IOException {
        ArrayList<File> results = new ArrayList<File>();
        Iterator<InputStreamProvider> iterator = this.mStreamProviders.iterator();
        while (iterator.hasNext()) {
            results.add(this.compress(context, iterator.next()));
            iterator.remove();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File compress(Context context, InputStreamProvider path) throws IOException {
        try {
            File file = this.compressReal(context, path);
            return file;
        }
        finally {
            path.close();
        }
    }

    private File compressReal(Context context, InputStreamProvider path) throws IOException {
        File outFile = this.getImageCacheFile(context, Checker.SINGLE.extSuffix(path));
        if (this.mRenameListener != null) {
            String filename = this.mRenameListener.rename(path.getPath());
            outFile = this.getImageCustomFile(context, filename);
        }
        File result = this.mCompressionPredicate != null ? (this.mCompressionPredicate.apply(path.getPath()) && Checker.SINGLE.needCompress(this.mLeastCompressSize, path.getPath()) ? new Engine(path, outFile, this.focusAlpha).compress() : new File("")) : (Checker.SINGLE.needCompress(this.mLeastCompressSize, path.getPath()) ? new Engine(path, outFile, this.focusAlpha).compress() : new File(path.getPath()));
        return result;
    }

    public boolean handleMessage(Message msg) {
        if (this.mCompressListener == null) {
            return false;
        }
        switch (msg.what) {
            case 1: {
                this.mCompressListener.onStart();
                break;
            }
            case 0: {
                this.mCompressListener.onSuccess(msg.arg1, (File)msg.obj);
                break;
            }
            case 2: {
                this.mCompressListener.onError((Throwable)msg.obj);
            }
        }
        return false;
    }

    public static class Builder {
        private Context context;
        private String mTargetDir;
        private boolean focusAlpha;
        private boolean isUseBufferPool;
        private int mLeastCompressSize = 100;
        private OnRenameListener mRenameListener;
        private OnCompressListener mCompressListener;
        private CompressionPredicate mCompressionPredicate;
        private List<InputStreamProvider> mStreamProviders;

        Builder(Context context) {
            this.context = context;
            this.mStreamProviders = new ArrayList<InputStreamProvider>();
        }

        private Luban build() {
            return new Luban(this);
        }

        public Builder load(InputStreamProvider inputStreamProvider) {
            this.mStreamProviders.add(inputStreamProvider);
            return this;
        }

        public Builder load(final File file, final int index) {
            this.mStreamProviders.add(new InputStreamAdapter(){

                @Override
                public InputStream openInternal() {
                    return ArrayPoolProvide.getInstance().openInputStream(file.getAbsolutePath());
                }

                @Override
                public int getIndex() {
                    return index;
                }

                @Override
                public String getPath() {
                    return file.getAbsolutePath();
                }
            });
            return this;
        }

        public Builder load(final String string, final int index) {
            this.mStreamProviders.add(new InputStreamAdapter(){

                @Override
                public InputStream openInternal() {
                    return ArrayPoolProvide.getInstance().openInputStream(string);
                }

                @Override
                public int getIndex() {
                    return index;
                }

                @Override
                public String getPath() {
                    return string;
                }
            });
            return this;
        }

        public <T> Builder load(List<T> list) {
            int index = -1;
            for (T src : list) {
                ++index;
                if (src instanceof String) {
                    this.load((String)src, index);
                    continue;
                }
                if (src instanceof File) {
                    this.load((File)src, index);
                    continue;
                }
                if (src instanceof Uri) {
                    this.load((Uri)src, index);
                    continue;
                }
                throw new IllegalArgumentException("Incoming data type exception, it must be String, File, Uri or Bitmap");
            }
            return this;
        }

        public Builder load(final Uri uri, final int index) {
            this.mStreamProviders.add(new InputStreamAdapter(){

                @Override
                public InputStream openInternal() throws IOException {
                    if (isUseBufferPool) {
                        return ArrayPoolProvide.getInstance().openInputStream(context.getContentResolver(), uri);
                    }
                    return context.getContentResolver().openInputStream(uri);
                }

                @Override
                public int getIndex() {
                    return index;
                }

                @Override
                public String getPath() {
                    return Checker.isContent(uri.toString()) ? LubanUtils.getPath(context, uri) : uri.getPath();
                }
            });
            return this;
        }

        @Deprecated
        public Builder putGear(int gear) {
            return this;
        }

        public Builder setRenameListener(OnRenameListener listener) {
            this.mRenameListener = listener;
            return this;
        }

        public Builder setCompressListener(OnCompressListener listener) {
            this.mCompressListener = listener;
            return this;
        }

        public Builder setTargetDir(String targetDir) {
            this.mTargetDir = targetDir;
            return this;
        }

        @Deprecated
        public Builder setFocusAlpha(boolean focusAlpha) {
            this.focusAlpha = focusAlpha;
            return this;
        }

        public Builder isUseIOBufferPool(boolean isUseBufferPool) {
            this.isUseBufferPool = isUseBufferPool;
            return this;
        }

        public Builder ignoreBy(int size) {
            this.mLeastCompressSize = size;
            return this;
        }

        public Builder filter(CompressionPredicate compressionPredicate) {
            this.mCompressionPredicate = compressionPredicate;
            return this;
        }

        public void launch() {
            this.build().launch(this.context);
        }

        public File get(final String path) throws IOException {
            return this.build().get(new InputStreamAdapter(){

                @Override
                public InputStream openInternal() {
                    return ArrayPoolProvide.getInstance().openInputStream(path);
                }

                @Override
                public int getIndex() {
                    return 0;
                }

                @Override
                public String getPath() {
                    return path;
                }
            }, this.context);
        }

        public List<File> get() throws IOException {
            return this.build().get(this.context);
        }
    }
}

