/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.security;

import io.grpc.BindableService;
import io.grpc.MethodDescriptor;
import io.grpc.ServerInterceptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.lognet.springboot.grpc.GRpcServicesRegistry;
import org.lognet.springboot.grpc.security.AuthenticatedConfigAttribute;
import org.lognet.springboot.grpc.security.GrpcSecurity;
import org.lognet.springboot.grpc.security.GrpcSecurityMetadataSource;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class GrpcServiceAuthorizationConfigurer
extends SecurityConfigurerAdapter<ServerInterceptor, GrpcSecurity> {
    private final Registry registry;

    public GrpcServiceAuthorizationConfigurer(GRpcServicesRegistry registry) {
        this.registry = new Registry(registry);
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void configure(GrpcSecurity builder) throws Exception {
        this.registry.processSecuredAnnotation();
        builder.setSharedObject(GrpcSecurityMetadataSource.class, new GrpcSecurityMetadataSource(this.registry.servicesRegistry, (Map<MethodDescriptor<?, ?>, List<ConfigAttribute>>)this.registry.securedMethods));
    }

    public class Registry {
        private MultiValueMap<MethodDescriptor<?, ?>, ConfigAttribute> securedMethods = new LinkedMultiValueMap();
        GRpcServicesRegistry servicesRegistry;
        private boolean withSecuredAnnotation = true;

        Registry(GRpcServicesRegistry servicesRegistry) {
            this.servicesRegistry = servicesRegistry;
        }

        public GrpcSecurity withoutSecuredAnnotation() {
            return this.withSecuredAnnotation(false);
        }

        public AuthorizedMethod anyMethod() {
            return this.anyMethodExcluding((MethodDescriptor<?, ?> s) -> false);
        }

        public AuthorizedMethod anyMethodExcluding(MethodDescriptor<?, ?> ... methodDescriptor) {
            List<MethodDescriptor<?, ?>> excludedMethods = Arrays.asList(methodDescriptor);
            return this.anyMethodExcluding(excludedMethods::contains);
        }

        public AuthorizedMethod anyMethodExcluding(Predicate<MethodDescriptor<?, ?>> excludePredicate) {
            MethodDescriptor[] allMethods = (MethodDescriptor[])this.servicesRegistry.getBeanNameToServiceBeanMap().values().stream().map(BindableService::bindService).map(ServerServiceDefinition::getServiceDescriptor).map(ServiceDescriptor::getMethods).flatMap(Collection::stream).filter(excludePredicate.negate()).toArray(MethodDescriptor[]::new);
            return new AuthorizedMethod(allMethods);
        }

        public AuthorizedMethod anyService() {
            return this.anyServiceExcluding((ServiceDescriptor s) -> false);
        }

        public AuthorizedMethod anyServiceExcluding(ServiceDescriptor ... serviceDescriptor) {
            List<ServiceDescriptor> excludedServices = Arrays.asList(serviceDescriptor);
            return this.anyServiceExcluding(excludedServices::contains);
        }

        public AuthorizedMethod anyServiceExcluding(Predicate<ServiceDescriptor> excludePredicate) {
            ServiceDescriptor[] allServices = (ServiceDescriptor[])this.servicesRegistry.getBeanNameToServiceBeanMap().values().stream().map(BindableService::bindService).map(ServerServiceDefinition::getServiceDescriptor).filter(excludePredicate.negate()).toArray(ServiceDescriptor[]::new);
            return new AuthorizedMethod(allServices);
        }

        public GrpcSecurity withSecuredAnnotation() {
            return this.withSecuredAnnotation(true);
        }

        public GrpcSecurity withSecuredAnnotation(boolean withSecuredAnnotation) {
            this.withSecuredAnnotation = withSecuredAnnotation;
            return this.and();
        }

        private void processSecuredAnnotation() {
            if (this.withSecuredAnnotation) {
                Collection<BindableService> services = this.servicesRegistry.getBeanNameToServiceBeanMap().values();
                for (BindableService service : services) {
                    ServerServiceDefinition serverServiceDefinition = service.bindService();
                    Optional.ofNullable((Secured)AnnotationUtils.findAnnotation(service.getClass(), Secured.class)).ifPresent(secured -> {
                        if (secured.value().length == 0) {
                            new AuthorizedMethod(serverServiceDefinition.getServiceDescriptor()).authenticated();
                        } else {
                            new AuthorizedMethod(serverServiceDefinition.getServiceDescriptor()).hasAnyAuthority(secured.value());
                        }
                    });
                    for (ServerMethodDefinition methodDefinition : serverServiceDefinition.getMethods()) {
                        List<Secured> secureds = Stream.of(service.getClass().getMethods()).filter(m -> m.getName().equalsIgnoreCase(methodDefinition.getMethodDescriptor().getBareMethodName())).map((? super T m) -> (Secured)AnnotationUtils.findAnnotation((Method)m, Secured.class)).filter(Objects::nonNull).toList();
                        if (secureds.isEmpty()) continue;
                        if (1 == secureds.size()) {
                            Secured secured2 = secureds.get(0);
                            if (secured2.value().length == 0) {
                                new AuthorizedMethod(methodDefinition.getMethodDescriptor()).authenticated();
                                continue;
                            }
                            new AuthorizedMethod(methodDefinition.getMethodDescriptor()).hasAnyAuthority(secured2.value());
                            continue;
                        }
                        String errorMessage = String.format("Ambiguous 'Secured'  method '%s' in service '%s'.When securing reactive method,  the @Secured  annotation should be added to the method getting 'Mono<Request>' and not with pure 'Request' argument.", methodDefinition.getMethodDescriptor().getBareMethodName(), service.getClass().getName());
                        throw new BeanCreationException(errorMessage);
                    }
                }
            }
        }

        public AuthorizedMethod methods(MethodDescriptor<?, ?> ... methodDescriptor) {
            return new AuthorizedMethod(methodDescriptor);
        }

        public AuthorizedMethod services(ServiceDescriptor ... serviceDescriptor) {
            return new AuthorizedMethod(serviceDescriptor);
        }

        void map(List<MethodDescriptor<?, ?>> methods) {
            methods.forEach(m -> this.securedMethods.addAll(m, Collections.singletonList(new AuthenticatedConfigAttribute())));
        }

        void map(String attribute, List<MethodDescriptor<?, ?>> methods) {
            methods.forEach(m -> this.securedMethods.addAll(m, SecurityConfig.createList((String[])new String[]{attribute})));
        }

        public GrpcSecurity and() {
            return (GrpcSecurity)GrpcServiceAuthorizationConfigurer.this.and();
        }
    }

    public class AuthorizedMethod {
        private List<MethodDescriptor<?, ?>> methods;

        private AuthorizedMethod(MethodDescriptor<?, ?> ... methodDescriptor) {
            this.methods = Arrays.asList(methodDescriptor);
        }

        private AuthorizedMethod(ServiceDescriptor ... serviceDescriptor) {
            this.methods = Stream.of(serviceDescriptor).flatMap(s -> s.getMethods().stream()).collect(Collectors.toList());
        }

        public Registry authenticated() {
            GrpcServiceAuthorizationConfigurer.this.registry.map(this.methods);
            return GrpcServiceAuthorizationConfigurer.this.registry;
        }

        public Registry hasAnyRole(String ... roles) {
            String rolePrefix = "ROLE_";
            for (String role : roles) {
                if (!role.startsWith(rolePrefix)) continue;
                throw new IllegalArgumentException("role should not start with 'ROLE_' since it is automatically inserted. Got '" + role + "'");
            }
            return this.hasAnyAuthority((String[])Arrays.stream(roles).map(rolePrefix::concat).toArray(String[]::new));
        }

        public Registry hasAnyAuthority(String ... authorities) {
            for (String auth : authorities) {
                GrpcServiceAuthorizationConfigurer.this.registry.map(auth, this.methods);
            }
            return GrpcServiceAuthorizationConfigurer.this.registry;
        }
    }
}

