/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.recovery;

import io.grpc.Attributes;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.Optional;

public class GRpcExceptionScope {
    private MethodDescriptor<?, ?> methodDescriptor;
    private Attributes methodCallAttributes;
    private Metadata callHeaders;
    private Object request;
    private Object response;
    private Object hint;
    final Metadata responseHeaders;

    public Object getRequestOrResponse() {
        return Optional.ofNullable(this.request).orElse(this.response);
    }

    public <T> Optional<T> getHintAs(Class<T> clazz) {
        return Optional.ofNullable(this.hint).filter(clazz::isInstance).map(clazz::cast);
    }

    private static Metadata $default$responseHeaders() {
        return new Metadata();
    }

    GRpcExceptionScope(MethodDescriptor<?, ?> methodDescriptor, Attributes methodCallAttributes, Metadata callHeaders, Object request, Object response, Object hint, Metadata responseHeaders) {
        this.methodDescriptor = methodDescriptor;
        this.methodCallAttributes = methodCallAttributes;
        this.callHeaders = callHeaders;
        this.request = request;
        this.response = response;
        this.hint = hint;
        this.responseHeaders = responseHeaders;
    }

    public static GRpcExceptionScopeBuilder builder() {
        return new GRpcExceptionScopeBuilder();
    }

    public MethodDescriptor<?, ?> getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public Attributes getMethodCallAttributes() {
        return this.methodCallAttributes;
    }

    public Metadata getCallHeaders() {
        return this.callHeaders;
    }

    public Object getRequest() {
        return this.request;
    }

    public Object getResponse() {
        return this.response;
    }

    public Object getHint() {
        return this.hint;
    }

    public Metadata getResponseHeaders() {
        return this.responseHeaders;
    }

    public static class GRpcExceptionScopeBuilder {
        private MethodDescriptor<?, ?> methodDescriptor;
        private Attributes methodCallAttributes;
        private Metadata callHeaders;
        private Object request;
        private Object response;
        private Object hint;
        private boolean responseHeaders$set;
        private Metadata responseHeaders$value;

        GRpcExceptionScopeBuilder() {
        }

        public GRpcExceptionScopeBuilder methodDescriptor(MethodDescriptor<?, ?> methodDescriptor) {
            this.methodDescriptor = methodDescriptor;
            return this;
        }

        public GRpcExceptionScopeBuilder methodCallAttributes(Attributes methodCallAttributes) {
            this.methodCallAttributes = methodCallAttributes;
            return this;
        }

        public GRpcExceptionScopeBuilder callHeaders(Metadata callHeaders) {
            this.callHeaders = callHeaders;
            return this;
        }

        public GRpcExceptionScopeBuilder request(Object request) {
            this.request = request;
            return this;
        }

        public GRpcExceptionScopeBuilder response(Object response) {
            this.response = response;
            return this;
        }

        public GRpcExceptionScopeBuilder hint(Object hint) {
            this.hint = hint;
            return this;
        }

        public GRpcExceptionScopeBuilder responseHeaders(Metadata responseHeaders) {
            this.responseHeaders$value = responseHeaders;
            this.responseHeaders$set = true;
            return this;
        }

        public GRpcExceptionScope build() {
            Metadata responseHeaders$value = this.responseHeaders$value;
            if (!this.responseHeaders$set) {
                responseHeaders$value = GRpcExceptionScope.$default$responseHeaders();
            }
            return new GRpcExceptionScope(this.methodDescriptor, this.methodCallAttributes, this.callHeaders, this.request, this.response, this.hint, responseHeaders$value);
        }

        public String toString() {
            return "GRpcExceptionScope.GRpcExceptionScopeBuilder(methodDescriptor=" + this.methodDescriptor + ", methodCallAttributes=" + this.methodCallAttributes + ", callHeaders=" + this.callHeaders + ", request=" + this.request + ", response=" + this.response + ", hint=" + this.hint + ", responseHeaders$value=" + this.responseHeaders$value + ")";
        }
    }
}

