/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.autoconfigure;

import java.util.LinkedHashSet;
import java.util.Optional;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class NettyServerBuilderSelector
implements ImportSelector,
EnvironmentAware {
    private Environment environment;

    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        String pureNettyConfig = ClassUtils.isPresent((String)"io.grpc.netty.NettyServerBuilder", (ClassLoader)classLoader) ? "org.lognet.springboot.grpc.autoconfigure.PureNettyConfiguration" : null;
        String shadedNettyConfig = ClassUtils.isPresent((String)"io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder", (ClassLoader)classLoader) ? "org.lognet.springboot.grpc.autoconfigure.ShadedNettyConfiguration" : null;
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        if (null != pureNettyConfig && null != shadedNettyConfig) {
            Boolean preferShadedNetty = (Boolean)Binder.get((Environment)this.environment).bind(ConfigurationPropertyName.of((CharSequence)"grpc.netty-server.on-collision-prefer-shaded-netty"), Bindable.of(Boolean.class)).orElse((Object)true);
            imports.add(preferShadedNetty != false ? shadedNettyConfig : pureNettyConfig);
        } else {
            String cfg = Optional.ofNullable(shadedNettyConfig).orElse(Optional.ofNullable(pureNettyConfig).orElse(null));
            Optional.ofNullable(cfg).ifPresent(imports::add);
        }
        return StringUtils.toStringArray(imports);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

