/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl;

import com.ibm.wsdl.AbstractWSDLElement;
import com.ibm.wsdl.BindingFaultImpl;
import com.ibm.wsdl.BindingImpl;
import com.ibm.wsdl.BindingInputImpl;
import com.ibm.wsdl.BindingOperationImpl;
import com.ibm.wsdl.BindingOutputImpl;
import com.ibm.wsdl.Constants;
import com.ibm.wsdl.FaultImpl;
import com.ibm.wsdl.ImportImpl;
import com.ibm.wsdl.InputImpl;
import com.ibm.wsdl.MessageImpl;
import com.ibm.wsdl.OperationImpl;
import com.ibm.wsdl.OutputImpl;
import com.ibm.wsdl.PartImpl;
import com.ibm.wsdl.PortImpl;
import com.ibm.wsdl.PortTypeImpl;
import com.ibm.wsdl.ServiceImpl;
import com.ibm.wsdl.TypesImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.xml.namespace.QName;

public class DefinitionImpl
extends AbstractWSDLElement
implements Definition {
    private String documentBaseURI = null;
    private QName name = null;
    private String targetNamespace = null;
    private final Map<String, String> namespaces = new HashMap<String, String>();
    private final Map<String, List<Import>> imports = new HashMap<String, List<Import>>();
    private Types types = null;
    private final Map<QName, Message> messages = new HashMap<QName, Message>();
    private final Map<QName, Binding> bindings = new HashMap<QName, Binding>();
    private final Map<QName, PortType> portTypes = new HashMap<QName, PortType>();
    private final Map<QName, Service> services = new HashMap<QName, Service>();
    private final List<String> nativeAttributeNames = Arrays.asList(Constants.DEFINITION_ATTR_NAMES);
    private ExtensionRegistry extReg = null;
    public static final long serialVersionUID = 1L;

    @Override
    public void setDocumentBaseURI(String documentBaseURI) {
        this.documentBaseURI = documentBaseURI;
    }

    @Override
    public String getDocumentBaseURI() {
        return this.documentBaseURI;
    }

    @Override
    public void setQName(QName name) {
        this.name = name;
    }

    @Override
    public QName getQName() {
        return this.name;
    }

    @Override
    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    @Override
    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    @Override
    public void addNamespace(String prefix, String namespaceURI) {
        if (prefix == null) {
            prefix = "";
        }
        if (namespaceURI != null) {
            this.namespaces.put(prefix, namespaceURI);
        } else {
            this.namespaces.remove(prefix);
        }
    }

    @Override
    public String getNamespace(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return this.namespaces.get(prefix);
    }

    @Override
    public String removeNamespace(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return this.namespaces.remove(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            return null;
        }
        for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
            String prefix = entry.getKey();
            String assocNamespaceURI = entry.getValue();
            if (!namespaceURI.equals(assocNamespaceURI)) continue;
            return prefix;
        }
        return null;
    }

    @Override
    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public void setTypes(Types types) {
        this.types = types;
    }

    @Override
    public Types getTypes() {
        return this.types;
    }

    @Override
    public void addImport(Import importDef) {
        String namespaceURI = importDef.getNamespaceURI();
        List importList = this.imports.computeIfAbsent(namespaceURI, key -> new ArrayList());
        importList.add(importDef);
    }

    @Override
    public Import removeImport(Import importDef) {
        String namespaceURI = importDef.getNamespaceURI();
        List<Import> importList = this.imports.get(namespaceURI);
        Import removed = null;
        if (importList != null && importList.remove(importDef)) {
            removed = importDef;
        }
        return removed;
    }

    @Override
    public List<Import> getImports(String namespaceURI) {
        return this.imports.get(namespaceURI);
    }

    @Override
    public Map<String, List<Import>> getImports() {
        return this.imports;
    }

    @Override
    public void addMessage(Message message) {
        this.messages.put(message.getQName(), message);
    }

    @Override
    public Message getMessage(QName name) {
        Message message = this.messages.get(name);
        if (message == null && name != null) {
            message = (Message)this.getFromImports("message", name);
        }
        return message;
    }

    @Override
    public Message removeMessage(QName name) {
        return this.messages.remove(name);
    }

    @Override
    public Map<QName, Message> getMessages() {
        return this.messages;
    }

    @Override
    public void addBinding(Binding binding) {
        this.bindings.put(binding.getQName(), binding);
    }

    @Override
    public Binding getBinding(QName name) {
        Binding binding = this.bindings.get(name);
        if (binding == null && name != null) {
            binding = (Binding)this.getFromImports("binding", name);
        }
        return binding;
    }

    @Override
    public Binding removeBinding(QName name) {
        return this.bindings.remove(name);
    }

    @Override
    public Map<QName, Binding> getBindings() {
        return this.bindings;
    }

    @Override
    public void addPortType(PortType portType) {
        this.portTypes.put(portType.getQName(), portType);
    }

    @Override
    public PortType getPortType(QName name) {
        PortType portType = this.portTypes.get(name);
        if (portType == null && name != null) {
            portType = (PortType)this.getFromImports("portType", name);
        }
        return portType;
    }

    @Override
    public PortType removePortType(QName name) {
        return this.portTypes.remove(name);
    }

    @Override
    public Map<QName, PortType> getPortTypes() {
        return this.portTypes;
    }

    @Override
    public void addService(Service service) {
        this.services.put(service.getQName(), service);
    }

    @Override
    public Service getService(QName name) {
        Service service = this.services.get(name);
        if (service == null && name != null) {
            service = (Service)this.getFromImports("service", name);
        }
        return service;
    }

    @Override
    public Service removeService(QName name) {
        return this.services.remove(name);
    }

    @Override
    public Map<QName, Service> getServices() {
        return this.services;
    }

    @Override
    public Binding createBinding() {
        return new BindingImpl();
    }

    @Override
    public BindingFault createBindingFault() {
        return new BindingFaultImpl();
    }

    @Override
    public BindingInput createBindingInput() {
        return new BindingInputImpl();
    }

    @Override
    public BindingOperation createBindingOperation() {
        return new BindingOperationImpl();
    }

    @Override
    public BindingOutput createBindingOutput() {
        return new BindingOutputImpl();
    }

    @Override
    public Fault createFault() {
        return new FaultImpl();
    }

    @Override
    public Import createImport() {
        return new ImportImpl();
    }

    @Override
    public Input createInput() {
        return new InputImpl();
    }

    @Override
    public Message createMessage() {
        return new MessageImpl();
    }

    @Override
    public Operation createOperation() {
        return new OperationImpl();
    }

    @Override
    public Output createOutput() {
        return new OutputImpl();
    }

    @Override
    public Part createPart() {
        return new PartImpl();
    }

    @Override
    public Port createPort() {
        return new PortImpl();
    }

    @Override
    public PortType createPortType() {
        return new PortTypeImpl();
    }

    @Override
    public Service createService() {
        return new ServiceImpl();
    }

    @Override
    public Types createTypes() {
        return new TypesImpl();
    }

    @Override
    public void setExtensionRegistry(ExtensionRegistry extReg) {
        this.extReg = extReg;
    }

    @Override
    public ExtensionRegistry getExtensionRegistry() {
        return this.extReg;
    }

    private WSDLElement getFromImports(String typeOfDefinition, QName name) {
        WSDLElement ret = null;
        List<Import> importList = this.getImports(name.getNamespaceURI());
        if (importList == null) {
            return null;
        }
        for (Import importDef : importList) {
            Definition importedDef = importDef.getDefinition();
            if (importedDef == null) continue;
            switch (typeOfDefinition) {
                case "service": {
                    ret = importedDef.getService(name);
                    break;
                }
                case "message": {
                    ret = importedDef.getMessage(name);
                    break;
                }
                case "binding": {
                    ret = importedDef.getBinding(name);
                    break;
                }
                case "portType": {
                    ret = importedDef.getPortType(name);
                    break;
                }
            }
            if (ret == null) continue;
            return ret;
        }
        return ret;
    }

    private <T extends WSDLElement> void appendElementToStringBuilder(Map<?, T> element, StringBuilder sb) {
        if (element != null) {
            Iterator<T> importIterator = element.values().iterator();
            while (importIterator.hasNext()) {
                sb.append("\n" + importIterator.next());
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder strBuf = new StringBuilder();
        strBuf.append("Definition: name=" + this.name + " targetNamespace=" + this.targetNamespace);
        if (this.imports != null) {
            Iterator<List<Import>> importIterator = this.imports.values().iterator();
            while (importIterator.hasNext()) {
                strBuf.append("\n" + importIterator.next());
            }
        }
        if (this.types != null) {
            strBuf.append("\n" + this.types);
        }
        this.appendElementToStringBuilder(this.messages, strBuf);
        this.appendElementToStringBuilder(this.portTypes, strBuf);
        this.appendElementToStringBuilder(this.bindings, strBuf);
        this.appendElementToStringBuilder(this.services, strBuf);
        String superString = super.toString();
        if (!superString.equals("")) {
            strBuf.append("\n");
            strBuf.append(superString);
        }
        return strBuf.toString();
    }

    @Override
    public List<String> getNativeAttributeNames() {
        return this.nativeAttributeNames;
    }

    @Override
    public Map<QName, Binding> getAllBindings() {
        HashMap<QName, Binding> allBindings = new HashMap<QName, Binding>(this.getBindings());
        Map<String, List<Import>> importMap = this.getImports();
        for (List<Import> importDefs : importMap.values()) {
            for (Import importDef : importDefs) {
                Definition importedDef = importDef.getDefinition();
                if (importedDef == null) continue;
                allBindings.putAll(importedDef.getAllBindings());
            }
        }
        return allBindings;
    }

    @Override
    public Map<QName, PortType> getAllPortTypes() {
        HashMap<QName, PortType> allPortTypes = new HashMap<QName, PortType>(this.getPortTypes());
        Map<String, List<Import>> importMap = this.getImports();
        for (List<Import> importDefs : importMap.values()) {
            for (Import importDef : importDefs) {
                Definition importedDef = importDef.getDefinition();
                if (importedDef == null) continue;
                allPortTypes.putAll(importedDef.getAllPortTypes());
            }
        }
        return allPortTypes;
    }

    @Override
    public Map<QName, Service> getAllServices() {
        HashMap<QName, Service> allServices = new HashMap<QName, Service>(this.getServices());
        Map<String, List<Import>> importMap = this.getImports();
        for (List<Import> importDefs : importMap.values()) {
            for (Import importDef : importDefs) {
                Definition importedDef = importDef.getDefinition();
                if (importedDef == null) continue;
                allServices.putAll(importedDef.getAllServices());
            }
        }
        return allServices;
    }
}

