/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.reflection;

import com.google.common.reflect.TypeToken;
import io.github.kbuntrock.utils.Logger;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.plugin.logging.Log;

public final class GenericityResolver {
    private final Log logger = Logger.INSTANCE.getLogger();
    private Map<ResolvingKey, Type> resolvedCache = new HashMap<ResolvingKey, Type>();

    public Type resolve(Class contextClass, Type typeToResolve) {
        Type resolved = this.resolvedCache.computeIfAbsent(new ResolvingKey(contextClass, typeToResolve), k -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((CharSequence)("Computing cache key : " + contextClass.getSimpleName() + " : " + typeToResolve.toString()));
            }
            return TypeToken.of((Class)contextClass).resolveType(typeToResolve).getType();
        });
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((CharSequence)("Returning resolved type for : " + contextClass.getSimpleName() + " : " + typeToResolve.toString() + " -> " + resolved));
        }
        return resolved;
    }

    private static class ResolvingKey {
        private final Class contextClass;
        private final Type typeToResolve;

        public ResolvingKey(Class contextClass, Type typeToResolve) {
            this.contextClass = contextClass;
            this.typeToResolve = typeToResolve;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolvingKey duo = (ResolvingKey)o;
            return Objects.equals(this.contextClass, duo.contextClass) && Objects.equals(this.typeToResolve, duo.typeToResolve);
        }

        public int hashCode() {
            return Objects.hash(this.contextClass, this.typeToResolve);
        }
    }
}

