/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.model;

import io.github.kbuntrock.configuration.ApiConfiguration;
import io.github.kbuntrock.configuration.Substitution;
import io.github.kbuntrock.model.Endpoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class Tag
implements Comparable<Tag> {
    private final List<Endpoint> endpoints = new ArrayList<Endpoint>();
    private String name;
    private final Class<?> clazz;
    private String computedName;

    public Tag(Class<?> clazz) {
        this.name = clazz.getSimpleName();
        this.clazz = clazz;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String computeConfiguredName(ApiConfiguration apiConfiguration) {
        if (this.computedName == null) {
            this.computedName = this.getName();
            for (Substitution substitution : apiConfiguration.getTag().getSubstitutions()) {
                this.computedName = this.computedName.replaceAll(substitution.getRegex(), substitution.getSubstitute());
            }
        }
        return this.computedName;
    }

    public Collection<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public Collection<Endpoint> getSortedEndpoints() {
        return this.endpoints.stream().sorted().collect(Collectors.toList());
    }

    public void addEndpoint(Endpoint endpoint) {
        this.endpoints.add(endpoint);
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String toString() {
        return "Tag{name='" + this.name + '\'' + ", endpoints=" + this.endpoints.stream().map(Object::toString).collect(Collectors.joining(", ")) + '}';
    }

    @Override
    public int compareTo(Tag o) {
        return Comparator.comparing(t -> t.computedName, Comparator.nullsLast(String::compareTo)).thenComparing(t -> t.name, Comparator.nullsLast(String::compareTo)).thenComparing(t -> t.clazz.getCanonicalName()).compare(this, o);
    }
}

