/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.configuration.parser;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.github.kbuntrock.MojoRuntimeException;
import java.util.Iterator;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public final class JsonParserUtils {
    public static final ObjectMapper jsonObjectMapper = new ObjectMapper();
    public static final String PRETTY_PRINT_LINE_BREAK = "\n";

    private JsonParserUtils() {
    }

    public static Optional<JsonNode> parse(String jsonContent) {
        if (StringUtils.isEmpty((CharSequence)jsonContent)) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(jsonObjectMapper.readTree(jsonContent));
        }
        catch (JsonProcessingException e) {
            throw new MojoRuntimeException("json content cannot be parsed", e);
        }
    }

    public static String merge(String baseJson, String updateJson) {
        try {
            JsonNode mutatedNode = jsonObjectMapper.readTree(baseJson);
            JsonNode updateNode = jsonObjectMapper.readTree(updateJson);
            JsonParserUtils.mergeInternal(mutatedNode, updateNode);
            return jsonObjectMapper.writer((PrettyPrinter)new DefaultPrettyPrinter().withObjectIndenter((DefaultPrettyPrinter.Indenter)new DefaultIndenter().withLinefeed(PRETTY_PRINT_LINE_BREAK))).writeValueAsString((Object)mutatedNode);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Cannot parse freefields entries", e);
        }
    }

    public static void mergeInternal(JsonNode mutatedNode, JsonNode updateNode) {
        Iterator fieldNames = updateNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode jsonNode = mutatedNode.get(fieldName);
            if (jsonNode != null && jsonNode.isObject()) {
                JsonParserUtils.mergeInternal(jsonNode, updateNode.get(fieldName));
                continue;
            }
            if (!(mutatedNode instanceof ObjectNode)) continue;
            JsonNode value = updateNode.get(fieldName);
            ((ObjectNode)mutatedNode).put(fieldName, value);
        }
    }
}

