/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OperationIdHelper {
    private static final Map<String, TokenType> idToTokenType = new HashMap<String, TokenType>();
    private static final String REGEX = "(\\{)(.*?)(})";
    private static final Pattern pattern = Pattern.compile("(\\{)(.*?)(})");
    private final List<Token> tokens = new ArrayList<Token>();

    public OperationIdHelper(String configuration) {
        Matcher matcher = pattern.matcher(configuration);
        ArrayList<TokenType> contenu = new ArrayList<TokenType>();
        while (matcher.find()) {
            TokenType tokenType = idToTokenType.get(matcher.group(2));
            if (tokenType != null) {
                contenu.add(tokenType);
                continue;
            }
            throw new RuntimeException("Token type \"" + matcher.group(2) + "\" does not exist.");
        }
        String[] splitted = configuration.split(REGEX);
        for (int index = 0; index < splitted.length; ++index) {
            if (!splitted[index].isEmpty()) {
                this.tokens.add(new Token(TokenType.STRING, splitted[index]));
            }
            if (index >= contenu.size()) continue;
            this.tokens.add(new Token((TokenType)((Object)contenu.get(index))));
        }
        if (splitted.length == 0) {
            for (TokenType c : contenu) {
                this.tokens.add(new Token(c));
            }
        }
    }

    public String toOperationId(String className, String tagName, String methodName) {
        StringBuilder sb = new StringBuilder();
        for (Token token : this.tokens) {
            switch (token.type) {
                case STRING: {
                    sb.append(token.value);
                    break;
                }
                case TAG_NAME: {
                    sb.append(tagName);
                    break;
                }
                case METHOD_NAME: {
                    sb.append(methodName);
                    break;
                }
                case CLASS_NAME: {
                    sb.append(className);
                }
            }
        }
        return sb.toString();
    }

    static {
        for (TokenType type : TokenType.values()) {
            idToTokenType.put(type.id, type);
        }
    }

    private static enum TokenType {
        STRING(null),
        CLASS_NAME("class_name"),
        METHOD_NAME("method_name"),
        TAG_NAME("tag_name");

        private final String id;

        private TokenType(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    private class Token {
        TokenType type;
        String value;

        public Token(TokenType type) {
            this.type = type;
        }

        public Token(TokenType type, String value) {
            this.type = type;
            this.value = value;
        }

        public TokenType getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }
    }
}

