/*
 * Decompiled with CFR 0.152.
 */
package io.github.jopenlibs.vault.api.sys;

import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.api.OperationsBase;
import io.github.jopenlibs.vault.json.Json;
import io.github.jopenlibs.vault.response.SealResponse;
import io.github.jopenlibs.vault.rest.Rest;
import io.github.jopenlibs.vault.rest.RestResponse;
import java.nio.charset.StandardCharsets;

public class Seal
extends OperationsBase {
    private String nameSpace;

    public Seal(VaultConfig config) {
        super(config);
        if (this.config.getNameSpace() != null && !this.config.getNameSpace().isEmpty()) {
            this.nameSpace = this.config.getNameSpace();
        }
    }

    public Seal withNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
        return this;
    }

    public SealResponse seal() throws VaultException {
        return this.retry(attempt -> {
            RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/sys/seal").header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
            return this.getSealResponse(attempt, restResponse, 204);
        });
    }

    public SealResponse unseal(String key) throws VaultException {
        return this.unseal(key, false);
    }

    public SealResponse unseal(String key, Boolean reset) throws VaultException {
        return this.retry(attempt -> {
            String requestJson = Json.object().add("key", key).add("reset", reset).toString();
            RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/sys/unseal").header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
            return this.getSealResponse(attempt, restResponse, 200);
        });
    }

    public SealResponse sealStatus() throws VaultException {
        return this.retry(attempt -> {
            RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/sys/seal-status").header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).get();
            return this.getSealResponse(attempt, restResponse, 200);
        });
    }

    private SealResponse getSealResponse(int retryCount, RestResponse restResponse, int expectedResponse) throws VaultException {
        if (restResponse.getStatus() != expectedResponse) {
            throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
        }
        String mimeType = String.valueOf(restResponse.getMimeType());
        if (!mimeType.equals("application/json")) {
            throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
        }
        return new SealResponse(restResponse, retryCount);
    }
}

