/*
 * Decompiled with CFR 0.152.
 */
package io.github.jopenlibs.vault.api;

import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.api.LogicalUtilities;
import io.github.jopenlibs.vault.api.OperationsBase;
import io.github.jopenlibs.vault.api.WriteOptions;
import io.github.jopenlibs.vault.json.Json;
import io.github.jopenlibs.vault.json.JsonObject;
import io.github.jopenlibs.vault.json.JsonValue;
import io.github.jopenlibs.vault.response.LogicalResponse;
import io.github.jopenlibs.vault.rest.RestResponse;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;

public class Logical
extends OperationsBase {
    private static final WriteOptions DEFAULT_WRITE_OPTIONS = new WriteOptions().build();
    private String nameSpace;

    public Logical(VaultConfig config) {
        super(config);
        if (this.config.getNameSpace() != null && !this.config.getNameSpace().isEmpty()) {
            this.nameSpace = this.config.getNameSpace();
        }
    }

    public Logical withNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
        return this;
    }

    public LogicalResponse read(String path) throws VaultException {
        if (this.engineVersionForSecretPath(path).equals(2)) {
            return this.read(path, logicalOperations.readV2);
        }
        return this.read(path, logicalOperations.readV1);
    }

    private LogicalResponse read(String path, logicalOperations operation) throws VaultException {
        return this.retry(attempt -> {
            RestResponse restResponse = this.getRest().url(this.config.getAddress() + "/v1/" + LogicalUtilities.adjustPathForReadOrWrite(path, this.config.getPrefixPathDepth(), operation)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).get();
            if (restResponse.getStatus() != 200 && (restResponse.getStatus() < 400 || restResponse.getStatus() >= 500)) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
            }
            return new LogicalResponse(restResponse, attempt, operation);
        });
    }

    public LogicalResponse read(String path, Boolean shouldRetry, Integer version) throws VaultException {
        if (this.engineVersionForSecretPath(path) != 2) {
            throw new VaultException("Version reads are only supported in KV Engine version 2.");
        }
        return OperationsBase.retry(attempt -> {
            RestResponse restResponse = this.getRest().url(this.config.getAddress() + "/v1/" + LogicalUtilities.adjustPathForReadOrWrite(path, this.config.getPrefixPathDepth(), logicalOperations.readV2)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").parameter("version", version.toString()).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).get();
            if (restResponse.getStatus() != 200 && (restResponse.getStatus() < 400 || restResponse.getStatus() >= 500)) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
            }
            return new LogicalResponse(restResponse, attempt, logicalOperations.readV2);
        }, shouldRetry != false ? this.config.getMaxRetries() : 1, this.config.getRetryIntervalMilliseconds());
    }

    public LogicalResponse write(String path, Map<String, Object> nameValuePairs) throws VaultException {
        if (this.engineVersionForSecretPath(path).equals(2)) {
            return this.write(path, nameValuePairs, logicalOperations.writeV2, null, DEFAULT_WRITE_OPTIONS);
        }
        return this.write(path, nameValuePairs, logicalOperations.writeV1, null, DEFAULT_WRITE_OPTIONS);
    }

    public LogicalResponse write(String path, Map<String, Object> nameValuePairs, Integer wrapTTL) throws VaultException {
        if (this.engineVersionForSecretPath(path).equals(2)) {
            return this.write(path, nameValuePairs, logicalOperations.writeV2, wrapTTL, DEFAULT_WRITE_OPTIONS);
        }
        return this.write(path, nameValuePairs, logicalOperations.writeV1, wrapTTL, DEFAULT_WRITE_OPTIONS);
    }

    public LogicalResponse write(String path, Map<String, Object> nameValuePairs, Integer wrapTTL, WriteOptions writeOptions) throws VaultException {
        if (!this.engineVersionForSecretPath(path).equals(2)) {
            throw new VaultException("Write options are only supported in KV Engine version 2.");
        }
        return this.write(path, nameValuePairs, logicalOperations.writeV2, wrapTTL, writeOptions);
    }

    private LogicalResponse write(String path, Map<String, Object> nameValuePairs, logicalOperations operation, Integer wrapTTL, WriteOptions writeOptions) throws VaultException {
        return this.retry(attempt -> {
            JsonObject dataJson = this.buildJsonFromMap(nameValuePairs);
            JsonObject optionsJson = this.buildJsonFromMap(writeOptions.getOptionsMap());
            RestResponse restResponse = this.getRest().url(this.config.getAddress() + "/v1/" + LogicalUtilities.adjustPathForReadOrWrite(path, this.config.getPrefixPathDepth(), operation)).body(LogicalUtilities.jsonObjectToWriteFromEngineVersion(operation, dataJson, optionsJson).toString().getBytes(StandardCharsets.UTF_8)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").header("X-Vault-Wrap-TTL", wrapTTL != null ? wrapTTL.toString() : null).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
            int restStatus = restResponse.getStatus();
            if (restStatus == 200 || restStatus == 204 || restResponse.getStatus() >= 400 && restResponse.getStatus() < 500) {
                return new LogicalResponse(restResponse, attempt, operation);
            }
            throw new VaultException("Expecting HTTP status 204 or 200, but instead receiving " + restStatus + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restStatus);
        });
    }

    public LogicalResponse list(String path) throws VaultException {
        if (this.engineVersionForSecretPath(path).equals(2)) {
            return this.list(path, logicalOperations.listV2);
        }
        return this.list(path, logicalOperations.listV1);
    }

    private LogicalResponse list(String path, logicalOperations operation) throws VaultException {
        LogicalResponse response;
        block2: {
            response = null;
            try {
                response = this.read(LogicalUtilities.adjustPathForList(path, this.config.getPrefixPathDepth(), operation), operation);
            }
            catch (VaultException e) {
                if (e.getHttpStatusCode() == 404) break block2;
                throw e;
            }
        }
        return response;
    }

    public LogicalResponse delete(String path) throws VaultException {
        if (this.engineVersionForSecretPath(path).equals(2)) {
            return this.delete(path, logicalOperations.deleteV2);
        }
        return this.delete(path, logicalOperations.deleteV1);
    }

    private LogicalResponse delete(String path, logicalOperations operation) throws VaultException {
        return this.retry(attempt -> {
            RestResponse restResponse = this.getRest().url(this.config.getAddress() + "/v1/" + LogicalUtilities.adjustPathForDelete(path, this.config.getPrefixPathDepth(), operation)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).delete();
            if (restResponse.getStatus() != 204) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
            }
            return new LogicalResponse(restResponse, attempt, operation);
        });
    }

    public LogicalResponse delete(String path, int[] versions) throws VaultException {
        if (this.engineVersionForSecretPath(path) != 2) {
            throw new VaultException("Version deletes are only supported for KV Engine 2.");
        }
        this.intArrayCheck(versions);
        return this.retry(attempt -> {
            JsonObject versionsToDelete = new JsonObject().add("versions", versions);
            RestResponse restResponse = this.getRest().url(this.config.getAddress() + "/v1/" + LogicalUtilities.adjustPathForVersionDelete(path, this.config.getPrefixPathDepth())).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).body(versionsToDelete.toString().getBytes(StandardCharsets.UTF_8)).post();
            return this.getLogicalResponse(attempt, restResponse);
        });
    }

    private LogicalResponse getLogicalResponse(int retryCount, RestResponse restResponse) throws VaultException {
        if (restResponse.getStatus() != 204) {
            throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
        }
        return new LogicalResponse(restResponse, retryCount, logicalOperations.deleteV2);
    }

    private void intArrayCheck(int[] versions) {
        for (int i : versions) {
            if (i >= 1) continue;
            throw new IllegalArgumentException("The document version must be 1 or greater.");
        }
        Arrays.sort(versions);
    }

    public LogicalResponse unDelete(String path, int[] versions) throws VaultException {
        if (this.engineVersionForSecretPath(path) != 2) {
            throw new VaultException("Version undeletes are only supported for KV Engine 2.");
        }
        this.intArrayCheck(versions);
        return this.retry(attempt -> {
            JsonObject versionsToUnDelete = new JsonObject().add("versions", versions);
            RestResponse restResponse = this.getRest().url(this.config.getAddress() + "/v1/" + LogicalUtilities.adjustPathForVersionUnDelete(path, this.config.getPrefixPathDepth())).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).body(versionsToUnDelete.toString().getBytes(StandardCharsets.UTF_8)).post();
            if (restResponse.getStatus() != 204) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
            }
            return new LogicalResponse(restResponse, attempt, logicalOperations.unDelete);
        });
    }

    public LogicalResponse destroy(String path, int[] versions) throws VaultException {
        if (this.engineVersionForSecretPath(path) != 2) {
            throw new VaultException("Secret destroys are only supported for KV Engine 2.");
        }
        this.intArrayCheck(versions);
        return this.retry(attempt -> {
            JsonObject versionsToDestroy = new JsonObject().add("versions", versions);
            RestResponse restResponse = this.getRest().url(this.config.getAddress() + "/v1/" + LogicalUtilities.adjustPathForVersionDestroy(path, this.config.getPrefixPathDepth())).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).body(versionsToDestroy.toString().getBytes(StandardCharsets.UTF_8)).post();
            return this.getLogicalResponse(attempt, restResponse);
        });
    }

    public LogicalResponse upgrade(String kvPath) throws VaultException {
        if (this.engineVersionForSecretPath(kvPath) == 2) {
            throw new VaultException("This KV engine is already version 2.");
        }
        return this.retry(attempt -> {
            JsonObject kvToUpgrade = new JsonObject().add("options", new JsonObject().add("version", 2));
            RestResponse restResponse = this.getRest().url(this.config.getAddress() + "/v1/sys/mounts/" + kvPath.replaceAll("/", "") + "/tune").header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).body(kvToUpgrade.toString().getBytes(StandardCharsets.UTF_8)).post();
            if (restResponse.getStatus() != 200) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
            }
            return new LogicalResponse(restResponse, attempt, logicalOperations.authentication);
        });
    }

    private Integer engineVersionForSecretPath(String secretPath) {
        if (!this.config.getSecretsEnginePathMap().isEmpty()) {
            return this.config.getSecretsEnginePathMap().containsKey(secretPath + "/") ? Integer.valueOf(this.config.getSecretsEnginePathMap().get(secretPath + "/")) : this.config.getGlobalEngineVersion();
        }
        return this.config.getGlobalEngineVersion();
    }

    public Integer getEngineVersionForSecretPath(String path) {
        return this.engineVersionForSecretPath(path);
    }

    private JsonObject buildJsonFromMap(Map<String, Object> nameValuePairs) {
        JsonObject jsonObject = Json.object();
        if (nameValuePairs != null) {
            for (Map.Entry<String, Object> pair : nameValuePairs.entrySet()) {
                Object value = pair.getValue();
                if (value == null) {
                    jsonObject = jsonObject.add(pair.getKey(), (String)null);
                    continue;
                }
                if (value instanceof Boolean) {
                    jsonObject = jsonObject.add(pair.getKey(), (Boolean)pair.getValue());
                    continue;
                }
                if (value instanceof Integer) {
                    jsonObject = jsonObject.add(pair.getKey(), (Integer)pair.getValue());
                    continue;
                }
                if (value instanceof Long) {
                    jsonObject = jsonObject.add(pair.getKey(), (Long)pair.getValue());
                    continue;
                }
                if (value instanceof Float) {
                    jsonObject = jsonObject.add(pair.getKey(), ((Float)pair.getValue()).floatValue());
                    continue;
                }
                if (value instanceof Double) {
                    jsonObject = jsonObject.add(pair.getKey(), (Double)pair.getValue());
                    continue;
                }
                if (value instanceof JsonValue) {
                    jsonObject = jsonObject.add(pair.getKey(), (JsonValue)pair.getValue());
                    continue;
                }
                jsonObject = jsonObject.add(pair.getKey(), pair.getValue().toString());
            }
        }
        return jsonObject;
    }

    public static enum logicalOperations {
        authentication,
        deleteV1,
        deleteV2,
        destroy,
        listV1,
        listV2,
        readV1,
        readV2,
        writeV1,
        writeV2,
        unDelete,
        mount;

    }
}

