/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.nvd;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.jeremylong.openvulnerability.client.nvd.CpeMatch;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"operator", "negate", "cpeMatch"})
@NullMarked
public class Node
implements Serializable {
    private static final long serialVersionUID = 3573822908057141798L;
    @JsonProperty(value="operator")
    private Operator operator;
    @JsonProperty(value="negate")
    private @Nullable Boolean negate;
    @JsonProperty(value="cpeMatch")
    private List<CpeMatch> cpeMatch;

    @JsonCreator
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="I prefer to suppress these FindBugs warnings")
    public Node(@JsonProperty(value="operator") Operator operator, @JsonProperty(value="cpeMatch") List<CpeMatch> cpeMatch) {
        this.operator = operator;
        this.cpeMatch = cpeMatch;
    }

    public Node(Operator operator, @Nullable Boolean negate, List<CpeMatch> cpeMatch) {
        this(operator, cpeMatch);
        this.negate = negate;
    }

    @JsonProperty(value="operator")
    public Operator getOperator() {
        return this.operator;
    }

    @JsonProperty(value="negate")
    public @Nullable Boolean getNegate() {
        return this.negate;
    }

    @JsonProperty(value="cpeMatch")
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="I prefer to suppress these FindBugs warnings")
    public List<CpeMatch> getCpeMatch() {
        return this.cpeMatch;
    }

    public String toString() {
        return "Node{operator=" + String.valueOf((Object)this.operator) + ", negate=" + this.negate + ", cpeMatch=" + String.valueOf(this.cpeMatch) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return this.operator == node.operator && Objects.equals(this.negate, node.negate) && Objects.equals(this.cpeMatch, node.cpeMatch);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.negate, this.cpeMatch});
    }

    public static enum Operator {
        AND("AND"),
        OR("OR");

        private static final Map<String, Operator> CONSTANTS;
        private final String value;

        private Operator(String value) {
            this.value = value;
        }

        @JsonCreator
        public static Operator fromValue(String value) {
            Operator constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, Operator>();
            for (Operator c : Operator.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

