/*
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 * Copyright (c) 2023-2025 Jeremy Long. All Rights Reserved.
 */
package io.github.jeremylong.openvulnerability.client.kev;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

import java.io.Serializable;
import java.util.Date;

/**
 * Known Exploited Vulnerability.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonPropertyOrder({"cveID", "vendorProject", "product", "vulnerabilityName", "dateAdded", "shortDescription",
        "requiredAction", "dueDate", "notes"})
public class KevItem implements Serializable {

    /**
     * Serialization version UID.
     */
    private static final long serialVersionUID = -7179717694761725798L;
    @JsonProperty("cveID")
    private String cveID;
    @JsonProperty("vendorProject")
    private String vendorProject;
    @JsonProperty("product")
    private String product;
    @JsonProperty("vulnerabilityName")
    private String vulnerabilityName;
    @JsonProperty("dateAdded")
    @JsonFormat(pattern = "uuuu-MM-dd")
    private Date dateAdded;
    @JsonProperty("shortDescription")
    private String shortDescription;
    @JsonProperty("requiredAction")
    private String requiredAction;
    @JsonProperty("dueDate")
    @JsonFormat(pattern = "uuuu-MM-dd")
    private Date dueDate;
    @JsonProperty("notes")
    private String notes;

    public String getCveID() {
        return cveID;
    }

    public String getVendorProject() {
        return vendorProject;
    }

    public String getProduct() {
        return product;
    }

    public String getVulnerabilityName() {
        return vulnerabilityName;
    }

    @SuppressFBWarnings(value = {"EI_EXPOSE_REP",
            "EI_EXPOSE_REP2"}, justification = "I prefer to suppress these FindBugs warnings")
    public Date getDateAdded() {
        return dateAdded;
    }

    public String getShortDescription() {
        return shortDescription;
    }

    public String getRequiredAction() {
        return requiredAction;
    }

    @SuppressFBWarnings(value = {"EI_EXPOSE_REP",
            "EI_EXPOSE_REP2"}, justification = "I prefer to suppress these FindBugs warnings")
    public Date getDueDate() {
        return dueDate;
    }

    public String getNotes() {
        return notes;
    }
}
