/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.jcs3.slf4j;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.jcs3.log.Log;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class Slf4jAdapter
implements Log {
    private final Logger logger;
    private final boolean muted;

    public Slf4jAdapter(Logger log) {
        this.logger = log;
        this.muted = Boolean.getBoolean(System.getProperty("jcs.logSystem.mute", "false"));
    }

    public void debug(String string) {
        if (!this.muted) {
            this.logger.debug(string);
        }
    }

    public void debug(Object o) {
        if (!this.muted) {
            this.logger.debug(o.toString());
        }
    }

    public void debug(String string, Object ... os) {
        if (!this.muted) {
            String msg = MessageFormat.format(string, os);
            this.logger.debug(msg);
        }
    }

    public void debug(String string, Supplier<?> ... splrs) {
        if (!this.muted) {
            List args = Arrays.stream(splrs).map(it -> it.get().toString()).collect(Collectors.toList());
            String msg = MessageFormat.format(string, args.toArray());
            this.logger.debug(msg);
        }
    }

    public void debug(String string, Throwable thrwbl) {
        if (!this.muted) {
            this.logger.debug(string, thrwbl);
        }
    }

    public void error(String string) {
        if (!this.muted) {
            this.logger.error(string);
        }
    }

    public void error(Object o) {
        if (!this.muted) {
            this.logger.error(o.toString());
        }
    }

    public void error(String string, Object ... os) {
        if (!this.muted) {
            String msg = MessageFormat.format(string, os);
            this.logger.error(msg);
        }
    }

    public void error(String string, Supplier<?> ... splrs) {
        if (!this.muted) {
            List args = Arrays.stream(splrs).map(it -> it.get().toString()).collect(Collectors.toList());
            String msg = MessageFormat.format(string, args.toArray());
            this.logger.error(msg);
        }
    }

    public void error(String string, Throwable thrwbl) {
        if (!this.muted) {
            this.logger.error(string, thrwbl);
        }
    }

    public void fatal(String string) {
        if (!this.muted) {
            this.logger.error(string);
        }
    }

    public void fatal(Object o) {
        if (!this.muted) {
            this.logger.error(o.toString());
        }
    }

    public void fatal(String string, Object ... os) {
        if (!this.muted) {
            String msg = MessageFormat.format(string, os);
            this.logger.error(msg);
        }
    }

    public void fatal(String string, Supplier<?> ... splrs) {
        if (!this.muted) {
            List args = Arrays.stream(splrs).map(it -> it.get().toString()).collect(Collectors.toList());
            String msg = MessageFormat.format(string, args.toArray());
            this.logger.error(msg);
        }
    }

    public void fatal(String string, Throwable thrwbl) {
        if (!this.muted) {
            this.logger.error(string, thrwbl);
        }
    }

    public String getName() {
        return this.logger.getName();
    }

    public void info(String string) {
        if (!this.muted) {
            this.logger.info(string);
        }
    }

    public void info(Object o) {
        if (!this.muted) {
            this.logger.info(o.toString());
        }
    }

    public void info(String string, Object ... os) {
        if (!this.muted) {
            String msg = MessageFormat.format(string, os);
            this.logger.info(msg);
        }
    }

    public void info(String string, Supplier<?> ... splrs) {
        if (!this.muted) {
            List args = Arrays.stream(splrs).map(it -> it.get().toString()).collect(Collectors.toList());
            String msg = MessageFormat.format(string, args.toArray());
            this.logger.info(msg);
        }
    }

    public void info(String string, Throwable thrwbl) {
        if (!this.muted) {
            this.logger.info(string, thrwbl);
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void trace(String string) {
        if (!this.muted) {
            this.logger.trace(string);
        }
    }

    public void trace(Object o) {
        if (!this.muted) {
            this.logger.trace(o.toString());
        }
    }

    public void trace(String string, Object ... os) {
        if (!this.muted) {
            String msg = MessageFormat.format(string, os);
            this.logger.trace(msg);
        }
    }

    public void trace(String string, Supplier<?> ... splrs) {
        if (!this.muted) {
            List args = Arrays.stream(splrs).map(it -> it.get().toString()).collect(Collectors.toList());
            String msg = MessageFormat.format(string, args.toArray());
            this.logger.trace(msg);
        }
    }

    public void trace(String string, Throwable thrwbl) {
        if (!this.muted) {
            this.logger.trace(string, thrwbl);
        }
    }

    public void warn(String string) {
        if (!this.muted) {
            this.logger.warn(string);
        }
    }

    public void warn(Object o) {
        if (!this.muted) {
            this.logger.warn(o.toString());
        }
    }

    public void warn(String string, Object ... os) {
        if (!this.muted) {
            String msg = MessageFormat.format(string, os);
            this.logger.warn(msg);
        }
    }

    public void warn(String string, Supplier<?> ... splrs) {
        if (!this.muted) {
            List args = Arrays.stream(splrs).map(it -> it.get().toString()).collect(Collectors.toList());
            String msg = MessageFormat.format(string, args.toArray());
            this.logger.warn(msg);
        }
    }

    public void warn(String string, Throwable thrwbl) {
        if (!this.muted) {
            this.logger.warn(string, thrwbl);
        }
    }

    private void log(Level level, String string, Supplier<?>[] splrs) {
        if (!this.muted && this.isEnabled(level)) {
            Object[] o = null;
            if (splrs != null) {
                o = Arrays.stream(splrs).map(s -> s.get()).toArray();
            }
            switch (level) {
                case ERROR: {
                    this.logger.error(string, o);
                    break;
                }
                case WARN: {
                    this.logger.warn(string, o);
                    break;
                }
                case INFO: {
                    this.logger.info(string, o);
                    break;
                }
                case TRACE: {
                    this.logger.trace(string, o);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(string, o);
                }
            }
        }
    }

    private boolean isEnabled(Level level) {
        return Level.DEBUG == level && this.logger.isDebugEnabled() || Level.INFO == level && this.logger.isInfoEnabled() || Level.TRACE == level && this.logger.isTraceEnabled() || Level.WARN == level && this.logger.isWarnEnabled() || Level.ERROR == level && this.logger.isErrorEnabled();
    }
}

