/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk.feature;

import io.github.jbellis.jvector.disk.IndexWriter;
import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.graph.disk.CommonHeader;
import io.github.jbellis.jvector.graph.disk.feature.AbstractFeature;
import io.github.jbellis.jvector.graph.disk.feature.Feature;
import io.github.jbellis.jvector.graph.disk.feature.FeatureId;
import io.github.jbellis.jvector.vector.VectorizationProvider;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import io.github.jbellis.jvector.vector.types.VectorTypeSupport;
import java.io.IOException;

public class InlineVectors
extends AbstractFeature {
    private static final VectorTypeSupport vectorTypeSupport = VectorizationProvider.getInstance().getVectorTypeSupport();
    private final int dimension;

    public InlineVectors(int dimension) {
        this.dimension = dimension;
    }

    @Override
    public FeatureId id() {
        return FeatureId.INLINE_VECTORS;
    }

    @Override
    public int headerSize() {
        return 0;
    }

    @Override
    public int featureSize() {
        return this.dimension * 4;
    }

    public int dimension() {
        return this.dimension;
    }

    static InlineVectors load(CommonHeader header, RandomAccessReader reader) {
        return new InlineVectors(header.dimension);
    }

    @Override
    public void writeHeader(IndexWriter out) {
    }

    @Override
    public void writeInline(IndexWriter out, Feature.State state) throws IOException {
        vectorTypeSupport.writeFloatVector(out, ((State)state).vector);
    }

    public static class State
    implements Feature.State {
        public final VectorFloat<?> vector;

        public State(VectorFloat<?> vector) {
            this.vector = vector;
        }
    }
}

