/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.disk.BufferedRandomAccessWriter;
import io.github.jbellis.jvector.disk.RandomAccessWriter;
import io.github.jbellis.jvector.graph.ImmutableGraphIndex;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.graph.disk.AbstractGraphIndexWriter;
import io.github.jbellis.jvector.graph.disk.OrdinalMapper;
import io.github.jbellis.jvector.graph.disk.RandomAccessOnDiskGraphIndexWriter;
import io.github.jbellis.jvector.graph.disk.feature.Feature;
import io.github.jbellis.jvector.graph.disk.feature.FeatureId;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.IntFunction;

public class OnDiskGraphIndexWriter
extends RandomAccessOnDiskGraphIndexWriter {
    OnDiskGraphIndexWriter(RandomAccessWriter randomAccessWriter, int version, long startOffset, ImmutableGraphIndex graph, OrdinalMapper oldToNewOrdinals, int dimension, EnumMap<FeatureId, Feature> features) {
        super(randomAccessWriter, version, startOffset, graph, oldToNewOrdinals, dimension, features);
    }

    @Override
    protected void writeL0Records(ImmutableGraphIndex.View view, Map<FeatureId, IntFunction<Feature.State>> featureStateSuppliers) throws IOException {
        for (int newOrdinal = 0; newOrdinal <= this.ordinalMapper.maxOrdinal(); ++newOrdinal) {
            int n;
            int originalOrdinal = this.ordinalMapper.newToOld(newOrdinal);
            if (originalOrdinal == Integer.MIN_VALUE) {
                ((RandomAccessWriter)this.out).writeInt(-1);
                for (Feature feature : this.inlineFeatures) {
                    ((RandomAccessWriter)this.out).seek(((RandomAccessWriter)this.out).position() + (long)feature.featureSize());
                }
                ((RandomAccessWriter)this.out).writeInt(0);
                for (int n2 = 0; n2 < this.graph.getDegree(0); ++n2) {
                    ((RandomAccessWriter)this.out).writeInt(-1);
                }
                continue;
            }
            if (!this.graph.containsNode(originalOrdinal)) {
                String msg = String.format("Ordinal mapper mapped new ordinal %s to non-existing node %s", newOrdinal, originalOrdinal);
                throw new IllegalStateException(msg);
            }
            ((RandomAccessWriter)this.out).writeInt(newOrdinal);
            assert (((RandomAccessWriter)this.out).position() == this.featureOffsetForOrdinal(newOrdinal)) : String.format("%d != %d", ((RandomAccessWriter)this.out).position(), this.featureOffsetForOrdinal(newOrdinal));
            for (Feature feature : this.inlineFeatures) {
                IntFunction<Feature.State> supplier = featureStateSuppliers.get((Object)feature.id());
                if (supplier == null) {
                    ((RandomAccessWriter)this.out).seek(((RandomAccessWriter)this.out).position() + (long)feature.featureSize());
                    continue;
                }
                feature.writeInline(this.out, supplier.apply(originalOrdinal));
            }
            NodesIterator neighbors = view.getNeighborsIterator(0, originalOrdinal);
            if (neighbors.size() > this.graph.getDegree(0)) {
                String msg = String.format("Node %d has more neighbors %d than the graph's max degree %d -- run Builder.cleanup()!", originalOrdinal, neighbors.size(), this.graph.getDegree(0));
                throw new IllegalStateException(msg);
            }
            ((RandomAccessWriter)this.out).writeInt(neighbors.size());
            for (n = 0; n < neighbors.size(); ++n) {
                int newNeighborOrdinal = this.ordinalMapper.oldToNew(neighbors.nextInt());
                if (newNeighborOrdinal < 0 || newNeighborOrdinal > this.ordinalMapper.maxOrdinal()) {
                    String msg = String.format("Neighbor ordinal out of bounds: %d/%d", newNeighborOrdinal, this.ordinalMapper.maxOrdinal());
                    throw new IllegalStateException(msg);
                }
                ((RandomAccessWriter)this.out).writeInt(newNeighborOrdinal);
            }
            assert (!neighbors.hasNext());
            while (n < this.graph.getDegree(0)) {
                ((RandomAccessWriter)this.out).writeInt(-1);
                ++n;
            }
        }
    }

    public static class Builder
    extends AbstractGraphIndexWriter.Builder<OnDiskGraphIndexWriter, RandomAccessWriter> {
        private long startOffset = 0L;

        public Builder(ImmutableGraphIndex graphIndex, Path outPath) throws FileNotFoundException {
            this(graphIndex, new BufferedRandomAccessWriter(outPath));
        }

        public Builder(ImmutableGraphIndex graphIndex, RandomAccessWriter out) {
            super(graphIndex, out);
        }

        public Builder withStartOffset(long startOffset) {
            this.startOffset = startOffset;
            return this;
        }

        @Override
        protected OnDiskGraphIndexWriter reallyBuild(int dimension) {
            return new OnDiskGraphIndexWriter((RandomAccessWriter)this.out, this.version, this.startOffset, this.graphIndex, this.ordinalMapper, dimension, this.features);
        }
    }
}

