/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.annotations.VisibleForTesting;
import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.disk.ReaderSupplier;
import io.github.jbellis.jvector.graph.ImmutableGraphIndex;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.graph.RandomAccessVectorValues;
import io.github.jbellis.jvector.graph.disk.CommonHeader;
import io.github.jbellis.jvector.graph.disk.Header;
import io.github.jbellis.jvector.graph.disk.OnDiskGraphIndexWriter;
import io.github.jbellis.jvector.graph.disk.feature.Feature;
import io.github.jbellis.jvector.graph.disk.feature.FeatureId;
import io.github.jbellis.jvector.graph.disk.feature.FeatureSource;
import io.github.jbellis.jvector.graph.disk.feature.FusedFeature;
import io.github.jbellis.jvector.graph.disk.feature.FusedPQ;
import io.github.jbellis.jvector.graph.disk.feature.InlineVectors;
import io.github.jbellis.jvector.graph.disk.feature.NVQ;
import io.github.jbellis.jvector.graph.disk.feature.SeparatedFeature;
import io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import io.github.jbellis.jvector.util.Accountable;
import io.github.jbellis.jvector.util.Bits;
import io.github.jbellis.jvector.util.RamUsageEstimator;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.VectorizationProvider;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import io.github.jbellis.jvector.vector.types.VectorTypeSupport;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.agrona.collections.Int2ObjectHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnDiskGraphIndex
implements ImmutableGraphIndex,
AutoCloseable,
Accountable {
    private static final Logger logger = LoggerFactory.getLogger(OnDiskGraphIndex.class);
    public static final int CURRENT_VERSION = 6;
    static final int MAGIC = -62111;
    static final VectorTypeSupport vectorTypeSupport = VectorizationProvider.getInstance().getVectorTypeSupport();
    final ReaderSupplier readerSupplier;
    final int version;
    final int dimension;
    final ImmutableGraphIndex.NodeAtLevel entryNode;
    final int idUpperBound;
    final int inlineBlockSize;
    final Map<FeatureId, ? extends Feature> features;
    final EnumMap<FeatureId, Integer> inlineOffsets;
    private final List<CommonHeader.LayerInfo> layerInfo;
    private final long neighborsOffset;
    private final AtomicReference<List<Int2ObjectHashMap<int[]>>> inMemoryNeighbors;
    private final AtomicReference<Int2ObjectHashMap<FusedFeature.InlineSource>> inMemoryFeatures;

    private OnDiskGraphIndex(ReaderSupplier readerSupplier, Header header, long neighborsOffset) {
        this.readerSupplier = readerSupplier;
        this.version = header.common.version;
        this.layerInfo = header.common.layerInfo;
        this.dimension = header.common.dimension;
        this.entryNode = new ImmutableGraphIndex.NodeAtLevel(header.common.layerInfo.size() - 1, header.common.entryNode);
        this.idUpperBound = header.common.idUpperBound;
        this.features = header.features;
        this.neighborsOffset = neighborsOffset;
        int inlineBlockSize = 0;
        this.inlineOffsets = new EnumMap(FeatureId.class);
        for (Map.Entry<FeatureId, ? extends Feature> entry : this.features.entrySet()) {
            Feature feature = entry.getValue();
            if (feature instanceof SeparatedFeature) continue;
            this.inlineOffsets.put(entry.getKey(), inlineBlockSize);
            inlineBlockSize += feature.featureSize();
        }
        this.inlineBlockSize = inlineBlockSize;
        this.inMemoryNeighbors = new AtomicReference<Object>(null);
        this.inMemoryFeatures = new AtomicReference<Object>(null);
    }

    private List<Int2ObjectHashMap<int[]>> getInMemoryLayers(RandomAccessReader in) throws IOException {
        return this.inMemoryNeighbors.updateAndGet(current -> {
            if (current != null) {
                return current;
            }
            try {
                return this.loadInMemoryLayers(in);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private List<Int2ObjectHashMap<int[]>> loadInMemoryLayers(RandomAccessReader in) throws IOException {
        ArrayList<Int2ObjectHashMap<int[]>> imn = new ArrayList<Int2ObjectHashMap<int[]>>(this.layerInfo.size());
        imn.add(null);
        long L0size = (long)this.idUpperBound * ((long)this.inlineBlockSize + 4L * (2L + (long)this.layerInfo.get((int)0).degree));
        in.seek(this.neighborsOffset + L0size);
        for (int lvl = 1; lvl < this.layerInfo.size(); ++lvl) {
            CommonHeader.LayerInfo info = this.layerInfo.get(lvl);
            Int2ObjectHashMap edges = new Int2ObjectHashMap();
            for (int i = 0; i < info.size; ++i) {
                int nodeId = in.readInt();
                assert (nodeId >= 0 && nodeId < this.idUpperBound) : String.format("Node ID %d out of bounds for layer %d", nodeId, lvl);
                int neighborCount = in.readInt();
                assert (neighborCount >= 0 && neighborCount <= info.degree) : String.format("Node %d neighborCount %d > M %d", nodeId, neighborCount, info.degree);
                int[] neighbors = new int[neighborCount];
                in.read(neighbors, 0, neighborCount);
                int skip = info.degree - neighborCount;
                if (skip > 0) {
                    in.seek(in.getPosition() + (long)skip * 4L);
                }
                edges.put(nodeId, (Object)neighbors);
            }
            imn.add((Int2ObjectHashMap<int[]>)edges);
        }
        return imn;
    }

    private Int2ObjectHashMap<FusedFeature.InlineSource> getInMemoryFeatures(RandomAccessReader in) throws IOException {
        return this.inMemoryFeatures.updateAndGet(current -> {
            if (current != null) {
                return current;
            }
            for (Feature feature : this.features.values()) {
                if (!feature.isFused()) continue;
                try {
                    return this.loadInMemoryFeatures(in);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return null;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Int2ObjectHashMap<FusedFeature.InlineSource> loadInMemoryFeatures(RandomAccessReader in) throws IOException {
        Int2ObjectHashMap hierarchyFeatures;
        block6: {
            CommonHeader.LayerInfo info;
            hierarchyFeatures = new Int2ObjectHashMap();
            long L0size = (long)this.idUpperBound * ((long)this.inlineBlockSize + 4L * (2L + (long)this.layerInfo.get((int)0).degree));
            long inMemorySize = 0L;
            for (int lvl = 1; lvl < this.layerInfo.size(); ++lvl) {
                info = this.layerInfo.get(lvl);
                inMemorySize += (long)(4 * info.size) * (2L + (long)info.degree);
            }
            in.seek(this.neighborsOffset + L0size + inMemorySize);
            if (this.version != 6) break block6;
            if (this.layerInfo.size() >= 2) {
                void var9_8;
                int level = 1;
                info = this.layerInfo.get(level);
                boolean bl = false;
                while (var9_8 < info.size) {
                    int nodeId = in.readInt();
                    for (Feature feature : this.features.values()) {
                        if (!feature.isFused()) continue;
                        FusedFeature fusedFeature = (FusedFeature)feature;
                        FusedFeature.InlineSource inlineSource = fusedFeature.loadSourceFeature(in);
                        hierarchyFeatures.put(nodeId, (Object)inlineSource);
                    }
                    ++var9_8;
                }
            } else {
                int nodeId = in.readInt();
                for (Feature feature : this.features.values()) {
                    if (!feature.isFused()) continue;
                    FusedFeature fusedFeature = (FusedFeature)feature;
                    FusedFeature.InlineSource inlineSource = fusedFeature.loadSourceFeature(in);
                    hierarchyFeatures.put(nodeId, (Object)inlineSource);
                }
            }
        }
        return hierarchyFeatures;
    }

    public static OnDiskGraphIndex load(ReaderSupplier readerSupplier, long offset) {
        return OnDiskGraphIndex.load(readerSupplier, offset, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OnDiskGraphIndex load(ReaderSupplier readerSupplier, long offset, boolean useFooter) {
        try (RandomAccessReader reader = readerSupplier.get();){
            logger.debug("Loading OnDiskGraphIndex from offset={}", (Object)offset);
            Header header = Header.load(reader, offset);
            logger.debug("Header loaded: version={}, dimension={}, entryNode={}, layerInfoCount={}", new Object[]{header.common.version, header.common.dimension, header.common.entryNode, header.common.layerInfo.size()});
            logger.debug("Position after reading header={}", (Object)reader.getPosition());
            if (header.common.version >= 5 && useFooter) {
                logger.debug("Version 5+ onwards uses a footer instead of header for metadata. Loading from footer");
                OnDiskGraphIndex onDiskGraphIndex2 = OnDiskGraphIndex.loadFromFooter(readerSupplier, reader.getPosition());
                return onDiskGraphIndex2;
            }
            OnDiskGraphIndex odgi = new OnDiskGraphIndex(readerSupplier, header, reader.getPosition());
            odgi.getInMemoryLayers(reader);
            odgi.getInMemoryFeatures(reader);
            OnDiskGraphIndex onDiskGraphIndex = odgi;
            return onDiskGraphIndex;
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing OnDiskGraph at offset " + offset, e);
        }
    }

    public static OnDiskGraphIndex load(ReaderSupplier readerSupplier) {
        return OnDiskGraphIndex.load(readerSupplier, 0L);
    }

    private static OnDiskGraphIndex loadFromFooter(ReaderSupplier readerSupplier, long neighborsOffset) {
        OnDiskGraphIndex onDiskGraphIndex;
        block9: {
            RandomAccessReader in = readerSupplier.get();
            try {
                long magicOffset = in.length() - 4L;
                logger.debug("Loading OnDiskGraphIndex footer from offset={}", (Object)magicOffset);
                in.seek(magicOffset);
                int version = in.readInt();
                if (version != 1247167044) {
                    logger.error("Found an invalid footer, magic doesn't match any known version: {}", (Object)version);
                    throw new RuntimeException("Unsupported version " + version);
                }
                long metadataOffset = magicOffset - 8L;
                logger.debug("Loading header offset={}", (Object)metadataOffset);
                in.seek(metadataOffset);
                long headerOffset = in.readLong();
                logger.debug("Loading OnDiskGraphIndex header from offset={}", (Object)headerOffset);
                Header header = Header.load(in, headerOffset);
                logger.debug("Header loaded: version={}, dimension={}, entryNode={}, layerInfoCount={}, Position after reading header={}", new Object[]{header.common.version, header.common.dimension, header.common.entryNode, header.common.layerInfo.size(), in.getPosition()});
                OnDiskGraphIndex odgi = new OnDiskGraphIndex(readerSupplier, header, neighborsOffset);
                odgi.getInMemoryLayers(in);
                odgi.getInMemoryFeatures(in);
                onDiskGraphIndex = odgi;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error initializing OnDiskGraph", e);
                }
            }
            in.close();
        }
        return onDiskGraphIndex;
    }

    public Set<FeatureId> getFeatureSet() {
        return this.features.keySet();
    }

    public Map<FeatureId, ? extends Feature> getFeatures() {
        return this.features;
    }

    @Override
    public boolean isHierarchical() {
        return this.layerInfo.size() > 1;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public int size(int level) {
        return this.layerInfo.get((int)level).size;
    }

    @Override
    public int getDegree(int level) {
        return this.layerInfo.get((int)level).degree;
    }

    @Override
    public List<Integer> maxDegrees() {
        return this.layerInfo.stream().map(l -> l.degree).collect(Collectors.toList());
    }

    @Override
    public int getIdUpperBound() {
        return this.idUpperBound;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NodesIterator getNodes(int level) {
        int size = this.size(level);
        int maxDegree = this.getDegree(level);
        long layer0NodeSize = 4L + (long)this.inlineBlockSize + 4L * (long)(this.getDegree(0) + 1);
        long layerUpperNodeSize = 4L + 4L * (long)(maxDegree + 1);
        long thisLayerNodeSide = level == 0 ? layer0NodeSize : layerUpperNodeSize;
        long layerOffset = this.neighborsOffset;
        layerOffset += level > 0 ? layer0NodeSize * (long)this.size(0) : 0L;
        for (int lvl = 1; lvl < level; layerOffset += layerUpperNodeSize * (long)this.size(lvl), ++lvl) {
        }
        try (RandomAccessReader reader = this.readerSupplier.get();){
            if (level > 0) {
                List<Int2ObjectHashMap<int[]>> imn = this.getInMemoryLayers(reader);
                Integer[] validIntegerNodes = (Integer[])imn.get(level).keySet().stream().sorted().toArray(Integer[]::new);
                int[] validNodes = new int[validIntegerNodes.length];
                int i222 = 0;
                while (true) {
                    if (i222 >= validNodes.length) {
                        NodesIterator.ArrayNodesIterator i222 = new NodesIterator.ArrayNodesIterator(validNodes, size);
                        return i222;
                    }
                    validNodes[i222] = validIntegerNodes[i222];
                    ++i222;
                }
            }
            int[] validNodes = new int[this.size(level)];
            int upperBound = level == 0 ? this.getIdUpperBound() : this.size(level);
            int pos = 0;
            for (int nodeOrd = 0; nodeOrd < upperBound; ++nodeOrd) {
                long nodeOffset = layerOffset + (long)nodeOrd * thisLayerNodeSide;
                reader.seek(nodeOffset);
                int nodeId = reader.readInt();
                if (nodeId == -1) continue;
                validNodes[pos++] = nodeId;
            }
            NodesIterator.ArrayNodesIterator arrayNodesIterator = new NodesIterator.ArrayNodesIterator(validNodes, size);
            return arrayNodesIterator;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long ramBytesUsed() {
        List<Int2ObjectHashMap<int[]>> inMemoryNeighborsLocal = this.inMemoryNeighbors.get();
        long inMemoryNeighborsBytes = RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        if (inMemoryNeighborsLocal != null) {
            for (Int2ObjectHashMap<int[]> neighbors : inMemoryNeighborsLocal) {
                if (neighbors != null) {
                    inMemoryNeighborsBytes += neighbors.values().stream().mapToLong(is -> 4L * (long)((int[])is).length).sum();
                }
                inMemoryNeighborsBytes += (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
            }
        }
        Int2ObjectHashMap<FusedFeature.InlineSource> inMemoryFeaturesLocal = this.inMemoryFeatures.get();
        long inMemoryFeaturesBytes = 0L;
        if (inMemoryFeaturesLocal != null) {
            inMemoryFeaturesBytes = inMemoryFeaturesLocal.values().stream().mapToLong(is -> 4L * is.ramBytesUsed()).sum();
        }
        return (long)(32 + RamUsageEstimator.NUM_BYTES_OBJECT_REF) + 2L * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF * (long)FeatureId.values().length + inMemoryNeighborsBytes + (inMemoryFeaturesBytes += (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF);
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return String.format("OnDiskGraphIndex(layers=%s, entryPoint=%s, features=%s)", this.layerInfo, this.entryNode, this.features.keySet().stream().map(Enum::name).collect(Collectors.joining(",")));
    }

    @Override
    public int getMaxLevel() {
        return this.entryNode.level;
    }

    @Override
    public int maxDegree() {
        return this.layerInfo.stream().mapToInt(li -> li.degree).max().orElseThrow();
    }

    @Override
    public View getView() {
        try {
            return new View(this.readerSupplier.get());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public double getAverageDegree(int level) {
        View view = this.getView();
        NodesIterator it = this.getNodes(level);
        long sum = 0L;
        while (it.hasNext()) {
            int node = it.next();
            sum += (long)view.getNeighborsIterator(level, node).size();
        }
        return (double)sum / (double)it.size();
    }

    public static void write(ImmutableGraphIndex graph, RandomAccessVectorValues vectors, Path path) throws IOException {
        OnDiskGraphIndex.write(graph, vectors, OnDiskGraphIndexWriter.sequentialRenumbering(graph), path);
    }

    public static void write(ImmutableGraphIndex graph, RandomAccessVectorValues vectors, Map<Integer, Integer> oldToNewOrdinals, Path path) throws IOException {
        try (OnDiskGraphIndexWriter writer = (OnDiskGraphIndexWriter)new OnDiskGraphIndexWriter.Builder(graph, path).withMap(oldToNewOrdinals).with(new InlineVectors(vectors.dimension())).build();){
            EnumMap<FeatureId, IntFunction<Feature.State>> suppliers = Feature.singleStateFactory(FeatureId.INLINE_VECTORS, nodeId -> new InlineVectors.State(vectors.getVector(nodeId)));
            writer.write(suppliers);
        }
    }

    @VisibleForTesting
    static boolean areHeadersEqual(OnDiskGraphIndex g1, OnDiskGraphIndex g2) {
        return g1.version == g2.version && g1.dimension == g2.dimension && g1.entryNode.equals(g2.entryNode) && g1.layerInfo.equals(g2.layerInfo);
    }

    public class View
    implements FeatureSource,
    ImmutableGraphIndex.ScoringView,
    RandomAccessVectorValues {
        protected final RandomAccessReader reader;
        private final int[] neighbors;
        private int nodeDegree;

        public View(RandomAccessReader reader) {
            this.reader = reader;
            this.neighbors = new int[OnDiskGraphIndex.this.layerInfo.stream().mapToInt(li -> li.degree).max().orElse(0)];
        }

        @Override
        public int dimension() {
            return OnDiskGraphIndex.this.dimension;
        }

        @Override
        public boolean isValueShared() {
            return false;
        }

        @Override
        public RandomAccessVectorValues copy() {
            throw new UnsupportedOperationException();
        }

        private long offsetFor(int node, FeatureId featureId) {
            Feature feature = OnDiskGraphIndex.this.features.get((Object)featureId);
            if (feature instanceof SeparatedFeature) {
                SeparatedFeature sf = (SeparatedFeature)feature;
                return sf.getOffset() + (long)node * (long)feature.featureSize();
            }
            long skipInNode = 4 + OnDiskGraphIndex.this.inlineOffsets.get((Object)featureId);
            return this.baseNodeOffsetFor(node) + skipInNode;
        }

        private long neighborsOffsetFor(int level, int node) {
            assert (level == 0);
            long skipInline = 4 + OnDiskGraphIndex.this.inlineBlockSize;
            return this.baseNodeOffsetFor(node) + skipInline;
        }

        private long baseNodeOffsetFor(int node) {
            int degree = OnDiskGraphIndex.this.layerInfo.get((int)0).degree;
            long skipInline = 4 + OnDiskGraphIndex.this.inlineBlockSize;
            long blockBytes = skipInline + 4L * (long)(degree + 1);
            long offsetWithinLayer = blockBytes * (long)node;
            return OnDiskGraphIndex.this.neighborsOffset + offsetWithinLayer;
        }

        @Override
        public RandomAccessReader featureReaderForNode(int node, FeatureId featureId) throws IOException {
            long offset = this.offsetFor(node, featureId);
            this.reader.seek(offset);
            return this.reader;
        }

        @Override
        public VectorFloat<?> getVector(int node) {
            VectorFloat<?> vec = vectorTypeSupport.createFloatVector(OnDiskGraphIndex.this.dimension);
            this.getVectorInto(node, vec, 0);
            return vec;
        }

        @Override
        public void getVectorInto(int node, VectorFloat<?> vector, int offset) {
            Feature feature = OnDiskGraphIndex.this.features.get((Object)FeatureId.INLINE_VECTORS);
            if (feature == null) {
                feature = OnDiskGraphIndex.this.features.get((Object)FeatureId.SEPARATED_VECTORS);
            }
            if (feature == null) {
                throw new UnsupportedOperationException("No full-resolution vectors in this graph");
            }
            try {
                long diskOffset = this.offsetFor(node, feature.id());
                this.reader.seek(diskOffset);
                vectorTypeSupport.readFloatVector(this.reader, OnDiskGraphIndex.this.dimension, vector, offset);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public NodesIterator getNeighborsIterator(int level, int node) {
            try {
                int[] stored;
                if (level == 0) {
                    this.reader.seek(this.neighborsOffsetFor(level, node));
                    this.nodeDegree = this.reader.readInt();
                    assert (this.nodeDegree <= this.neighbors.length) : String.format("Node %d neighborCount %d > M %d", node, this.nodeDegree, this.neighbors.length);
                    this.reader.read(this.neighbors, 0, this.nodeDegree);
                    stored = this.neighbors;
                } else {
                    List<Int2ObjectHashMap<int[]>> imn = OnDiskGraphIndex.this.getInMemoryLayers(this.reader);
                    stored = (int[])imn.get(level).get(node);
                    this.nodeDegree = stored.length;
                    assert (stored != null) : String.format("No neighbors found for node %d at level %d", node, level);
                }
                return new NodesIterator.ArrayNodesIterator(stored, this.nodeDegree);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void getPackedNeighbors(int node, FeatureId featureId, Consumer<RandomAccessReader> featureConsumer) throws IOException {
            Feature feature = OnDiskGraphIndex.this.features.get((Object)featureId);
            if (!feature.isFused()) {
                throw new UnsupportedOperationException("Only fused features are supported with packed neighbors");
            }
            long offset = this.offsetFor(node, featureId);
            this.reader.seek(offset);
            featureConsumer.accept(this.reader);
            if (OnDiskGraphIndex.this.version < 6) {
                this.reader.seek(this.neighborsOffsetFor(0, node));
            }
            this.nodeDegree = this.reader.readInt();
            assert (this.nodeDegree <= this.neighbors.length) : String.format("Node %d neighborCount %d > M %d", node, this.nodeDegree, this.neighbors.length);
            this.reader.read(this.neighbors, 0, this.nodeDegree);
        }

        public Int2ObjectHashMap<FusedFeature.InlineSource> getInlineSourceFeatures() {
            try {
                return OnDiskGraphIndex.this.getInMemoryFeatures(this.reader);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void processNeighbors(int level, int node, ScoreFunction scoreFunction, ImmutableGraphIndex.IntMarker visited, ImmutableGraphIndex.NeighborProcessor neighborProcessor) {
            boolean useEdgeLoading = scoreFunction.supportsSimilarityToNeighbors();
            if (useEdgeLoading && level == 0) {
                scoreFunction.enableSimilarityToNeighbors(node);
                for (int i = 0; i < this.nodeDegree; ++i) {
                    int friendOrd = this.neighbors[i];
                    if (!visited.mark(friendOrd)) continue;
                    float friendSimilarity = scoreFunction.similarityToNeighbor(node, i);
                    neighborProcessor.process(friendOrd, friendSimilarity);
                }
            } else {
                NodesIterator it = this.getNeighborsIterator(level, node);
                while (it.hasNext()) {
                    int friendOrd = it.nextInt();
                    if (!visited.mark(friendOrd)) continue;
                    float friendSimilarity = scoreFunction.similarityTo(friendOrd);
                    neighborProcessor.process(friendOrd, friendSimilarity);
                }
            }
        }

        @Override
        public int size() {
            return OnDiskGraphIndex.this.size(0);
        }

        @Override
        public ImmutableGraphIndex.NodeAtLevel entryNode() {
            return OnDiskGraphIndex.this.entryNode;
        }

        @Override
        public int getIdUpperBound() {
            return OnDiskGraphIndex.this.idUpperBound;
        }

        @Override
        public boolean contains(int level, int node) {
            try {
                if (level == 0) {
                    return node < OnDiskGraphIndex.this.idUpperBound;
                }
                List<Int2ObjectHashMap<int[]>> imn = OnDiskGraphIndex.this.getInMemoryLayers(this.reader);
                return imn.get(level).containsKey(node);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public Bits liveNodes() {
            return Bits.ALL;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        @Override
        public ScoreFunction.ExactScoreFunction rerankerFor(VectorFloat<?> queryVector, VectorSimilarityFunction vsf) {
            if (OnDiskGraphIndex.this.features.containsKey((Object)FeatureId.INLINE_VECTORS)) {
                return RandomAccessVectorValues.super.rerankerFor(queryVector, vsf);
            }
            if (OnDiskGraphIndex.this.features.containsKey((Object)FeatureId.NVQ_VECTORS)) {
                return ((NVQ)OnDiskGraphIndex.this.features.get((Object)FeatureId.NVQ_VECTORS)).rerankerFor(queryVector, vsf, this);
            }
            throw new UnsupportedOperationException("No reranker available for this graph");
        }

        @Override
        public ScoreFunction.ApproximateScoreFunction approximateScoreFunctionFor(VectorFloat<?> queryVector, VectorSimilarityFunction vsf) {
            if (OnDiskGraphIndex.this.features.containsKey((Object)FeatureId.FUSED_PQ)) {
                return ((FusedPQ)OnDiskGraphIndex.this.features.get((Object)FeatureId.FUSED_PQ)).approximateScoreFunctionFor(queryVector, vsf, this, this.rerankerFor(queryVector, vsf));
            }
            throw new UnsupportedOperationException("No approximate score function available for this graph");
        }
    }
}

