/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.disk.ByteBufferIndexWriter;
import io.github.jbellis.jvector.graph.ImmutableGraphIndex;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.graph.disk.OrdinalMapper;
import io.github.jbellis.jvector.graph.disk.feature.Feature;
import io.github.jbellis.jvector.graph.disk.feature.FeatureId;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.IntFunction;

class NodeRecordTask
implements Callable<Void> {
    private final int startOrdinal;
    private final int endOrdinal;
    private final OrdinalMapper ordinalMapper;
    private final ImmutableGraphIndex graph;
    private final ImmutableGraphIndex.View view;
    private final List<Feature> inlineFeatures;
    private final Map<FeatureId, IntFunction<Feature.State>> featureStateSuppliers;
    private final int recordSize;
    private final long baseOffset;
    private final AsynchronousFileChannel channel;
    private final ByteBuffer buffer;

    NodeRecordTask(int startOrdinal, int endOrdinal, OrdinalMapper ordinalMapper, ImmutableGraphIndex graph, ImmutableGraphIndex.View view, List<Feature> inlineFeatures, Map<FeatureId, IntFunction<Feature.State>> featureStateSuppliers, int recordSize, long baseOffset, AsynchronousFileChannel channel, ByteBuffer buffer) {
        this.startOrdinal = startOrdinal;
        this.endOrdinal = endOrdinal;
        this.ordinalMapper = ordinalMapper;
        this.graph = graph;
        this.view = view;
        this.inlineFeatures = inlineFeatures;
        this.featureStateSuppliers = featureStateSuppliers;
        this.recordSize = recordSize;
        this.baseOffset = baseOffset;
        this.channel = channel;
        this.buffer = buffer;
    }

    private static void writeFully(AsynchronousFileChannel channel, ByteBuffer buffer, long position) throws IOException, ExecutionException, InterruptedException {
        long currentPosition = position;
        while (buffer.hasRemaining()) {
            int written = channel.write(buffer, currentPosition).get();
            if (written < 0) {
                throw new IOException("Channel closed while writing");
            }
            currentPosition += (long)written;
        }
    }

    @Override
    public Void call() throws Exception {
        ByteBufferIndexWriter writer = new ByteBufferIndexWriter(this.buffer);
        for (int newOrdinal = this.startOrdinal; newOrdinal < this.endOrdinal; ++newOrdinal) {
            int n;
            long recordOffset;
            int originalOrdinal = this.ordinalMapper.newToOld(newOrdinal);
            long currentPosition = recordOffset = this.baseOffset + (long)newOrdinal * (long)this.recordSize;
            writer.reset();
            writer.writeInt(newOrdinal);
            ByteBuffer ordinalData = writer.cloneBuffer();
            NodeRecordTask.writeFully(this.channel, ordinalData, currentPosition);
            currentPosition += 4L;
            if (originalOrdinal == Integer.MIN_VALUE) {
                writer.reset();
                for (Feature feature : this.inlineFeatures) {
                    for (int i = 0; i < feature.featureSize(); ++i) {
                        writer.writeByte(0);
                    }
                }
                ByteBuffer featureData = writer.cloneBuffer();
                NodeRecordTask.writeFully(this.channel, featureData, currentPosition);
                currentPosition += (long)featureData.remaining();
                writer.reset();
                writer.writeInt(0);
                for (int n2 = 0; n2 < this.graph.getDegree(0); ++n2) {
                    writer.writeInt(-1);
                }
                ByteBuffer neighborData = writer.cloneBuffer();
                NodeRecordTask.writeFully(this.channel, neighborData, currentPosition);
                continue;
            }
            if (!this.graph.containsNode(originalOrdinal)) {
                throw new IllegalStateException(String.format("Ordinal mapper mapped new ordinal %s to non-existing node %s", newOrdinal, originalOrdinal));
            }
            for (Feature feature : this.inlineFeatures) {
                IntFunction<Feature.State> supplier = this.featureStateSuppliers.get((Object)feature.id());
                if (supplier != null) {
                    writer.reset();
                    feature.writeInline(writer, supplier.apply(originalOrdinal));
                    ByteBuffer featureData = writer.cloneBuffer();
                    NodeRecordTask.writeFully(this.channel, featureData, currentPosition);
                }
                currentPosition += (long)feature.featureSize();
            }
            writer.reset();
            NodesIterator neighbors = this.view.getNeighborsIterator(0, originalOrdinal);
            if (neighbors.size() > this.graph.getDegree(0)) {
                throw new IllegalStateException(String.format("Node %d has more neighbors %d than the graph's max degree %d -- run Builder.cleanup()!", originalOrdinal, neighbors.size(), this.graph.getDegree(0)));
            }
            writer.writeInt(neighbors.size());
            for (n = 0; n < neighbors.size(); ++n) {
                int newNeighborOrdinal = this.ordinalMapper.oldToNew(neighbors.nextInt());
                if (newNeighborOrdinal < 0 || newNeighborOrdinal > this.ordinalMapper.maxOrdinal()) {
                    throw new IllegalStateException(String.format("Neighbor ordinal out of bounds: %d/%d", newNeighborOrdinal, this.ordinalMapper.maxOrdinal()));
                }
                writer.writeInt(newNeighborOrdinal);
            }
            while (n < this.graph.getDegree(0)) {
                writer.writeInt(-1);
                ++n;
            }
            ByteBuffer neighborData = writer.cloneBuffer();
            NodeRecordTask.writeFully(this.channel, neighborData, currentPosition);
        }
        return null;
    }
}

