/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.disk;

import io.github.jbellis.jvector.disk.MappedChunkReader;
import io.github.jbellis.jvector.disk.ReaderSupplier;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReaderSupplierFactory {
    private static final Logger LOG = Logger.getLogger(ReaderSupplierFactory.class.getName());
    private static final String MEMORY_SEGMENT_READER_CLASSNAME = "io.github.jbellis.jvector.disk.MemorySegmentReader$Supplier";
    private static final String MMAP_READER_CLASSNAME = "io.github.jbellis.jvector.example.util.MMapReader$Supplier";

    private ReaderSupplierFactory() {
    }

    public static ReaderSupplier open(Path path) throws IOException {
        try {
            Class<?> supplierClass = Class.forName(MEMORY_SEGMENT_READER_CLASSNAME);
            Constructor<?> ctor = supplierClass.getConstructor(Path.class);
            return (ReaderSupplier)ctor.newInstance(path);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "MemorySegmentReaderSupplier not available, falling back to MMapReaderSupplier. Reason: {0}: {1}", new Object[]{e.getClass().getName(), e.getMessage()});
            try {
                Class<?> supplierClass = Class.forName(MMAP_READER_CLASSNAME);
                Constructor<?> ctor = supplierClass.getConstructor(Path.class);
                return (ReaderSupplier)ctor.newInstance(path);
            }
            catch (Exception e2) {
                LOG.log(Level.WARNING, "MMapReaderSupplier not available, falling back to MappedChunkReader. More details available at level FINE.");
                LOG.log(Level.FINE, "MMapReaderSupplier instantiation exception:", e2);
                return new MappedChunkReader.Supplier(path);
            }
        }
    }
}

