/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk.feature;

import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.graph.disk.CommonHeader;
import io.github.jbellis.jvector.graph.disk.feature.Feature;
import io.github.jbellis.jvector.graph.disk.feature.FusedPQ;
import io.github.jbellis.jvector.graph.disk.feature.InlineVectors;
import io.github.jbellis.jvector.graph.disk.feature.NVQ;
import io.github.jbellis.jvector.graph.disk.feature.SeparatedNVQ;
import io.github.jbellis.jvector.graph.disk.feature.SeparatedVectors;
import java.util.EnumSet;
import java.util.function.BiFunction;

public enum FeatureId {
    INLINE_VECTORS(InlineVectors::load),
    FUSED_PQ(FusedPQ::load),
    NVQ_VECTORS(NVQ::load),
    SEPARATED_VECTORS(SeparatedVectors::load),
    SEPARATED_NVQ(SeparatedNVQ::load);

    private final BiFunction<CommonHeader, RandomAccessReader, Feature> loader;

    private FeatureId(BiFunction<CommonHeader, RandomAccessReader, Feature> loader) {
        this.loader = loader;
    }

    public Feature load(CommonHeader header, RandomAccessReader reader) {
        return this.loader.apply(header, reader);
    }

    public static EnumSet<FeatureId> deserialize(int bitflags) {
        EnumSet<FeatureId> set = EnumSet.noneOf(FeatureId.class);
        for (int n = 0; n < FeatureId.values().length; ++n) {
            if ((bitflags & 1 << n) == 0) continue;
            set.add(FeatureId.values()[n]);
        }
        return set;
    }

    public static int serialize(EnumSet<FeatureId> flags) {
        int i = 0;
        for (FeatureId flag : flags) {
            i |= 1 << flag.ordinal();
        }
        return i;
    }
}

