/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.disk.IndexWriter;
import io.github.jbellis.jvector.disk.RandomAccessWriter;
import io.github.jbellis.jvector.graph.ImmutableGraphIndex;
import io.github.jbellis.jvector.graph.disk.AbstractGraphIndexWriter;
import io.github.jbellis.jvector.graph.disk.GraphIndexWriterTypes;
import io.github.jbellis.jvector.graph.disk.OnDiskGraphIndexWriter;
import io.github.jbellis.jvector.graph.disk.OnDiskSequentialGraphIndexWriter;
import io.github.jbellis.jvector.graph.disk.feature.Feature;
import io.github.jbellis.jvector.graph.disk.feature.FeatureId;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.IntFunction;

public interface GraphIndexWriter
extends Closeable {
    public void write(Map<FeatureId, IntFunction<Feature.State>> var1) throws IOException;

    public static AbstractGraphIndexWriter.Builder<? extends AbstractGraphIndexWriter<?>, ? extends IndexWriter> getBuilderFor(GraphIndexWriterTypes type, ImmutableGraphIndex graphIndex, IndexWriter out) {
        switch (type) {
            case ON_DISK_PARALLEL: {
                if (!(out instanceof RandomAccessWriter)) {
                    throw new IllegalArgumentException("ON_DISK_PARALLEL requires a RandomAccessWriter");
                }
                return new OnDiskGraphIndexWriter.Builder(graphIndex, (RandomAccessWriter)out);
            }
            case ON_DISK_SEQUENTIAL: {
                return new OnDiskSequentialGraphIndexWriter.Builder(graphIndex, out);
            }
        }
        throw new IllegalArgumentException("Unknown GraphIndexWriterType: " + String.valueOf((Object)type));
    }

    public static AbstractGraphIndexWriter.Builder<? extends AbstractGraphIndexWriter<?>, ? extends IndexWriter> getBuilderFor(GraphIndexWriterTypes type, ImmutableGraphIndex graphIndex, Path out) throws FileNotFoundException {
        switch (type) {
            case ON_DISK_PARALLEL: {
                return new OnDiskGraphIndexWriter.Builder(graphIndex, out);
            }
        }
        throw new IllegalArgumentException("Unknown GraphIndexWriterType: " + String.valueOf((Object)type));
    }
}

