/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.disk;

import io.github.jbellis.jvector.disk.ByteBufferReader;
import io.github.jbellis.jvector.disk.ReaderSupplier;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.logging.Logger;
import sun.misc.Unsafe;

public class SimpleMappedReader
extends ByteBufferReader {
    private static final Logger LOG = Logger.getLogger(SimpleMappedReader.class.getName());

    private static Unsafe getUnsafe() {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            return (Unsafe)f.get(null);
        }
        catch (Exception e) {
            LOG.warning("MappedRandomAccessReader can't acquire needed Unsafe access");
            return null;
        }
    }

    SimpleMappedReader(MappedByteBuffer mbb) {
        super(mbb);
    }

    @Override
    public void close() {
    }

    public static class Supplier
    implements ReaderSupplier {
        private final MappedByteBuffer buffer;
        private static final Unsafe unsafe = SimpleMappedReader.getUnsafe();

        public Supplier(Path path) throws IOException {
            try (RandomAccessFile raf = new RandomAccessFile(path.toString(), "r");){
                if (raf.length() > Integer.MAX_VALUE) {
                    throw new RuntimeException("SimpleMappedReader doesn't support files above 2GB");
                }
                this.buffer = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, raf.length());
                this.buffer.order(ByteOrder.BIG_ENDIAN);
                this.buffer.load();
            }
        }

        @Override
        public SimpleMappedReader get() {
            return new SimpleMappedReader((MappedByteBuffer)this.buffer.duplicate());
        }

        @Override
        public void close() {
            if (unsafe != null) {
                try {
                    unsafe.invokeCleaner(this.buffer);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }
}

