/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.disk;

import io.github.jbellis.jvector.disk.IndexWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferIndexWriter
implements IndexWriter {
    private final ByteBuffer buffer;
    private final int initialPosition;

    public ByteBufferIndexWriter(ByteBuffer buffer, boolean autoClear) {
        this.buffer = buffer;
        if (autoClear) {
            buffer.clear();
        }
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        this.initialPosition = buffer.position();
    }

    public ByteBufferIndexWriter(ByteBuffer buffer) {
        this(buffer, true);
    }

    public static ByteBufferIndexWriter create(int capacity, boolean offHeap) {
        if (offHeap) {
            return ByteBufferIndexWriter.allocateDirect(capacity);
        }
        return ByteBufferIndexWriter.allocate(capacity);
    }

    private static ByteBufferIndexWriter allocate(int capacity) {
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        buffer.order(ByteOrder.BIG_ENDIAN);
        return new ByteBufferIndexWriter(buffer);
    }

    private static ByteBufferIndexWriter allocateDirect(int capacity) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(capacity);
        buffer.order(ByteOrder.BIG_ENDIAN);
        return new ByteBufferIndexWriter(buffer);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public ByteBuffer getWrittenData() {
        int currentPos = this.buffer.position();
        this.buffer.position(this.initialPosition);
        ByteBuffer slice = this.buffer.slice();
        slice.limit(currentPos - this.initialPosition);
        this.buffer.position(currentPos);
        return slice.asReadOnlyBuffer();
    }

    public void reset() {
        this.buffer.clear();
        this.buffer.position(this.initialPosition);
    }

    public ByteBuffer cloneBuffer() {
        int bytesWritten = this.buffer.position() - this.initialPosition;
        int savedPosition = this.buffer.position();
        this.buffer.position(this.initialPosition);
        this.buffer.limit(savedPosition);
        ByteBuffer copy = ByteBuffer.allocate(bytesWritten);
        copy.put(this.buffer);
        copy.flip();
        return copy;
    }

    public int bytesWritten() {
        return this.buffer.position() - this.initialPosition;
    }

    @Override
    public long position() {
        return this.buffer.position() - this.initialPosition;
    }

    @Override
    public void close() {
    }

    @Override
    public void write(int b) {
        this.buffer.put((byte)b);
    }

    @Override
    public void write(byte[] b) {
        this.buffer.put(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.buffer.put(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) {
        this.buffer.put((byte)(v ? 1 : 0));
    }

    @Override
    public void writeByte(int v) {
        this.buffer.put((byte)v);
    }

    @Override
    public void writeShort(int v) {
        this.buffer.putShort((short)v);
    }

    @Override
    public void writeChar(int v) {
        this.buffer.putChar((char)v);
    }

    @Override
    public void writeInt(int v) {
        this.buffer.putInt(v);
    }

    @Override
    public void writeLong(long v) {
        this.buffer.putLong(v);
    }

    @Override
    public void writeFloat(float v) {
        this.buffer.putFloat(v);
    }

    @Override
    public void writeFloats(float[] floats, int offset, int count) throws IOException {
        this.buffer.asFloatBuffer().put(floats, offset, count);
    }

    @Override
    public void writeDouble(double v) {
        this.buffer.putDouble(v);
    }

    @Override
    public void writeBytes(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.buffer.put((byte)s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.buffer.putChar(s.charAt(i));
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        byte[] bytes = s.getBytes("UTF-8");
        int utflen = bytes.length;
        if (utflen > 65535) {
            throw new IOException("encoded string too long: " + utflen + " bytes");
        }
        this.buffer.putShort((short)utflen);
        this.buffer.put(bytes);
    }
}

