/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph;

import io.github.jbellis.jvector.graph.RandomAccessVectorValues;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import java.util.Arrays;

public class RemappedRandomAccessVectorValues
implements RandomAccessVectorValues {
    private final RandomAccessVectorValues ravv;
    private final int[] graphToRavvOrdMap;

    public RemappedRandomAccessVectorValues(RandomAccessVectorValues ravv, int[] graphToRavvOrdMap) {
        this.ravv = ravv;
        this.graphToRavvOrdMap = graphToRavvOrdMap;
    }

    @Override
    public int size() {
        return this.graphToRavvOrdMap.length;
    }

    @Override
    public int dimension() {
        return this.ravv.dimension();
    }

    @Override
    public VectorFloat<?> getVector(int node) {
        return this.ravv.getVector(this.graphToRavvOrdMap[node]);
    }

    @Override
    public boolean isValueShared() {
        return this.ravv.isValueShared();
    }

    @Override
    public RandomAccessVectorValues copy() {
        return new RemappedRandomAccessVectorValues(this.ravv.copy(), Arrays.copyOf(this.graphToRavvOrdMap, this.graphToRavvOrdMap.length));
    }

    @Override
    public void getVectorInto(int node, VectorFloat<?> result, int offset) {
        this.ravv.getVectorInto(this.graphToRavvOrdMap[node], result, offset);
    }
}

