/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.diversity;

import io.github.jbellis.jvector.graph.NodeArray;
import io.github.jbellis.jvector.graph.diversity.DiversityProvider;
import io.github.jbellis.jvector.graph.similarity.BuildScoreProvider;
import io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import io.github.jbellis.jvector.util.BitSet;

public class VamanaDiversityProvider
implements DiversityProvider {
    public final float alpha;
    public final BuildScoreProvider scoreProvider;

    public VamanaDiversityProvider(BuildScoreProvider scoreProvider, float alpha) {
        this.scoreProvider = scoreProvider;
        this.alpha = alpha;
    }

    @Override
    public double retainDiverse(NodeArray neighbors, int maxDegree, int diverseBefore, BitSet selected) {
        for (int i = 0; i < Math.min(diverseBefore, maxDegree); ++i) {
            selected.set(i);
        }
        int nSelected = diverseBefore;
        double shortEdges = Double.NaN;
        float currentAlpha = 1.0f;
        while ((double)currentAlpha <= (double)this.alpha + 1.0E-6 && nSelected < maxDegree) {
            for (int i = diverseBefore; i < neighbors.size() && nSelected < maxDegree; ++i) {
                ScoreFunction sf;
                float cScore;
                int cNode;
                if (selected.get(i) || !VamanaDiversityProvider.isDiverse(cNode = neighbors.getNode(i), cScore = neighbors.getScore(i), neighbors, sf = this.scoreProvider.diversityProviderFor(cNode).scoreFunction(), selected, currentAlpha)) continue;
                selected.set(i);
                ++nSelected;
            }
            if (currentAlpha == 1.0f) {
                shortEdges = (float)nSelected / (float)maxDegree;
            }
            currentAlpha += 0.2f;
        }
        return shortEdges;
    }

    private static boolean isDiverse(int node, float score, NodeArray others, ScoreFunction sf, BitSet selected, float alpha) {
        int otherNode;
        assert (others.size() > 0);
        int i = selected.nextSetBit(0);
        while (i != Integer.MAX_VALUE && node != (otherNode = others.getNode(i))) {
            if (sf.similarityTo(otherNode) > score * alpha) {
                return false;
            }
            i = selected.nextSetBit(i + 1);
        }
        return true;
    }
}

