/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk.feature;

import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.graph.disk.CommonHeader;
import io.github.jbellis.jvector.graph.disk.feature.Feature;
import io.github.jbellis.jvector.graph.disk.feature.FeatureId;
import io.github.jbellis.jvector.graph.disk.feature.FeatureSource;
import io.github.jbellis.jvector.graph.disk.feature.NVQ;
import io.github.jbellis.jvector.graph.disk.feature.SeparatedFeature;
import io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import io.github.jbellis.jvector.quantization.NVQScorer;
import io.github.jbellis.jvector.quantization.NVQuantization;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;

public class SeparatedNVQ
implements SeparatedFeature {
    private final NVQuantization nvq;
    private final NVQScorer scorer;
    private final ThreadLocal<NVQuantization.QuantizedVector> reusableQuantizedVector;
    private long offset;

    public SeparatedNVQ(NVQuantization nvq, long offset) {
        this.nvq = nvq;
        this.offset = offset;
        this.scorer = new NVQScorer(this.nvq);
        this.reusableQuantizedVector = ThreadLocal.withInitial(() -> NVQuantization.QuantizedVector.createEmpty(nvq.subvectorSizesAndOffsets, nvq.bitsPerDimension));
    }

    @Override
    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public FeatureId id() {
        return FeatureId.SEPARATED_NVQ;
    }

    @Override
    public int headerSize() {
        return this.nvq.compressorSize() + 8;
    }

    @Override
    public int featureSize() {
        return this.nvq.compressedVectorSize();
    }

    @Override
    public void writeHeader(DataOutput out) throws IOException {
        this.nvq.write(out, 5);
        out.writeLong(this.offset);
    }

    @Override
    public void writeSeparately(DataOutput out, Feature.State state_) throws IOException {
        NVQ.State state = (NVQ.State)state_;
        if (state.vector != null) {
            state.vector.write(out);
        } else {
            NVQuantization.QuantizedVector.createEmpty(this.nvq.subvectorSizesAndOffsets, this.nvq.bitsPerDimension).write(out);
        }
    }

    static SeparatedNVQ load(CommonHeader header, RandomAccessReader reader) {
        try {
            NVQuantization nvq = NVQuantization.load(reader);
            long offset = reader.readLong();
            return new SeparatedNVQ(nvq, offset);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public int dimension() {
        return this.nvq.globalMean.length();
    }

    ScoreFunction.ExactScoreFunction rerankerFor(VectorFloat<?> queryVector, VectorSimilarityFunction vsf, FeatureSource source) {
        NVQScorer.NVQScoreFunction function = this.scorer.scoreFunctionFor(queryVector, vsf);
        return node2 -> {
            try {
                RandomAccessReader reader = source.featureReaderForNode(node2, FeatureId.SEPARATED_NVQ);
                NVQuantization.QuantizedVector.loadInto(reader, this.reusableQuantizedVector.get());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return function.similarityTo(this.reusableQuantizedVector.get());
        };
    }
}

