/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.util;

import io.github.jbellis.jvector.util.IntMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;

public class SparseIntMap<T>
implements IntMap<T> {
    private final ConcurrentHashMap<Integer, T> map = new ConcurrentHashMap();

    @Override
    public boolean compareAndPut(int key, T existing, T value) {
        if (value == null) {
            throw new IllegalArgumentException("compareAndPut() value cannot be null -- use remove() instead");
        }
        if (existing == null) {
            T result = this.map.putIfAbsent(key, value);
            return result == null;
        }
        return this.map.replace(key, existing, value);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public T get(int key) {
        return this.map.get(key);
    }

    @Override
    public T remove(int key) {
        return this.map.remove(key);
    }

    @Override
    public boolean containsKey(int key) {
        return this.map.containsKey(key);
    }

    public IntStream keysStream() {
        return this.map.keySet().stream().mapToInt(key -> key);
    }

    @Override
    public void forEach(IntMap.IntBiConsumer<T> consumer) {
        this.map.forEach(consumer::consume);
    }
}

