/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.disk;

import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.disk.ReaderSupplier;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemorySegmentReader
implements RandomAccessReader {
    private static final Logger logger = LoggerFactory.getLogger(MemorySegmentReader.class);
    private static final int MADV_RANDOM = 1;
    private static final ValueLayout.OfInt intLayout = ValueLayout.JAVA_INT_UNALIGNED.withOrder(ByteOrder.BIG_ENDIAN);
    private static final ValueLayout.OfFloat floatLayout = ValueLayout.JAVA_FLOAT_UNALIGNED.withOrder(ByteOrder.BIG_ENDIAN);
    private static final ValueLayout.OfLong longLayout = ValueLayout.JAVA_LONG_UNALIGNED.withOrder(ByteOrder.BIG_ENDIAN);
    final MemorySegment memory;
    private long position = 0L;

    MemorySegmentReader(MemorySegment memory) {
        this.memory = memory;
    }

    @Override
    public void seek(long offset) {
        this.position = offset;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public void readFully(float[] buffer) {
        MemorySegment.copy(this.memory, floatLayout, this.position, buffer, 0, buffer.length);
        this.position += (long)buffer.length * 4L;
    }

    @Override
    public void readFully(byte[] b) {
        MemorySegment.copy(this.memory, ValueLayout.JAVA_BYTE, this.position, b, 0, b.length);
        this.position += (long)b.length;
    }

    @Override
    public void readFully(ByteBuffer buffer) {
        int remaining = buffer.remaining();
        ByteBuffer slice = this.memory.asSlice(this.position, remaining).asByteBuffer();
        buffer.put(slice);
        this.position += (long)remaining;
    }

    @Override
    public void readFully(long[] vector) {
        MemorySegment.copy(this.memory, longLayout, this.position, vector, 0, vector.length);
        this.position += (long)vector.length * 8L;
    }

    @Override
    public int readInt() {
        int k = this.memory.get(intLayout, this.position);
        this.position += 4L;
        return k;
    }

    @Override
    public long readLong() {
        long l = this.memory.get(longLayout, this.position);
        this.position += 8L;
        return l;
    }

    @Override
    public float readFloat() {
        float f = this.memory.get(floatLayout, this.position);
        this.position += 4L;
        return f;
    }

    @Override
    public void read(int[] ints, int offset, int count) {
        MemorySegment.copy(this.memory, intLayout, this.position, ints, offset, count);
        this.position += (long)count * 4L;
    }

    @Override
    public void read(float[] floats, int offset, int count) {
        MemorySegment.copy(this.memory, floatLayout, this.position, floats, offset, count);
        this.position += (long)count * 4L;
    }

    public void loadMemory() {
        this.memory.load();
    }

    @Override
    public void close() {
    }

    public static class Supplier
    implements ReaderSupplier {
        private final Arena arena = Arena.ofShared();
        private final MemorySegment memory;

        public Supplier(Path path) throws IOException {
            try (FileChannel ch = FileChannel.open(path, StandardOpenOption.READ);){
                this.memory = ch.map(FileChannel.MapMode.READ_ONLY, 0L, ch.size(), this.arena);
                Linker linker = Linker.nativeLinker();
                Optional<MemorySegment> maybeMadvise = linker.defaultLookup().find("posix_madvise");
                if (maybeMadvise.isPresent()) {
                    MethodHandle madvise = linker.downcallHandle(maybeMadvise.get(), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT), new Linker.Option[0]);
                    int result = madvise.invokeExact(this.memory, this.memory.byteSize(), 1);
                    if (result != 0) {
                        throw new IOException("posix_madvise failed with error code: " + result);
                    }
                } else {
                    logger.warn("posix_madvise not found, MADV_RANDOM advice not applied");
                }
            }
            catch (Throwable e) {
                this.arena.close();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
        }

        @Override
        public MemorySegmentReader get() {
            return new MemorySegmentReader(this.memory);
        }

        @Override
        public void close() {
            this.arena.close();
        }
    }
}

