/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.annotations.VisibleForTesting;
import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.disk.ReaderSupplier;
import io.github.jbellis.jvector.graph.GraphIndex;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.graph.RandomAccessVectorValues;
import io.github.jbellis.jvector.graph.disk.CommonHeader;
import io.github.jbellis.jvector.graph.disk.Header;
import io.github.jbellis.jvector.graph.disk.OnDiskGraphIndexWriter;
import io.github.jbellis.jvector.graph.disk.feature.Feature;
import io.github.jbellis.jvector.graph.disk.feature.FeatureId;
import io.github.jbellis.jvector.graph.disk.feature.FeatureSource;
import io.github.jbellis.jvector.graph.disk.feature.FusedADC;
import io.github.jbellis.jvector.graph.disk.feature.InlineVectors;
import io.github.jbellis.jvector.graph.disk.feature.NVQ;
import io.github.jbellis.jvector.graph.disk.feature.SeparatedFeature;
import io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import io.github.jbellis.jvector.util.Accountable;
import io.github.jbellis.jvector.util.Bits;
import io.github.jbellis.jvector.util.RamUsageEstimator;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.VectorizationProvider;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import io.github.jbellis.jvector.vector.types.VectorTypeSupport;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.agrona.collections.Int2ObjectHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnDiskGraphIndex
implements GraphIndex,
AutoCloseable,
Accountable {
    private static final Logger logger = LoggerFactory.getLogger(OnDiskGraphIndex.class);
    public static final int CURRENT_VERSION = 4;
    static final int MAGIC = -62111;
    static final VectorTypeSupport vectorTypeSupport = VectorizationProvider.getInstance().getVectorTypeSupport();
    final ReaderSupplier readerSupplier;
    final int version;
    final int dimension;
    final GraphIndex.NodeAtLevel entryNode;
    final int idUpperBound;
    final int inlineBlockSize;
    final EnumMap<FeatureId, ? extends Feature> features;
    final EnumMap<FeatureId, Integer> inlineOffsets;
    private final List<CommonHeader.LayerInfo> layerInfo;
    private final long neighborsOffset;
    private volatile AtomicReference<List<Int2ObjectHashMap<int[]>>> inMemoryNeighbors;

    OnDiskGraphIndex(ReaderSupplier readerSupplier, Header header, long neighborsOffset) {
        this.readerSupplier = readerSupplier;
        this.version = header.common.version;
        this.layerInfo = header.common.layerInfo;
        this.dimension = header.common.dimension;
        this.entryNode = new GraphIndex.NodeAtLevel(header.common.layerInfo.size() - 1, header.common.entryNode);
        this.idUpperBound = header.common.idUpperBound;
        this.features = header.features;
        this.neighborsOffset = neighborsOffset;
        int inlineBlockSize = 0;
        this.inlineOffsets = new EnumMap(FeatureId.class);
        for (Map.Entry<FeatureId, ? extends Feature> entry : this.features.entrySet()) {
            Feature feature = entry.getValue();
            if (feature instanceof SeparatedFeature) continue;
            this.inlineOffsets.put(entry.getKey(), inlineBlockSize);
            inlineBlockSize += feature.featureSize();
        }
        this.inlineBlockSize = inlineBlockSize;
        this.inMemoryNeighbors = new AtomicReference<Object>(null);
    }

    private List<Int2ObjectHashMap<int[]>> loadInMemoryLayers(RandomAccessReader in) throws IOException {
        ArrayList<Int2ObjectHashMap<int[]>> imn = new ArrayList<Int2ObjectHashMap<int[]>>(this.layerInfo.size());
        imn.add(null);
        long L0size = 0L;
        L0size = (long)this.idUpperBound * ((long)this.inlineBlockSize + 4L * (2L + (long)this.layerInfo.get((int)0).degree));
        in.seek(this.neighborsOffset + L0size);
        for (int lvl = 1; lvl < this.layerInfo.size(); ++lvl) {
            CommonHeader.LayerInfo info = this.layerInfo.get(lvl);
            Int2ObjectHashMap edges = new Int2ObjectHashMap();
            for (int i = 0; i < info.size; ++i) {
                int nodeId = in.readInt();
                assert (nodeId >= 0 && nodeId < this.layerInfo.get((int)0).size) : String.format("Node ID %d out of bounds for layer %d", nodeId, lvl);
                int neighborCount = in.readInt();
                assert (neighborCount >= 0 && neighborCount <= info.degree) : String.format("Node %d neighborCount %d > M %d", nodeId, neighborCount, info.degree);
                int[] neighbors = new int[neighborCount];
                in.read(neighbors, 0, neighborCount);
                int skip = info.degree - neighborCount;
                if (skip > 0) {
                    in.seek(in.getPosition() + (long)skip * 4L);
                }
                edges.put(nodeId, (Object)neighbors);
            }
            imn.add((Int2ObjectHashMap<int[]>)edges);
        }
        return imn;
    }

    public static OnDiskGraphIndex load(ReaderSupplier readerSupplier, long offset) {
        OnDiskGraphIndex onDiskGraphIndex;
        block8: {
            RandomAccessReader reader = readerSupplier.get();
            try {
                logger.debug("Loading OnDiskGraphIndex from offset={}", (Object)offset);
                Header header = Header.load(reader, offset);
                logger.debug("Header loaded: version={}, dimension={}, entryNode={}, layerInfoCount={}", new Object[]{header.common.version, header.common.dimension, header.common.entryNode, header.common.layerInfo.size()});
                logger.debug("Position after reading header={}", (Object)reader.getPosition());
                onDiskGraphIndex = new OnDiskGraphIndex(readerSupplier, header, reader.getPosition());
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error initializing OnDiskGraph at offset " + offset, e);
                }
            }
            reader.close();
        }
        return onDiskGraphIndex;
    }

    public static OnDiskGraphIndex load(ReaderSupplier readerSupplier) {
        return OnDiskGraphIndex.load(readerSupplier, 0L);
    }

    public Set<FeatureId> getFeatureSet() {
        return this.features.keySet();
    }

    public int getDimension() {
        return this.dimension;
    }

    @Override
    public int size(int level) {
        return this.layerInfo.get((int)level).size;
    }

    @Override
    public int getDegree(int level) {
        return this.layerInfo.get((int)level).degree;
    }

    @Override
    public int getIdUpperBound() {
        return this.idUpperBound;
    }

    @Override
    public NodesIterator getNodes(int level) {
        NodesIterator.ArrayNodesIterator arrayNodesIterator;
        block10: {
            int size = this.size(level);
            int maxDegree = this.getDegree(level);
            long layer0NodeSize = 4L + (long)this.inlineBlockSize + 4L * (long)(maxDegree + 1);
            long layerUpperNodeSize = 4L + 4L * (long)(maxDegree + 1);
            long thisLayerNodeSide = level == 0 ? layer0NodeSize : layerUpperNodeSize;
            long layerOffset = this.neighborsOffset;
            layerOffset += level > 0 ? layer0NodeSize * (long)this.size(0) : 0L;
            for (int lvl = 1; lvl < level; ++lvl) {
                layerOffset += layerUpperNodeSize * (long)this.size(lvl);
            }
            RandomAccessReader reader = this.readerSupplier.get();
            try {
                int[] valid_nodes = new int[this.size(level)];
                int upperBound = level == 0 ? this.getIdUpperBound() : this.size(level);
                int pos = 0;
                for (int node = 0; node < upperBound; ++node) {
                    long node_offset = layerOffset + (long)node * thisLayerNodeSide;
                    reader.seek(node_offset);
                    if (reader.readInt() == -1) continue;
                    valid_nodes[pos++] = node;
                }
                arrayNodesIterator = new NodesIterator.ArrayNodesIterator(valid_nodes, size);
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            reader.close();
        }
        return arrayNodesIterator;
    }

    @Override
    public long ramBytesUsed() {
        return (long)(32 + RamUsageEstimator.NUM_BYTES_OBJECT_REF) + 2L * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF * (long)FeatureId.values().length;
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return String.format("OnDiskGraphIndex(layers=%s, entryPoint=%s, features=%s)", this.layerInfo, this.entryNode, this.features.keySet().stream().map(Enum::name).collect(Collectors.joining(",")));
    }

    @Override
    public int getMaxLevel() {
        return this.entryNode.level;
    }

    @Override
    public int maxDegree() {
        return this.layerInfo.stream().mapToInt(li -> li.degree).max().orElseThrow();
    }

    @Override
    public View getView() {
        try {
            return new View(this.readerSupplier.get());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void write(GraphIndex graph, RandomAccessVectorValues vectors, Path path) throws IOException {
        OnDiskGraphIndex.write(graph, vectors, OnDiskGraphIndexWriter.sequentialRenumbering(graph), path);
    }

    public static void write(GraphIndex graph, RandomAccessVectorValues vectors, Map<Integer, Integer> oldToNewOrdinals, Path path) throws IOException {
        try (OnDiskGraphIndexWriter writer = new OnDiskGraphIndexWriter.Builder(graph, path).withMap(oldToNewOrdinals).with(new InlineVectors(vectors.dimension())).build();){
            EnumMap<FeatureId, IntFunction<Feature.State>> suppliers = Feature.singleStateFactory(FeatureId.INLINE_VECTORS, nodeId -> new InlineVectors.State(vectors.getVector(nodeId)));
            writer.write(suppliers);
        }
    }

    @VisibleForTesting
    static boolean areHeadersEqual(OnDiskGraphIndex g1, OnDiskGraphIndex g2) {
        return g1.version == g2.version && g1.dimension == g2.dimension && g1.entryNode.equals(g2.entryNode) && g1.layerInfo.equals(g2.layerInfo);
    }

    public class View
    implements FeatureSource,
    GraphIndex.ScoringView,
    RandomAccessVectorValues {
        protected final RandomAccessReader reader;
        private final int[] neighbors;

        public View(RandomAccessReader reader) {
            this.reader = reader;
            this.neighbors = new int[OnDiskGraphIndex.this.layerInfo.stream().mapToInt(li -> li.degree).max().orElse(0)];
        }

        @Override
        public int dimension() {
            return OnDiskGraphIndex.this.dimension;
        }

        @Override
        public boolean isValueShared() {
            return false;
        }

        @Override
        public RandomAccessVectorValues copy() {
            throw new UnsupportedOperationException();
        }

        protected long offsetFor(int node, FeatureId featureId) {
            Feature feature = OnDiskGraphIndex.this.features.get((Object)featureId);
            if (feature instanceof SeparatedFeature) {
                SeparatedFeature sf = (SeparatedFeature)feature;
                return sf.getOffset() + (long)node * (long)feature.featureSize();
            }
            return OnDiskGraphIndex.this.neighborsOffset + (long)node * (4L + (long)OnDiskGraphIndex.this.inlineBlockSize + 4L * (long)(OnDiskGraphIndex.this.layerInfo.get((int)0).degree + 1)) + 4L + (long)OnDiskGraphIndex.this.inlineOffsets.get((Object)featureId).intValue();
        }

        private long neighborsOffsetFor(int level, int node) {
            assert (level == 0);
            int degree = OnDiskGraphIndex.this.layerInfo.get((int)level).degree;
            long skipInline = 4 + OnDiskGraphIndex.this.inlineBlockSize;
            long blockBytes = skipInline + 4L * (long)(degree + 1);
            long offsetWithinLayer = blockBytes * (long)node;
            return OnDiskGraphIndex.this.neighborsOffset + offsetWithinLayer + skipInline;
        }

        @Override
        public RandomAccessReader featureReaderForNode(int node, FeatureId featureId) throws IOException {
            long offset = this.offsetFor(node, featureId);
            this.reader.seek(offset);
            return this.reader;
        }

        @Override
        public VectorFloat<?> getVector(int node) {
            Feature feature = OnDiskGraphIndex.this.features.get((Object)FeatureId.INLINE_VECTORS);
            if (feature == null) {
                feature = OnDiskGraphIndex.this.features.get((Object)FeatureId.SEPARATED_VECTORS);
            }
            if (feature == null) {
                throw new UnsupportedOperationException("No full-resolution vectors in this graph");
            }
            try {
                long offset = this.offsetFor(node, feature.id());
                this.reader.seek(offset);
                return vectorTypeSupport.readFloatVector(this.reader, OnDiskGraphIndex.this.dimension);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void getVectorInto(int node, VectorFloat<?> vector, int offset) {
            Feature feature = OnDiskGraphIndex.this.features.get((Object)FeatureId.INLINE_VECTORS);
            if (feature == null) {
                feature = OnDiskGraphIndex.this.features.get((Object)FeatureId.SEPARATED_VECTORS);
            }
            if (feature == null) {
                throw new UnsupportedOperationException("No full-resolution vectors in this graph");
            }
            try {
                long diskOffset = this.offsetFor(node, feature.id());
                this.reader.seek(diskOffset);
                vectorTypeSupport.readFloatVector(this.reader, OnDiskGraphIndex.this.dimension, vector, offset);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public NodesIterator getNeighborsIterator(int level, int node) {
            try {
                if (level == 0) {
                    this.reader.seek(this.neighborsOffsetFor(level, node));
                    int neighborCount = this.reader.readInt();
                    assert (neighborCount <= this.neighbors.length) : String.format("Node %d neighborCount %d > M %d", node, neighborCount, this.neighbors.length);
                    this.reader.read(this.neighbors, 0, neighborCount);
                    return new NodesIterator.ArrayNodesIterator(this.neighbors, neighborCount);
                }
                List<Int2ObjectHashMap<int[]>> imn = OnDiskGraphIndex.this.inMemoryNeighbors.updateAndGet(current -> {
                    if (current != null) {
                        return current;
                    }
                    try {
                        return OnDiskGraphIndex.this.loadInMemoryLayers(this.reader);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
                int[] stored = (int[])imn.get(level).get(node);
                assert (stored != null) : String.format("No neighbors found for node %d at level %d", node, level);
                return new NodesIterator.ArrayNodesIterator(stored, stored.length);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public int size() {
            return OnDiskGraphIndex.this.size(0);
        }

        @Override
        public GraphIndex.NodeAtLevel entryNode() {
            return OnDiskGraphIndex.this.entryNode;
        }

        @Override
        public int getIdUpperBound() {
            return OnDiskGraphIndex.this.idUpperBound;
        }

        @Override
        public Bits liveNodes() {
            return Bits.ALL;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        @Override
        public ScoreFunction.ExactScoreFunction rerankerFor(VectorFloat<?> queryVector, VectorSimilarityFunction vsf) {
            if (OnDiskGraphIndex.this.features.containsKey((Object)FeatureId.INLINE_VECTORS)) {
                return RandomAccessVectorValues.super.rerankerFor(queryVector, vsf);
            }
            if (OnDiskGraphIndex.this.features.containsKey((Object)FeatureId.NVQ_VECTORS)) {
                return ((NVQ)OnDiskGraphIndex.this.features.get((Object)FeatureId.NVQ_VECTORS)).rerankerFor(queryVector, vsf, this);
            }
            throw new UnsupportedOperationException("No reranker available for this graph");
        }

        @Override
        public ScoreFunction.ApproximateScoreFunction approximateScoreFunctionFor(VectorFloat<?> queryVector, VectorSimilarityFunction vsf) {
            if (OnDiskGraphIndex.this.features.containsKey((Object)FeatureId.FUSED_ADC)) {
                return ((FusedADC)OnDiskGraphIndex.this.features.get((Object)FeatureId.FUSED_ADC)).approximateScoreFunctionFor(queryVector, vsf, this, this.rerankerFor(queryVector, vsf));
            }
            throw new UnsupportedOperationException("No approximate score function available for this graph");
        }
    }
}

