/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.quantization;

import io.github.jbellis.jvector.quantization.BQVectors;
import io.github.jbellis.jvector.quantization.BinaryQuantization;
import io.github.jbellis.jvector.quantization.MutableCompressedVectors;

public class MutableBQVectors
extends BQVectors
implements MutableCompressedVectors<long[]> {
    private static final int INITIAL_CAPACITY = 1024;
    private static final float GROWTH_FACTOR = 1.5f;
    protected int vectorCount;

    public MutableBQVectors(BinaryQuantization bq) {
        super(bq);
        this.compressedVectors = new long[1024][];
        this.vectorCount = 0;
    }

    private void ensureCapacity(int ordinal) {
        if (ordinal >= this.compressedVectors.length) {
            int newCapacity = Math.max(ordinal + 1, (int)((float)this.compressedVectors.length * 1.5f));
            long[][] newVectors = new long[newCapacity][];
            System.arraycopy(this.compressedVectors, 0, newVectors, 0, this.compressedVectors.length);
            this.compressedVectors = newVectors;
        }
    }

    @Override
    public void encodeAndSet(int ordinal, long[] vector) {
        this.ensureCapacity(ordinal);
        this.compressedVectors[ordinal] = vector;
        this.vectorCount = Math.max(this.vectorCount, ordinal + 1);
    }

    @Override
    public void setZero(int ordinal) {
        this.ensureCapacity(ordinal);
        this.compressedVectors[ordinal] = new long[this.bq.compressedVectorSize()];
        this.vectorCount = Math.max(this.vectorCount, ordinal + 1);
    }

    @Override
    public int count() {
        return this.vectorCount;
    }
}

