/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.graph.GraphIndex;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.graph.disk.GraphCache;
import io.github.jbellis.jvector.graph.disk.OnDiskGraphIndex;
import io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import io.github.jbellis.jvector.util.Accountable;
import io.github.jbellis.jvector.util.Bits;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import java.io.IOException;

public class CachingGraphIndex
implements GraphIndex,
Accountable {
    private static final int CACHE_DISTANCE = 3;
    private final GraphCache cache_;
    private final OnDiskGraphIndex graph;

    public CachingGraphIndex(OnDiskGraphIndex graph) {
        this(graph, 3);
    }

    public CachingGraphIndex(OnDiskGraphIndex graph, int cacheDistance) {
        this.graph = graph;
        this.cache_ = GraphCache.load(graph, cacheDistance);
    }

    @Override
    public int size() {
        return this.graph.size();
    }

    @Override
    public NodesIterator getNodes() {
        return this.graph.getNodes();
    }

    @Override
    public GraphIndex.ScoringView getView() {
        return new View(this.cache_, this.graph.getView());
    }

    @Override
    public int maxDegree() {
        return this.graph.maxDegree();
    }

    @Override
    public long ramBytesUsed() {
        return this.graph.ramBytesUsed() + this.cache_.ramBytesUsed();
    }

    @Override
    public void close() throws IOException {
        this.graph.close();
    }

    public String toString() {
        return String.format("CachingGraphIndex(graph=%s)", this.graph);
    }

    public static class View
    implements GraphIndex.ScoringView {
        private final GraphCache cache;
        protected final OnDiskGraphIndex.View view;

        public View(GraphCache cache, OnDiskGraphIndex.View view) {
            this.cache = cache;
            this.view = view;
        }

        @Override
        public NodesIterator getNeighborsIterator(int ordinal) {
            GraphCache.CachedNode node = this.cache.getNode(ordinal);
            if (node != null) {
                return new NodesIterator.ArrayNodesIterator(node.neighbors, node.neighbors.length);
            }
            return this.view.getNeighborsIterator(ordinal);
        }

        @Override
        public int size() {
            return this.view.size();
        }

        @Override
        public int entryNode() {
            return this.view.entryNode();
        }

        @Override
        public Bits liveNodes() {
            return this.view.liveNodes();
        }

        @Override
        public void close() throws IOException {
            this.view.close();
        }

        @Override
        public ScoreFunction.ExactScoreFunction rerankerFor(VectorFloat<?> queryVector, VectorSimilarityFunction vsf) {
            return this.view.rerankerFor(queryVector, vsf);
        }

        @Override
        public ScoreFunction.ApproximateScoreFunction approximateScoreFunctionFor(VectorFloat<?> queryVector, VectorSimilarityFunction vsf) {
            return this.view.approximateScoreFunctionFor(queryVector, vsf);
        }
    }
}

